/*
 *CheckBoxWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;

import javax.servlet.ServletException;

import nga.servlet.config.TargetInfo;

/**
 * input type="checkbox" pC^B
 */
public class CheckBoxWriter extends TargetValueWriter {

	/**
	 * CheckBoxWriter 쐬B
	 */
	public CheckBoxWriter() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write()
	 */
	@Override
	public void write() throws IOException, ServletException {
		TargetInfo ti = targetValue.getTargetInfo();
		Object resultObject = targetValue.getResultObject();
		print("<input").attr("type", getType()).attr("id", ti.getId()).attr("name", ti.getValue());
		attr("class", ti, resultObject);

		setValue();

		if(!ti.getAttribute("visible", resultObject, true)) {
			attr("style", "display:none");
		}
		if(ti.getAttribute("disabled", resultObject, false)) {
			attr("disabled", "disabled");
		}

		Object onchanged = ti.getAttribute("onchanged", resultObject);
		if(onchanged==null) {
			onchanged = ti.getAttribute("onchange", resultObject);
		}
		
		StringBuilder onchangeScript = new StringBuilder();
		onchangeScript.append(getOnchangeScript());

		if(onchanged!=null) {
			onchangeScript.append(onchanged);
		}
		else {
			Object request = ti.getAttribute("request-onchanged", resultObject);
			if(request!=null) {
				onchangeScript.append(onchanged).append("new CongaRequest().send(\'" + request + "\');");
			}
		}

		if(onchangeScript.length() > 0) {
			attr("onchange", onchangeScript);
		}

		print("/>");
	}

	/**
	 * onchange ɕKsXNvg擾B
	 * @return onchange ɕKsXNvgB
	 */
	protected String getOnchangeScript() {
		return "this.value=(this.checked)?\'true\':\'false\';";
	}
	
	/**
	 * type l擾B
	 * @return type lB
	 */
	protected String getType() {
		return "checkbox";
	}

	/**
	 * value  checked ̐ݒsȂB
	 */
	protected void setValue() {
		boolean value = getValue();
		attr("value", (value)?"true":"false");
		if(value) {
			attr("checked", "checked");
		}
	}
	
	private boolean getValue() {
		Object valueObject = targetValue.getValue();
		if(valueObject instanceof Boolean) {
			return ((Boolean)valueObject).booleanValue();
		}
		else if(valueObject instanceof String) {
			return Boolean.parseBoolean((String)valueObject);
		}
		else if(valueObject!=null) {
			return Boolean.parseBoolean(valueObject.toString());
		}
		else {
			return false;
		}
	}

}
