/*
 *DefaultResultWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nga.servlet.ErrorInfo;
import nga.servlet.ServiceInfo;
import nga.servlet.WriterUtil;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.util.ConfigurationException;
import nga.util.MethodOperator;

/**
 * {@link nga.servlet.spi.ResultWriter ResultWriter} ̃ftHgB
 */
public class DefaultResultWriter extends AbstractResultWriter {
	
	/** ftHg TargetValueWriter */
	public static final TargetValueWriter DEFAULT = new DefaultTargetValueWriter();

	/**
	 * TargetValue  request ւ̐ݒ蕶B
	 */
	private static final String TARGET_VALUE = "nga.dsp.target.value";

	private Map<Class, TargetValueWriter> valueWriterMap = new HashMap<Class, TargetValueWriter>();
	private Map<String, Method> methodMap;

	/**
	 * DefaultResultWriter 쐬B
	 */
	public DefaultResultWriter() {
	}
	
	/**
	 * @see AbstractResultWriter#handleWrite(ServiceInfo)
	 */
	@Override
	protected void handleWrite(ServiceInfo serviceInfo) throws IOException, ServletException {
		Object resultObject = serviceInfo.getResultObject();

		HttpServletResponse response = serviceInfo.getResponse();

		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setDateHeader("Expires", 0);
		response.setContentType("text/xml; charset=UTF-8");

		PrintWriter writer = response.getWriter();
		writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		writer.print("<c");

		// ErrorInfo ̏sȂB
		ErrorInfo errorInfo = serviceInfo.getErrorInfo();
		if(errorInfo.getException()!=null) {
			errorInfo.getException().printStackTrace();
			String s = errorInfo.getException().getMessage();
			if(s==null) {
				s = errorInfo.getException().getClass().getName();
			}
			printMessage(writer, s);
		}
		else if(errorInfo.getErrorMessage()!=null) {
			System.err.println(errorInfo.getErrorMessage());
			printMessage(writer, errorInfo.getErrorMessage());
		}

		if(errorInfo.hasError()) {
			writer.print(" is-error=\"true\"");
		}
		writer.println(">");

		if(resultObject!=null) {
			methodMap = MethodOperator.getGetterMethods(resultObject.getClass());
		}
		
		// ʏo͂sȂB
		TargetInfoList targetInfoList = serviceInfo.getTargetInfoList();
		for(int i=0; i<targetInfoList.size(); i++) {
			TargetInfo ti = targetInfoList.get(i);

			writer.print("<e");

			ErrorInfo.Item item = errorInfo.get(ti.getValue());
			if(item!=null) {
				writer.print(" is-error=\"true\"");
				String message = item.getMessage();
				if(message!=null) {
					printMessage(writer, message);
				}
			}

			String include = ti.getInclude();

			boolean cdata = true;
			TargetValueWriter valueWriter = null;
			if(include==null) {
				valueWriter = getWriter(ti);
				cdata = valueWriter.isCdataSection();
			}

			String type = ti.getType();
			
			if(type!=null) {
				WriterUtil.attr(writer, "type", type);
			}
			
			Object o = null;
			try {
				String valueName = ti.getValue();
				if(valueName!=null && resultObject!=null) {
					o = MethodOperator.get(methodMap.get(valueName), resultObject);
				}
			}
			catch (IllegalAccessException e) {
				throw new ServletException(e);
			}
			catch (InvocationTargetException e) {
				throw new ServletException(e.getCause());
			}

			TargetValue targetValue = new TargetValue(serviceInfo, writer, resultObject);

			targetValue.setup(o, ti);
			HttpServletRequest request = serviceInfo.getRequest();
			request.setAttribute(TARGET_VALUE, targetValue);
			
			for(Map.Entry<String,String> attrEntry : ti.entrySet()) {
				String attrName = attrEntry.getKey();
				if("value".equals(attrName) || "type".equals(attrName) ||
						"include".equals(attrName) || "writer".equals(attrName)) {
					continue;
				}
				WriterUtil.attr(writer, attrName, ti, resultObject);
			}

			if(valueWriter!=null) {
				valueWriter.setTargetValue(targetValue);
				valueWriter.writeAttribute();
			}
			
			if(cdata) {
				writer.print("><![CDATA[");
			}
			else {
				writer.print(">");
			}
			
			if(include!=null) {
				// include w肪ꍇ include B
				request.getRequestDispatcher(include).include(request, response);
			}
			else {
				valueWriter.write();
			}

			if(cdata) {
				writer.println("]]>");
			}
			
			writer.println("</e>");
		}
		writer.println("</c>");
	}

	/**
	 * bZ[W message ̒lƂďo͂B
	 * @param writer o͐B
	 * @param message bZ[WB
	 */
	private void printMessage(PrintWriter writer, String message) {
		WriterUtil.attr(writer, "message", message);
	}

	/**
	 * w肳ꂽ target ^OɓK TargetValueWriter 擾B
	 * @param ti target ^OB
	 * @return TargetValueWriterB
	 */
	private TargetValueWriter getWriter(TargetInfo ti) {
		String writerName = ti.get("writer");
		if(writerName!=null) {
			return getWriter(writerName, ti.getModuleInfo());
		}
		else {
			return DEFAULT;
		}
	}

	/**
	 * w肳ꂽO TargetValueWriter 擾B
	 * @param writerName TargetValueWriter ̖OB
	 * @return TargetValueWriterB
	 */
	@SuppressWarnings("unchecked")
	private TargetValueWriter getWriter(String writerName, ModuleInfo moduleInfo)  {
		TargetValueWriter writer = valueWriterMap.get(writerName);
		if(writer==null) {
			Class c;
			try {
				c = Class.forName(writerName);
				writer = (TargetValueWriter)c.newInstance();
				valueWriterMap.put(c, writer);
			}
			catch (Exception e) {
				throw new ConfigurationException(
					moduleInfo.getMessage(
						"dspm.invalid_writer_class", writerName
					), e);
			}
		}
		return writer;
	}
	
	/**
	 * ݏΏۂƂȂĂ TargetValue 擾B
	 * @param request NGXgB
	 * @return ݏΏۂƂȂĂ TargetValueB
	 */
	public static TargetValue getTargetValue(HttpServletRequest request) {
		return (TargetValue)request.getAttribute(TARGET_VALUE);
	}
}