/*
 *TextInputWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;

import javax.servlet.ServletException;

import nga.servlet.ErrorInfo;
import nga.servlet.config.TargetInfo;

/**
 * input type="text" ^OpC^B
 */
public class TextInputWriter extends TargetValueWriter {

	/**
	 * TextInputWriter 쐬B
	 */
	public TextInputWriter() {
		super();
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write()
	 */
	@Override
	public void write() throws IOException, ServletException {
		TargetInfo ti = targetValue.getTargetInfo();
		Object resultObject = targetValue.getResultObject();
		StringBuilder style = new StringBuilder();
		print("<input").attr("type", "text").attr("id", ti.getId());
		attr("class", ti, resultObject);
		

		String inputType = ti.get("input-type", "text");
		if("number".equals(inputType)) {
			attr("onfocus", "ITextInput.delComma(this)");
			style.append("ime-mode:disabled;text-align:right;");

			int length = ti.get("length", Integer.MAX_VALUE-2);
			boolean positiveOnly = ti.get("positive-only", false);
			int scale = ti.get("scale", 0);
			attr("onkeypress", (scale > 0)? "ITextInput.chkDec(event)" : "ITextInput.chkInt(event)");
			int ilen = length;
			if(scale > 0) {
				ilen = length - scale;
				length++; // dot
			}
			if(!positiveOnly) {
				length++; // -
			}
			attr("maxlength", length);
			attr("onchange", "ITextInput.chkNum(event,this,"+ilen+","+scale+","+positiveOnly+")");
		}
		else {
			attr("onfocus", "this.select()");
			int length = ti.get("length", 0);
			if(length > 0) {
				attr("maxlength", length);
			}
			if("alnum".equals(inputType)) {
				attr("onchange", "ITextInput.chkAlnum(event,this)");
			}
			if("alnum".equals(inputType) || "date".equals(inputType) || "time".equals(inputType)) {
				style.append("ime-mode:disabled;");
			}
		}
		
		attr("name", ti.getValue());

		ErrorInfo.Item errorItem = getErrorItem();
		Object errorValue = null;
		if(errorItem!=null) {
			style.append("background-color:pink;");
			String message = errorItem.getMessage();
			if(message!=null) {
				attr("title", message);
				style.append("cursor:help;");
			}
			errorValue = errorItem.getValue();
		}

		if(errorValue!=null) {
			attr("value", errorValue);
		}
		else {
			attr("value", targetValue.getValue(),getFormat(ti));
		}

		if(!ti.getAttribute("visible", resultObject, true)) {
			style.append("display:none;");
		}
		if(ti.getAttribute("disabled", resultObject, false)) {
			attr("disabled", "disabled");
		}
		if(ti.getAttribute("read-only", resultObject, false)) {
			attr("readonly", "readonly");
		}
		attr("style", new String(style));
		print("/>");
	}

}
