/*
 *TreeWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nga.model.TreeNode;
import nga.model.Tree;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;

/**
 * Tree pC^B
 */
public class TreeWriter extends TargetValueWriter {
	
	/**
	 * target ^OB
	 */
	protected TargetInfo targetInfo;
	
	/**
	 * m[h̃}bvB
	 */
	private Map<String, TargetInfo> nodeInfoMap;

	/**
	 * JԂ̃m[hACR摜t@C URLB
	 */
	private String openedNodeIcon;
	
	
	/**
	 * Ԃ̃m[hACR摜t@C URLB
	 */
	private String closedNodeIcon;

	/**
	 * JɊ֌WȂm[hACR摜t@C URLB
	 */
	private String nodeIcon;

	/**
	 * {ACR摜t@C URLB
	 */
	private String plusIcon;
	
	
	/**
	 * |ACR摜t@C URLB
	 */
	private String minusIcon;
	
	/**
	 * TreeWriter 쐬B
	 */
	public TreeWriter() {
		super();
	}

	/**
	 * o͂sȂB
	 */
	@Override
	public void write() throws IOException {
		init();
		printTree((Tree)targetValue.getValue());
	}
	

	/**
	 * ̃CX^X̏sȂB
	 */
	protected void init() {
		this.targetInfo = targetValue.getTargetInfo();
		TargetInfoList nodeInfoList = targetInfo.getChildren();
		if(nodeInfoList!=null && !nodeInfoList.isEmpty()) {
			nodeInfoMap = new HashMap<String, TargetInfo>();
			for(TargetInfo nodeInfo : nodeInfoList) {
				nodeInfoMap.put(nodeInfo.getType(), nodeInfo);
			}
		}
		openedNodeIcon = getOpenedNodeIcon(targetInfo);
		closedNodeIcon = getClosedNodeIcon(targetInfo);
		nodeIcon = getNodeIcon(targetInfo);
		plusIcon = getPlusIcon(targetInfo);
		minusIcon = getMinusIcon(targetInfo);
	}

	/**
	 * m[hJĂԂ킷ACRURL擾B
	 * @param targetInfo target ^OB
	 * @return ACR URLB
	 */
	public static String getOpenedNodeIcon(TargetInfo targetInfo) {
		return targetInfo.get("opened-node-icon", null);
	}

	/**
	 * m[hĂԂ킷ACRURL擾B
	 * @param targetInfo target ^OB
	 * @return ACR URLB
	 */
	public static String getClosedNodeIcon(TargetInfo targetInfo) {
		return targetInfo.get("closed-node-icon", null);
	}
	
	/**
	 * JɊ֌WȂm[h킷ACRURL擾B
	 * @param targetInfo target ^OB
	 * @return ACR URLB
	 */
	public static String getNodeIcon(TargetInfo targetInfo) {
		return targetInfo.get("node-icon", null);
	}
	
	/**
	 * {ACR摜t@C URL 擾B
	 * @param targetInfo target ^OB
	 * @return ACR URLB
	 */
	public static String getPlusIcon(TargetInfo targetInfo) {
		return targetInfo.get("plus-icon", null);
	}

	
	/**
	 * |ACR摜t@C URL 擾B
	 * @param targetInfo target ^OB
	 * @return ACR URLB
	 */
	public static String getMinusIcon(TargetInfo targetInfo) {
		return targetInfo.get("minus-icon", null);
	}

	/**
	 * c[o͂B
	 * @param tree o͑Ώۃc[B
	 */
	@SuppressWarnings("unchecked")
	protected void printTree(Tree tree) {
		print("<div");
		attr("class", "itree").attr("id", targetInfo.getId()).attr("style", "overflow:auto");
		println(">");

		print("<input type=\"hidden\" name=\"").print(targetInfo.getValue()).println("\">");

		printNode(tree.getRootNode());
		print("</div>");
	}

	/**
	 * m[ho͂B
	 * @param node o͑Ώۃm[hB
	 */
	@SuppressWarnings("unchecked")
	protected void printNode(TreeNode node) {
		print("<div class=\"node\" id=\"");
		print(node.getId());
		if(node.isRootNode()) {
			print("\" style=\"left:0px;");
		}
		println("\">");
		printOpenerIcon(node);
		printNodeIcon(node);
		printNodeValue(node);
		
		if(!node.isLeaf()) {
			print("<div class=\"children\" style=\"display:");
			print((node.isOpened())?"block":"none");
			println("\">");

			List<TreeNode> children = node.getChildren();
			for(TreeNode childNode : children) {
				printNode(childNode);
			}

			println("</div>");
		}
		print("</div>");
	}

	/**
	 * m[h̒lo͂B
	 * @param node
	 */
	@SuppressWarnings("unchecked")
	protected void printNodeValue(TreeNode node) {
		print(
			"<input class=\"value\" onfocus=\"this.select()\" readonly "+
			" onmouseover=\"this.style.textDecoration=\'underline\'\""+
			" onmouseout=\"this.style.textDecoration='none'\""+
			" onclick=\"ITree.input_onclick(event)\" onkeydown=\"ITree.input_onkeydown(event)\""+
			" value=\""
		);

		String nodeType = node.getNodeType();
		String format = null;
		if(nodeType!=null) {
			TargetInfo nodeInfo = nodeInfoMap.get(nodeType);
			if(nodeInfo!=null) {
				format = getFormat(nodeInfo);
			}
		}
		String value = WriterUtil.format(node.getNodeValue(), format);
		print(value).print("\" title=\"").print(value).println("\">");
	}

	/**
	 * { / | ACRo͂B
	 * @param node o͑Ώۃm[hB
	 */
	@SuppressWarnings("unchecked")
	protected void printOpenerIcon(TreeNode node) {
		print("<span class=\"opener\"");
		if(node.isLeaf()) {
			print(">");
		}
		else {
			print(" onmousedown=\"ITree.opener_onmousedown(event)\">");
			printIcon(node, minusIcon, plusIcon);
		}
		println("</span>");
	}
	
	@SuppressWarnings("unchecked")
	private void printIcon(TreeNode node, String openedIcon, String closedIcon) {
		if(openedIcon!=null && closedIcon!=null && !openedIcon.equals(closedIcon)) {
			print("<img src=\"");
			print(closedIcon);
			print("\"");
			print((node.isOpened())? " style=\"display:none\"" : "");
			print(">");
			print("<img src=\"");
			print(openedIcon);
			print("\"");
			print((node.isOpened())? "" : " style=\"display:none\"");
			print(">");
		}
		else {
			String icon = null;
			if(openedIcon!=null) {
				icon = openedIcon;
			}
			else if(closedIcon!=null) {
				icon = closedIcon;
			}

			if(icon!=null) {
				print("<img src=\"");
				print(icon);
				print("\">");
			}
		}
	}
	
	/**
	 * m[h킷ACRo͂B
	 * @param node o͑Ώۃm[hB
	 */
	@SuppressWarnings("unchecked")
	protected void printNodeIcon(TreeNode node) {
		TargetInfo nodeInfo = null;
		String nodeType = node.getNodeType();
		if(nodeType!=null && nodeInfoMap!=null) {
			nodeInfo = nodeInfoMap.get(nodeType);
		}
		String icon = getNodeIcon0(nodeInfo);

		print("<span class=\"icon\"");
		if(node.isLeaf()) {
			print(">");
			print("<img src=\"");
			print(icon);
			print("\">");	
		}
		else {
			print(" onclick=\"ITree.icon_onclick(event)\">");
			printIcon(node, 
						getOpenedNodeIcon0(nodeInfo, icon), getClosedNodeIcon0(nodeInfo, icon));
		}
		println("</span>");
	}
	
	private String getNodeIcon0(TargetInfo nodeInfo) {
		String icon;
		if(nodeInfo!=null) {
			icon = getNodeIcon(nodeInfo);
		}
		else {
			icon = nodeIcon;
		}
		return icon;
	}
	
	@SuppressWarnings("unchecked")
	private String getOpenedNodeIcon0(TargetInfo nodeInfo, String icon) {

		String openedNodeIcon = null;
		if(nodeInfo!=null) {
			openedNodeIcon = getOpenedNodeIcon(nodeInfo);
		}

		if(openedNodeIcon==null) {
			openedNodeIcon = this.openedNodeIcon;
		}

		if(openedNodeIcon!=null) {
			icon = openedNodeIcon;
		}
		
		return icon;
	}

	@SuppressWarnings("unchecked")
	private String getClosedNodeIcon0(TargetInfo nodeInfo, String icon) {

		String closedNodeIcon = null;
		if(nodeInfo!=null) {
			closedNodeIcon = getClosedNodeIcon(nodeInfo);
		}

		if(closedNodeIcon==null) {
			closedNodeIcon = this.closedNodeIcon;
		}

		if(closedNodeIcon!=null) {
			icon = closedNodeIcon;
		}
		
		return icon;
	}
}
