/*
 * Resource.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.util;

import java.util.Formatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;


/**
 * vpeBt@CiResourceBundlej̊Ȉ՗p[eBeBB
 */
public class Resource {

	private ResourceBundle resource;
	private Resource parent;
	
	/**
	 * Resource 쐬B
	 * @param resourceName bZ[Wi[Ă郊\[X̖OB
	 */
	public Resource(String resourceName) {
		this(resourceName, Locale.getDefault());
	}

	/**
	 * Resource 쐬B
	 * @param resourceName bZ[Wi[Ă郊\[X̖OB
	 * @param locale P[B
	 */
	public Resource(String resourceName, Locale locale) {
		resource = ResourceBundle.getBundle(resourceName, locale);
	}

	/**
	 * ̃bZ[W̐ebZ[Wݒ肷B
	 * @param parent ebZ[WB
	 */
	public void setParent(Resource parent) {
		this.parent = parent;
	}

	/**
	 * bZ[W擾B
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	public String message(String key, Object... args) {
		if(args==null || args.length == 0) {
			return get(key);
		}
		else {
			return new Formatter(UserLocale.getLocale()).format(get(key), args).toString();
		}
	}

	/**
	 * w肳ꂽOŐݒ肳Ă镶l擾B
	 * @param key L[B
	 * @return lB
	 */
	public String get(String key) {
		try {
			return resource.getString(key);
		}
		catch(MissingResourceException e) {
			if(parent!=null) {
				return parent.get(key);
			}
			else {
				return key;
			}
		}
	}

	/**
	 * bZ[W擾B
	 * @param resourceName bZ[Wi[Ă郊\[X̖OB
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	public static String getMessage(String resourceName, String key, Object... args) {
		return new Resource(resourceName).message(key, args);
	}

	/**
	 * bZ[W擾B
	 * @param resourceName bZ[Wi[Ă郊\[X̖OB
	 * @param locale P[B
	 * @param key bZ[WL[B
	 * @param args bZ[WB
	 * @return bZ[WB
	 */
	public static String getMessage(String resourceName, Locale locale, String key, Object... args) {
		return new Resource(resourceName, locale).message(key, args);
	}

	/**
	 * w肳ꂽOŐݒ肳Ă镶l擾B
	 * @param resourceName 񂪊i[Ă郊\[X̖OB
	 * @param key L[B
	 * @return B
	 */
	public static String getText(String resourceName, String key) {
		return new Resource(resourceName).get(key);
	}

	/**
	 * w肳ꂽOŐݒ肳Ă镶l擾B
	 * @param resourceName 񂪊i[Ă郊\[X̖OB
	 * @param locale P[B
	 * @param key L[B
	 * @return B
	 * @return bZ[WB
	 */
	public static String getText(String resourceName, Locale locale, String key) {
		return new Resource(resourceName, locale).get(key);
	}
}
