/* $Id$ */
package nicobrowser;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;

/**
 *
 * @author yuki
 */
public class VideoInfo {

    private final String realVideoId;
    private final String threadId;
    private final URL videoUrl;
    private final URL messageUrl;
    private final URL smileUrl;
    private final String userId;
    private final int videoLength;
    private final Map<String, String> keyMap;
    private final String resFrom;
    public static final String KEY_THREAD_ID = "thread_id";
    private static final String KEY_URL = "url";
    private static final String KEY_MESSAGE_URL = "ms";
    private static final String KEY_SMILE_LINK = "link";
    public static final String KEY_USER_ID = "user_id";
    private static final String KEY_VIDEO_LENGTH = "l";

    /**
     *
     * @param realVideoId
     * @param getflvReceivedMap
     * @param keyMap 公式動画投稿者コメント取得用パラメータ.
     */
    public VideoInfo(String realVideoId, Map<String, String> getflvReceivedMap, Map<String, String> keyMap) {
        try {
            this.realVideoId = realVideoId;
            threadId = getflvReceivedMap.get(KEY_THREAD_ID);
            videoUrl = new URL(URLDecoder.decode(getflvReceivedMap.get(KEY_URL), "UTF-8"));
            messageUrl = new URL(URLDecoder.decode(getflvReceivedMap.get(KEY_MESSAGE_URL), "UTF-8"));
            smileUrl = new URL(URLDecoder.decode(getflvReceivedMap.get(KEY_SMILE_LINK), "UTF-8"));
            userId = getflvReceivedMap.get(KEY_USER_ID);
            videoLength = Integer.parseInt(getflvReceivedMap.get(KEY_VIDEO_LENGTH));
            this.keyMap = keyMap;

            if (videoLength < 60) {
                resFrom = "-100";
            } else if (videoLength >= 60 && videoLength < 300) {
                resFrom = "-250";
            } else if (videoLength >= 300 && videoLength < 600) {
                resFrom = "-500";
            } else {
                resFrom = "-1000";
            }
        } catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getRealVideoId() {
        return realVideoId;
    }

    public URL getMessageUrl() {
        return messageUrl;
    }

    public URL getSmileUrl() {
        return smileUrl;
    }

    public String getThreadId() {
        return threadId;
    }

    public String getUserId() {
        return userId;
    }

    public int getVideoLength() {
        return videoLength;
    }

    public URL getVideoUrl() {
        return videoUrl;
    }

    public Map<String, String> getKeyMap() {
        return keyMap;
    }

    public String getResFrom() {
        return resFrom;
    }
}
