/* $Id$ */
package nicobrowser;

/**
 *
 * @author yuki
 */
public interface ProgressListener {

    /**
     * NicoHttpClient からユーザスレッドに通知を行う際に使用されるメソッドです.
     * @param fileSize ダウンロードするファイルサイズ.
     * @param downloadSize  現在ダウンロードが完了したサイズ.
     */
    void progress(long fileSize, long downloadSize);

    /**
     * ユーザスレッドからNicoHttpClientに対してダウンロードのキャンセルを行う場合にtrueを設定してください.
     * @return ダウンロードを中断する場合はtrue.
     */
    public boolean getCancel();
    /**
     * 何もしないリスナの実装.
     */
    static final ProgressListener EMPTY_LISTENER = new ProgressListener() {

        @Override
        public void progress(long fileSize, long downloadSize) {
        }

        @Override
        public boolean getCancel() {
            return false;
        }
    };
}
