package nicobrowser;

/**
 * 過去ログを取得するための情報.
 * @author yuki
 */
public class WayBackInfo {

    private final String key;
    private final String time;

    public WayBackInfo(String key, String time) {
        if (key == null || time == null) {
            throw new IllegalArgumentException(" key: " + key + ", time: " + time);
        }

        this.key = key;
        this.time = time;
    }

    public String getKey() {
        return key;
    }

    public String getTime() {
        return time;
    }
}
