/* $Id$ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;
import saccubus.converter.profile.User;

/**
 * 基本設定.
 * @author yuki
 */
public class BasicSetting {

    private static final String PROP_TEMP_DIR = "TempDir";
    private static final String PROP_MAILADDR = "MailAddress";
    private static final String PROP_PASSWORD = "Password";
    private static final String PROP_USE_PROXY = "UseProxy";
    private static final String PROP_PROXY = "Proxy";
    private static final String PROP_PROXY_PORT = "ProxyPort";
    private final File tempDir;
    private final User user;
    private final boolean proxyUse;
    private final String proxyHost;
    private final int proxyPort;

    public BasicSetting(File tempDir, String mail, String password, boolean proxyUse, String proxyHost, int proxyPort) {
        this.tempDir = tempDir;
        this.user = new User(mail, password);
        this.proxyUse = proxyUse;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public File getTempDir() {
        return tempDir;
    }

    public User getUser() {
        return user;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public int getProxyPort() {
        return proxyPort;
    }

    public boolean isProxyUse() {
        return proxyUse;
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_TEMP_DIR, getTempDir().getPath());
        prop.setProperty(PROP_MAILADDR, getUser().getMail());
        prop.setProperty(PROP_PASSWORD, getUser().getPassword());
        prop.setProperty(PROP_USE_PROXY, Boolean.toString(isProxyUse()));
        prop.setProperty(PROP_PROXY, getProxyHost());
        prop.setProperty(PROP_PROXY_PORT, Integer.toString(getProxyPort()));
    }

    public static BasicSetting load(Properties prop, String user, String pass) {
        String tempDir = prop.getProperty(PROP_TEMP_DIR, ".");
        if (user == null) {
            user = prop.getProperty(PROP_MAILADDR, "");
        }
        if (pass == null) {
            pass = prop.getProperty(PROP_PASSWORD, "");
        }
        boolean proxyUse = Boolean.parseBoolean(prop.getProperty(PROP_USE_PROXY, "false"));
        String proxyHost = prop.getProperty(PROP_PROXY, "");
        int proxyPort = Integer.parseInt(prop.getProperty(PROP_PROXY_PORT, "-1"));

        return new BasicSetting(new File(tempDir), user, pass, proxyUse, proxyHost, proxyPort);
    }
}
