package yukihane.inqubus.saccubus_adapter;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nicobrowser.GetFlvResult;
import nicobrowser.NicoHttpClient;
import nicobrowser.ProgressListener;
import nicobrowser.WayBackInfo;
import saccubus.ConvertStopFlag;
import saccubus.net.CommentInfo;
import saccubus.net.NicoClient;
import saccubus.net.TextProgressListener;
import saccubus.net.VideoInfo;
import saccubus.util.FileUtil;

/**
 * NicoBrowserのニコニコ動画サービスアクセス機能をいんきゅばすから使用するためのアダプタ.
 * @author yuki
 */
public class NicoBrowserAdapter implements NicoClient {

    private static final Logger logger = Logger.getLogger(NicoBrowserAdapter.class.getName());
    private final NicoHttpClient client;
    private final boolean hasLogin;
    private final ConvertStopFlag stopFlag;
    private nicobrowser.VideoInfo nicoBrowserVi;

    public NicoBrowserAdapter(final String mail, final String pass,
            final ConvertStopFlag flag, final String proxyHost, final int proxyPort) {

        if (proxyHost != null && proxyHost.length() > 0 && proxyPort >= 0 && proxyPort <= 65535) {
            this.client = new NicoHttpClient(proxyHost, proxyPort);
        } else {
            this.client = new NicoHttpClient();
        }

        // ログイン
        boolean loginned = false;
        try {
            loginned = client.login(mail, pass);
        } catch (Exception ex) {
            logger.log(Level.SEVERE, "ログイン処理時に例外発生", ex);
        }
        this.hasLogin = loginned;

        this.stopFlag = flag;

    }

    @Override
    public VideoInfo getVideoInfo(String videoId) throws IOException {
        nicoBrowserVi = client.getVideoInfo(videoId);
        final nicobrowser.VideoInfo vi = nicoBrowserVi;

        final VideoInfo.OfficialOption oo =
                new VideoInfo.OfficialOption(vi.getKeyMap().get("threadkey"), vi.getKeyMap().get("force_184"));

        return new VideoInfo(FileUtil.safeFileName(vi.getTitleInWatchPage()), vi.getThreadId(), vi.getVideoUrl().
                toString(), vi.getMessageUrl().toString(), vi.getUserId(), vi.getVideoLength(), oo);
    }

    @Override
    public String getWayBackKey(VideoInfo vi) throws IOException {
        return client.getWayBackKey(nicoBrowserVi);
    }

    @Override
    public File getComment(VideoInfo videoInfo, CommentInfo commentInfo, File file, TextProgressListener listener,
            int commentNum) {
        try {
            final WayBackInfo wbi = (commentInfo != null) ? new WayBackInfo(commentInfo.getWayBackKey(), commentInfo.
                    getWayBackTime()) : null;
            return client.getCommentFile(nicoBrowserVi, file.getPath(), wbi, commentNum);
        } catch (Exception ex) {
            logger.log(Level.SEVERE, "コメント取得失敗", ex);
        }
        return null;
    }

    @Override
    public File getTcomment(VideoInfo videoInfo, File file, TextProgressListener listener) {
        try {
            return client.getTCommentFile(nicoBrowserVi, file.getPath());
        } catch (Exception ex) {
            logger.log(Level.SEVERE, "投稿者コメント取得失敗", ex);
        }
        return null;
    }

    @Override
    public File getVideo(final VideoInfo videoInfo, File file, final TextProgressListener listener) {
        try {
            final String fileName = FileUtil.removeExtension(file.getPath());
            GetFlvResult res = client.getFlvFile(nicoBrowserVi, fileName, new ProgressListener() {

                @Override
                public void progress(long fileSize, long downloadSize) {
                    final double p = ((double) downloadSize / fileSize) * 100.0;
                    final String msg = String.format("動画ダウンロード：%.2fパーセント完了", p);
                    listener.setText(msg);
                }

                @Override
                public boolean getCancel() {
                    return stopFlag.needStop();
                }
            });

            return res.getFile();
        } catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public boolean isLoggedIn() {
        return hasLogin;
    }
}
