/*
 * LeakCheckerTest.cpp
 */

#ifndef DISABLE_LEAK_CHECKER
#  define ENABLE_LEAK_CHECKER
#  define USE_LEAK_CHECKER_ALLOCATOR
#endif

#if defined(USE_MALLOC_ALLOCATOR)
#  include <debug/MallocAllocator.h>
#  define TEST_ALLOCATOR MallocAllocator
#elif defined(USE_LEAK_CHECKER_ALLOCATOR)
#  include <debug/LeakCheckerAllocator.h>
#  define TEST_ALLOCATOR LeakCheckerAllocator
#endif

#include "ContainersTest.h"
#include <debug/LeakChecker.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <list>
#include <deque>
#include <set>
#include <map>
#include <iostream>

dg_USING_NAMESPACE_STD

#ifdef TEST_ALLOCATOR
typedef basic_string<char, char_traits<char>, TEST_ALLOCATOR<char> > String;
#else
typedef string String;
#endif

struct TestTraits
{
	typedef ::String String;
#ifdef TEST_ALLOCATOR
	typedef TEST_ALLOCATOR<int> IntAlloc;
	typedef TEST_ALLOCATOR<pair<const String, int> > PairAlloc;

	typedef vector  <int, IntAlloc> Vector;
	typedef list    <int, IntAlloc> List;
	typedef deque   <int, IntAlloc> Deque;
	typedef set     <int, less<int>, IntAlloc> Set;
	typedef multiset<int, less<int>, IntAlloc> Multiset;
	typedef map     <String, int, less<String>, PairAlloc> Map;
	typedef multimap<String, int, less<String>, PairAlloc> Multimap;
#else
	typedef vector  <int> Vector;
	typedef list    <int> List;
	typedef deque   <int> Deque;
	typedef set     <int> Set;
	typedef multiset<int> Multiset;
	typedef map     <String, int> Map;
	typedef multimap<String, int> Multimap;
#endif
};

class Uncreatable {
  public:
	Uncreatable() { throw "can't create"; }
};

void testAlloc()
{
	int* intValue1 = (int*)calloc(2, sizeof (int));
	free(intValue1);
	int* intValue2 = (int*)malloc(sizeof (int));
	int* intValue3 = (int*)realloc(intValue2, 2 * sizeof (int));
	free(intValue3);

	intValue1 = (int*)calloc(2, sizeof (int));	// leak!!
	intValue2 = (int*)malloc(sizeof (int));
	intValue3 = (int*)realloc(intValue2, 2 * sizeof (int));
	delete intValue3;			// error!!

	int* intValue4 = new int();
	delete intValue4;
	int* intValues = new int[2];
	delete[] intValues;

	intValue4 = new int();		// leak!!
	intValues = new int[2];		// leak!!

	intValue4 = new int();
	free(intValue4);			// error!!
	intValues = new int[2];
	delete intValues;			// error!!

	try { new Uncreatable();  } catch (...) {}
	try { new Uncreatable[2]; } catch (...) {}
}

extern "C" void testAlloc2();

#ifdef __BORLANDC__
void initSTL()
{
	vector<int> v;
	v.push_back(0);
	cout << v.front() << "!!!" << endl;
}
#endif

void reportLeak()
{
	printf("--------\nleak count = %u\n", LeakChecker::count());
	LeakChecker::dump(stdout);

#if defined(dg_USE_WIN32_THREADS)
	printf("**** Support Win32 Threads ****\n");
#elif defined(dg_USE_POSIX_THREADS)
	printf("**** Support POSIX Threads ****\n");
#elif defined(dg_USE_VXW_THREADS)
	printf("**** Support VxWorks Threads ****\n");
#endif
}

int main()
{
#ifdef __BORLANDC__
	initSTL();
#endif
	SETUP_LEAK_CHECKER(checker(&reportLeak))

	ContainersTest<TestTraits>::testSeq();
	ContainersTest<TestTraits>::testSet();
	ContainersTest<TestTraits>::testMap();
	testAlloc();
	testAlloc2();
#undef new
	new int();	// leak!!
	return 0;
}

#ifndef NDEBUG
#  define dg_DEBUG
#endif
#define ENABLE_LEAK_CHECKER
#include <debug/debugtools.cpp>

// string ̃AP[^ύXꍇAȉ̋LqKvB
#undef new
#ifdef __BORLANDC__
#  include <string.cc>
#endif
#ifdef VxWorks
#  include <std/bastring.cc>
String::Rep String::nilRep = { 0, 0, 1 };
#endif
