/*
 * LeakChecker.h
 *
 * Copyright (C) 2001-2002 by Ito Yoshiichi.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef debug_LeakChecker_h
#define debug_LeakChecker_h

#include "dgconfig.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

void* dg_calloc(size_t n, size_t size, const char* file, int line);
void* dg_malloc(size_t n, const char* file, int line);
void* dg_realloc(void* p, size_t n, const char* file, int line);
void  dg_free(void* p, const char* file, int line);

#ifdef __cplusplus
} /* extern "C" */
#endif

#ifdef __cplusplus

#include <new>
#include <memory>
#ifdef __GNUC__
#  include <string>
#endif

#if defined(ENABLE_LEAK_CHECKER) && !defined(_CRTDBG_MAP_ALLOC)

void* operator new(size_t n) dg_THROW(dg_STD::bad_alloc);
void* operator new[](size_t n) dg_THROW(dg_STD::bad_alloc);

void* operator new(size_t n, const char* file, int line)
		dg_THROW(dg_STD::bad_alloc);
void* operator new[](size_t n, const char* file, int line)
		dg_THROW(dg_STD::bad_alloc);

void operator delete(void* p) dg_NOTHROW;
void operator delete[](void* p) dg_NOTHROW;

#ifndef dg_NO_OPERATOR_DELETE_OVERLOADING
void operator delete(void* p, const char* file, int line) dg_NOTHROW;
void operator delete[](void* p, const char* file, int line) dg_NOTHROW;
#endif

#endif /* ENABLE_LEAK_CHECKER && !_CRTDBG_MAP_ALLOC */

dg_NAMESPACE_BEGIN(debug)

/**
 * [NB
 */
class LeakChecker
{
  public:
	typedef void (*Reporter)();

  public:
	/**
	 * RXgN^B.
	 * LeakChecker IuWFNggp邱ƂŁA
	 * AIōsƂłB
	 * @param reporter IɎs񍐊֐B
	 */
	explicit LeakChecker(Reporter reporter = &(LeakChecker::report));

	/**
	 * fXgN^B.
	 * 񍐊֐o^ĂΎsB
	 */
	~LeakChecker();

	/**
	 * `FbJB.
	 * IuWFNg𐶐邱Ƃőp\B
	 * XbhNOɎs邱ƁB
	 */
	static void initialize();

	/**
	 * `FbJIB.
	 * IuWFNgj邱Ƃőp\B
	 * Xbh~Ɏs邱ƁB
	 * @param reporter IɎs񍐊֐B
	 */
	static void finalize(Reporter reporter = 0);

	/** G[̌ԂB */
	static size_t count();

	/** ʂ\B */
	static void dump(FILE* fp = stdout);

	/** B */
	static void clear();

	/** W̕񍐊֐B */
	static void report() { LeakChecker::dump(); }

  private:
	LeakChecker(const LeakChecker& rhs);
	LeakChecker& operator=(const LeakChecker& rhs);

  private:
	Reporter m_reporter;
};

dg_NAMESPACE_END

#endif /* __cplusplus */

#if !defined(ENABLE_LEAK_CHECKER)
#  define dg_NEW          new
#elif defined(_CRTDBG_MAP_ALLOC)
#  include <malloc.h>
#  include <crtdbg.h>
#  define dg_NEW          new(_NORMAL_BLOCK, __FILE__, __LINE__)
#else
#  define calloc(n, size) dg_calloc(n, size, __FILE__, __LINE__)
#  define malloc(n)       dg_malloc(n, __FILE__, __LINE__)
#  define realloc(p, n)   dg_realloc(p, n, __FILE__, __LINE__)
#  define free(p)         dg_free(p, __FILE__, __LINE__)
#  define dg_NEW          new(__FILE__, __LINE__)
#endif

#ifdef __cplusplus
#  define new dg_NEW
#endif

#ifdef ENABLE_LEAK_CHECKER
#  define SETUP_LEAK_CHECKER(var) LeakChecker var;
#else
#  define SETUP_LEAK_CHECKER(var)
#endif

#endif /* !debug_LeakChecker_h */
