/////////////////////////////////////////////////////
// Processingには用意されていない数学系の汎用的な関数
/////////////////////////////////////////////////////

// 1. int sgn(float), int sgn(int) : 負ならば-1，正ならば 1，ゼロならば 0 を返す
// 2. nowDateTime(void)     : 日時を文字列で返す（yyyy/mm/dd hh:mm:ss）
// 3. getKEY(void)          : キーボードから入力された文字を大文字に変換して返す(a-zの場合のみ)
// 4. isNumberChar(char)    : charが'0'から'9'ならば真
// 5. strRight(String, int) : 文字列の右から指定された長さの文字列を返す
// 6. strLeft(String, int)  : 文字列の左から指定された長さの文字列を返す

// 1. int sgn(float), int sgn(int) : 負ならば-1，正ならば 1，ゼロならば 0 を返す
int sgn(int i) {
  return sgn(float(i));
}
int sgn(float f) {
  if (f < 0.0) return -1;
  if (f > 0.0) return  1;
  return 0;
}

// 2. nowDateTime() : 日時を文字列で返す（yyyy/mm/dd hh:mm:ss）
String nowDateTime() {
  return str(year()) + '/' + strRight('0' + str(month()), 2) + '/' + strRight('0' + str(day()), 2) + ' ' + strRight('0' + str(hour()), 2) + ':' + strRight('0' + str(minute()), 2) + ':' + strRight('0' + str(second()), 2);
}

// 3. getKEY() : キーボードから入力された文字を大文字に変換して返す(a-zの場合のみ)
char getKEY() {
  if ((key < 'a') || (key > 'z')) return key;
  return str(key).toUpperCase().charAt(0);
}

// 4. isNumberChar(char)    : charが'0'から'9'ならば真
boolean isNumberChar(char c) {
  if ((c >= '0') && (c <= '9')) return true;
  return false;
}

// 5. strRight(String, int) : 文字列の右から指定された長さの文字列を返す
String strRight(String str, int len) {
  int  index;
  index = str.length() - len;
  if (index < 0) return str;
//return str.substring(index, len);
  return str.substring(index);
}

// 6. strLeft(String, int)  : 文字列の左から指定された長さの文字列を返す
String strLeft(String str, int len) {
  return str.substring(0, len);
}
