package jp.sourceforge.crudfactory;


import java.lang.reflect.Method;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;

public class DaoFactory {
    private static boolean autoTransaction = true;
    public static boolean isAutoTransaction() {
        return autoTransaction;
    }
    public static void setAutoTransaction(boolean autoTransaction) {
        DaoFactory.autoTransaction = autoTransaction;
    }

    //<U> Class<? extends U> asSubclass(Class<U> clazz)
    @SuppressWarnings("unchecked")
    public static <T> T create(final Class<T> cls) {
        Enhancer e = new Enhancer();

        if (cls.isInterface()) {
            e.setSuperclass(DaoSupport.class);
            e.setInterfaces(new Class[] {cls});
        }
        else if (isSubClass(cls, DaoSupport.class)) {
            e.setSuperclass(cls);
            e.setInterfaces(null);
        }
        else {
            return null;
        }
        
        e.setCallbackFilter(new CallbackFilter() {
            public int accept(Method method) {
                // TODO 
                return method.getDeclaringClass().equals(cls) ? 0 : 1 ;
            }
        });
        
        e.setCallbacks(new Callback[] {new DaoInterceptor(),  NoOp.INSTANCE });
        return (T) e.create();
    }

    private DaoFactory() {
    }
    
    private static boolean isSubClass(Class subClass, Class superClass) {
        while (subClass != null) {
            if (superClass.equals(subClass)) return true;
            subClass = subClass.getSuperclass();
        }
        return false;
    }
}

