package jp.sourceforge.crudfactory;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sourceforge.crudfactory.SQL.TYPE;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import ognl.Ognl;
import ognl.OgnlException;

public class DaoInterceptor implements MethodInterceptor {
    /**
     * annotationŗ^ꂽsqlp[Xʂ̃LbV
     */
    private Map<String, List<SqlPair>> sqlCache = Collections.synchronizedMap(new HashMap<String, List<SqlPair>>());
    
    /**
     * methoďʂ̌^beanƂɁAssetterƃJ̕т̑Ή̃LbV
     */
    private Map<String, Method[]> setterCache = Collections.synchronizedMap(new HashMap<String, Method[]>());
    
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {

        Object retval = null;
        boolean transactionStartsHere = false;
        Connection con = ((DaoSupport) obj).getConnection();

        SQL sqla = method.getAnnotation(SQL.class);

        if (con.getAutoCommit()) {
            // gUNV̒ł͂Ȃ
            Transaction t = method.getAnnotation(Transaction.class);
            if ((t!=null && t.value()) || DaoFactory.isAutoTransaction() && sqla != null && !sqla.type().equals(TYPE.READ)) {
                // Transaction āA^̂Ƃ
                // DaoFactory autoTransaction  SQLAme[VāAreadȊÔƂ
                //System.out.print("TRANSACTION START AT : ");
                //System.out.println(method);
                transactionStartsHere = true;
                con.setAutoCommit(false);
            }
        }
        
        if ((method.getModifiers() & Modifier.ABSTRACT) == 0) {
            if (sqla != null) {
                // ̂Aannotation
                // SQLsĂ̂s
                // before  after ̏
                if (sqla.executeSqlBefore()) {
                    // Ame[V  
                    executeSqlOfAnnotation(method, con, false, args);
                    retval = proxy.invokeSuper(obj, args);
                }
                else {
                    //   Ame[V
                    proxy.invokeSuper(obj, args);
                    retval = executeSqlOfAnnotation(method, con, true, args);
                }
            }
            else {
                // ̂AannotationȂ
                // ̂̂ݎs
                retval = proxy.invokeSuper(obj, args);
            }
        }
        else {
            if (sqla != null) {
                // ̂ȂAannotation
                retval = executeSqlOfAnnotation(method, con, true, args);
            }
            else {
                // ̂ȂAannotationȂ
                // OoBTODO O̎ތ
                throw new RuntimeException(method.toString());
            }
        }
        
        if (transactionStartsHere) {
            // ̃\bhŃgUNVJnꍇ͔OɃR~bgĂ
            con.commit();
            con.setAutoCommit(true);
            con.close();
            //System.out.print("TRANSACTION END AT : ");
            //System.out.println(method);
        }
        return retval;
    }

    public Object executeSqlOfAnnotation(Method method, Connection con, boolean isNeedReturnValue, Object[] args) throws SQLException, ParseException, OgnlException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SQL sqla = method.getAnnotation(SQL.class);        

        if (sqla == null) {
            throw new SQLException("There is no SQLAnnotation.");
        }
        
        List<SqlPair> sqlPairs = getSqlPairs(method);

        Object retval = null;
        for (int sqlIndex=0; sqlIndex<sqlPairs.size(); sqlIndex++) {
            SqlPair sqlPair = sqlPairs.get(sqlIndex);

            PreparedStatement ps = con.prepareStatement(sqlPair.sql);
            try {
                // \bḧargsƂOcontextɂ
                Map<String, Object> context = new HashMap<String, Object>();
                context.put("arg", args);

                // ognl]PreparedStatementɓ
                for (int i = 0; i < sqlPair.ognlParsed.length; i++) {
                    Object value = Ognl.getValue(sqlPair.ognlParsed[i], context, (Object) null);
                    //System.out.println(value);
                    ps.setObject(i+1, value);
                }

                //System.out.println(ps);
                
                // typeɂ菈𕪂
                switch (sqla.type()) {
                case CREATE: {
                    retval = ps.executeUpdate();
                    break;
                }
                case CREATE_IDENTITY: {
                    ps.executeUpdate();
                    Statement s = con.createStatement();
                    try {
                        ResultSet rs = s.executeQuery("CALL IDENTITY()");
                        if (rs.next())
                            retval = rs.getObject(1);
                    }
                    finally {
                        s.close();
                    }
                    break;
                }
                case CREATE_GENERATE: {
                    retval = ps.executeUpdate();
                    ResultSet rs = ps.getGeneratedKeys();
                    if (rs.next())
                        retval = rs.getObject(1); // J̎̏ǉ
                    break;
                }
                case READ: {
                    ResultSet rs = ps.executeQuery();
                    if (sqlIndex == (sqlPairs.size()-1) && isNeedReturnValue) {
                        // Ōsql̂݌ʂ̕ϊs
                        retval = convertResultSet(rs, method);
                    }
                    break;
                }
                case UPDATE: {
                    retval = ps.executeUpdate();
                    break;
                }
                case DELETE: {
                    retval = ps.executeUpdate();
                    break;
                }
                case STATEMENT: {
                    retval = ps.execute();
                    break;
                }
                }
            }
            finally {
                ps.close();
            }
        }
        return retval;
    }

    
    /**
     * rs  method ̖߂ľ^ɍ悤ϊ
     * @param rs
     * @param method
     * @return
     * @throws SQLException
     * @throws NoSuchMethodException
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws IllegalArgumentException
     * @throws InvocationTargetException
     */
    private Object convertResultSet(ResultSet rs, Method method) throws SQLException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class returnType = method.getReturnType();
        
        if (List.class.equals(returnType)) {
            // ߂ľ^List
            Class compType = method.getAnnotation(SQL.class).bean();
            List<Object> retlist = new ArrayList<Object>();

            while (rs.next()) {
                retlist.add(resultSetToObject(rs, method, compType));
            }
            return retlist;
        }
        else if (returnType.isArray()) {
            // ߂ľ^z
            Class compType = returnType.getComponentType();
            List<Object> retList = new ArrayList<Object>();

            while (rs.next()) {
                retList.add(resultSetToObject(rs, method, compType));
            }

            Object array = Array.newInstance(compType, retList.size());
            for (int i=0; i<retList.size(); i++) {
                Array.set(array, i, retList.get(i));
            }
            return array;
        }
        else {
            // ߂ľ^zł͂Ȃ̂ŁA1̃CX^XԂ
            if (rs.next()) {
                // rs ̒lϊāAԂlɂ
                return resultSetToObject(rs, method, returnType);
            }
            else {
                // rsɍsЂƂȂ
                // ߂lv~eBu^̂ƂÃftHglԂ
                return null;
            }
        }
    }

    /**
     * rstype^̃CX^X쐬B
     * @param rs 쐬p̌f[^
     * @param method Ăяomethod
     * @param type 쐬CX^X̌^
     * @return 쐬CX^X
     * @throws SQLException
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws IllegalArgumentException
     * @throws InvocationTargetException
     */
    private Object resultSetToObject(ResultSet rs, Method method, Class type) throws SQLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object retval;

        if (type.isPrimitive() || String.class.equals(type)) {
            // v~eBu܂͕̏ꍇA擪̃Ji[
            retval = rs.getObject(1);
        }
        else if (Map.class.equals(type)) {
            // map̏ꍇ́AJL[ɂ <String, Object>  HashMap 
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
                
            Map<String, Object> map;

            map = new HashMap<String, Object>();
            for (int i=0; i<columnCount; i++) 
                map.put(rsmd.getColumnName(i+1), rs.getObject(i+1));
            retval = map;
        }
        else {
            // ̑̃IuWFNg̏ꍇ́ACX^X쐬J狁܂setterɒlZbg
            ResultSetMetaData rsmd = rs.getMetaData();
            
            Method[] setters = getSetters(method, type, rsmd);
                
            retval = type.newInstance();
            for (int i=0; i<rsmd.getColumnCount(); i++) { 
                if (setters[i] != null) {
                    // YsetterƂ
                    //Class parameterType = setters[i].getParameterTypes()[0];
                    //rs.getObject(i+1, rs.getStatement().getConnection().getTypeMap());
                    Object object = rs.getObject(i+1);
                    setters[i].invoke(retval, new Object[] {object});
                }
                else; // Ƃ͉Ȃ
            }
        }
        return retval;
    }

    /**
     * JԍƃZb^[̑Ή\擾A܂͍쐬ăLbV
     * @param method
     * @param type
     * @param rsmd
     * @return
     * @throws SQLException
     */
    private Method[] getSetters(Method method, Class type, ResultSetMetaData rsmd) throws SQLException {
        if (setterCache.containsKey(method.toString())) {
            // LbV
            return setterCache.get(method.toString());
        }
        else {
            // LbVȂ̂ŁA쐬
            int columnCount = rsmd.getColumnCount();
            Method[] setters = new Method[columnCount];
            setterCache.put(method.toString(), setters);

            for (int i=0; i<columnCount; i++) {
                String columnName = rsmd.getColumnName(i+1);
                String setterName = Util.columnNameToSetterName(columnName);
                
                for (Method m : type.getMethods()) {
                    Class[] parameterTypes = m.getParameterTypes();
                    if (m.getName().equals(setterName) && m.getReturnType().equals(Void.TYPE) && parameterTypes.length == 1) {
                        // J瓱o閼OŁA߂lȂA1̃\bh
                        setters[i] = m;
                        break;
                    }
                }
            }
            return setters;
        }
    }

    /**
     * @param method
     * @return
     * @throws ParseException
     * @throws OgnlException
     */
    private List<SqlPair> getSqlPairs(Method method) throws ParseException, OgnlException {
        SQL sqla = method.getAnnotation(SQL.class);

        if (sqlCache.containsKey(method.toString())) {
            // method  sqlLbVĂ΂g
            return sqlCache.get(method.toString());
        }
        else {
            // LbVȂ̂ sql p[XăLbV
            String[] sqls = sqla.value();
            List<SqlPair> sqlPairs = new ArrayList<SqlPair>(sqls.length);

            for (String sql : sqls) {
                StringBuilder sb = new StringBuilder();
                String[] splited = Util.splitBetween(sql, '{', '}');
                Object[] ognlParsed = new Object[splited.length/2];

                for (int i = 0; i < splited.length; i++) {
                    if ((i&1)==0)
                        sb.append(splited[i]);
                    else {
                        sb.append('?');
                        ognlParsed[i/2] = Ognl.parseExpression(splited[i]);
                    }
                }
                sqlPairs.add(new SqlPair(sb.toString(), ognlParsed));
            }
            sqlCache.put(method.toString(), sqlPairs);
            return sqlPairs;
        }
    }
}

/**
 * parsesqlognlLbVpɈZ߂ɂNX
 */
class SqlPair {
    public String sql;
    public Object[] ognlParsed;
    SqlPair(String sql, Object[] ognlParsed) {
        this.sql = sql;
        this.ognlParsed = ognlParsed;
    }
}