package jp.sourceforge.crudfactory;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

public class DaoSupport {
    private static Map<Long, Connection> connectionOfThread;
    static {
        connectionOfThread = Collections.synchronizedMap(new HashMap<Long, Connection>());
    }
    
    private DataSource dataSource;
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Connection getConnection() throws SQLException {
        long threadId = Thread.currentThread().getId();
        Connection con = connectionOfThread.get(threadId);
        
        if (con == null || con.isClosed()) {
            // TODO dbbNĂƂ̏ǉ
            con = dataSource.getConnection();
            connectionOfThread.put(threadId, con);
        }
        return con;
    }
    
    protected Object queryIdentity() throws SQLException {
        Connection con = getConnection();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("CALL IDENTITY");
        Object retval = rs.getObject(1);
        rs.close();
        stmt.close();
        return retval;
    }
}
