package jp.sourceforge.crudfactory;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class Util {

    /**
     * source  start  end ̃yAŐ؂蕪B
     * @param source aaa{bbb}ccc{ddd}eee
     * @param start {
     * @param end   }
     * @return [aaa, bbb, ccc, ddd, eee]
     * @throws ParseException startend̑ΉȂƂ
     */
    public static String[] splitBetween(String source, char start, char end) throws ParseException {
        int pos = 0;
        List<String> splited = new ArrayList<String>(source.length()/10);

        for (;;) {
            int spos = source.indexOf(start, pos);
            int epos = source.indexOf(end, pos);
            
            if (spos < 0 && epos < 0) {
                // end
                splited.add(source.substring(pos));
                break;
            }
            if (spos < 0 || epos < 0 || spos > epos) {
                // sytax erroe
                throw new ParseException(source, pos);
            }

            splited.add(source.substring(pos, spos));
            splited.add(source.substring(spos+1, epos));
            pos = epos+1;
        }
        return (String[]) splited.toArray(new String[splited.size()]);
    }

    /**
     * DB̃JvpeBɕϊB
     * '_' ̒̕啶ɁAȊOɕϊA'_' B 
     * @param columnName ϊ̃J "product_code"  "CUSTOMDR_ID" Ȃ
     * @return ϊvpeB "productCode"  "customerId"
     */
    public static String columnNameToPropertyName(String columnName) {
        char[] source = columnName.toCharArray();
        char[] result = new char[source.length];

        boolean previousIsUnderscore = true;
        int rpos=0;

        for (int spos=0; spos<source.length; spos++) {
            if (source[spos] == '_') {
                previousIsUnderscore = true;
            }
            else {
                if (previousIsUnderscore) {
                    result[rpos] = Character.toUpperCase(source[spos]);
                }
                else {
                    result[rpos] = Character.toLowerCase(source[spos]);
                }
                previousIsUnderscore = false;
                rpos++;
            }
        }
        return new String(result, 0, rpos);
    }

    /**
     * DB̃JsetterɕϊB
     * columnNameToPropertyNamȅAbean̋Kɏ]setterɕϊB
     * @param columnName ϊ̃J "product_code"  "CUSTOMDR_ID" Ȃ
     * @return ϊsetter "setProductCode"  "setCustomerId"
     */
    public static String columnNameToSetterName(String columnName) {
        String propertyName = columnNameToPropertyName(columnName);

        char[] source = propertyName.toCharArray();
        char[] result = new char[source.length+3];
        result[0] = 's';
        result[1] = 'e';
        result[2] = 't';

        System.arraycopy(source, 0, result, 3, source.length);
        if (source.length>0) result[3] = Character.toUpperCase(result[3]);
        return new String(result);
    }
}
