package sample;

import java.util.List;

import sample.dao.DaoCreator;
import sample.dao.DeptDao;
import sample.dao.EmpDao;
import sample.data.Dept;
import sample.data.Emp;

public class Sample1 {

    public static void main(String[] args) {
        DeptDao deptDao = DaoCreator.getDeptDao();
        EmpDao empDao = DaoCreator.getEmpDao();
        
        // CREATE dept data
        System.out.println("------------");
        System.out.println("CREATE dept data");
        Dept salesDept = new Dept("sales");
        deptDao.create(salesDept);
        System.out.println(salesDept);

        Dept seDept = new Dept("system engeneering");
        deptDao.create(seDept);
        System.out.println(seDept);
        
        // READ dept data
        System.out.println("------------");
        System.out.println("READ dept data");
        List<Dept> depts = deptDao.readAll();
        for (Dept dept : depts) {
            System.out.println(dept);
        }
        
        // CREATE emp data
        System.out.println("------------");
        System.out.println("CREATE emp data");
        Emp a = new Emp("Alice", 1300, salesDept.getId());
        empDao.create(a);
        System.out.println(a);
        
        Emp b = new Emp("Bob", 1200, salesDept.getId());
        Emp c = new Emp("Carol", 1500, seDept.getId());
        Emp d = new Emp("Dave", 1400, seDept.getId());
        empDao.createEmps(new Emp[] {b, c, d});
        
        // move salary c to d
        System.out.println("------------");
        System.out.println("MOVE salary C to D");
        empDao.moveSalary(c, d, 200);

        // READ emps from dept
        System.out.println("------------");
        System.out.println("READ emps from se-dept");
        List<Emp> seMembers = empDao.readEmpsFrom(seDept);
         for (Emp se : seMembers) {
            System.out.println(se);
        }
         
    }
}
