package sample.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.sql.DataSource;

import jp.sourceforge.crudfactory.DaoFactory;

import org.hsqldb.jdbc.jdbcDataSource;

import sample.dao.crudfactory.CrudFactoryDeptDao;
import sample.dao.crudfactory.CrudFactoryEmpDao;

public class DaoCreator {
    static private DataSource ds;

    static {
        try {
            jdbcDataSource hds = new jdbcDataSource();
            hds.setUser("sa");
            hds.setPassword("");
            hds.setDatabase("jdbc:hsqldb:mem:.");
            Connection con = hds.getConnection();
            Statement stmt = con.createStatement();
            stmt.addBatch("" +
                    "CREATE TABLE dept(" +
                    "    id INTEGER NOT NULL IDENTITY," +
                    "    name VARCHAR NOT NULL," +
                    "PRIMARY KEY(id)" +
                    ");");
            stmt.addBatch("" +
                    "CREATE TABLE emp(" +
                    "    id INTEGER NOT NULL IDENTITY," +
                    "    name VARCHAR NOT NULL," +
                    "    salary INTEGER NOT NULL," +
                    "    dept_id INTEGER NOT NULL," +
                    "PRIMARY KEY(id)," +
                    "FOREIGN KEY(dept_id) REFERENCES dept(id)" +
                    ");");
            stmt.executeBatch();
            ds = hds;
        }
        catch (SQLException e) {}
    }
    
    public static EmpDao getEmpDao() {
        CrudFactoryEmpDao dao = DaoFactory.create(CrudFactoryEmpDao.class);
        dao.setDataSource(ds);
        return dao;
    }
    
    public static DeptDao getDeptDao() {
        CrudFactoryDeptDao dao = DaoFactory.create(CrudFactoryDeptDao.class);
        dao.setDataSource(ds);
        return dao;
    }
}
