package sample.dao.crudfactory;

import java.util.List;

import jp.sourceforge.crudfactory.DaoSupport;
import jp.sourceforge.crudfactory.SQL;
import jp.sourceforge.crudfactory.SQL.TYPE;
import sample.dao.DeptDao;
import sample.data.Dept;

public abstract class CrudFactoryDeptDao extends DaoSupport implements DeptDao {
    @SQL(value = 
        "INSERT INTO dept (name)" +
        "VALUES ({#arg[0].name})",
        type = TYPE.CREATE_IDENTITY
    )
    protected abstract int createIdentity(Dept dept);
    
    public void create(Dept dept) {
        int id = createIdentity(dept);
        dept.setId(id);
    }

    @SQL(value = "SELECT * FROM dept", bean = Dept.class)
    public abstract List<Dept> readAll();
}
