package sample.dao.crudfactory;

import java.util.List;

import jp.sourceforge.crudfactory.DaoSupport;
import jp.sourceforge.crudfactory.SQL;
import jp.sourceforge.crudfactory.SQL.TYPE;
import sample.dao.EmpDao;
import sample.data.Dept;
import sample.data.Emp;

public abstract class CrudFactoryEmpDao extends DaoSupport implements EmpDao {

    @SQL("SELECT COUNT(*) FROM emp")
    public abstract int count();
    
    @SQL(value = 
        "INSERT INTO emp (name, salary, dept_id)" +
        "VALUES ({#arg[0].name}, {#arg[0].salary}, {#arg[0].deptId})",
        type = TYPE.CREATE_IDENTITY
    )
    protected abstract int createIdentity(Emp emp);
    
    public void create(Emp label) {
        int id = createIdentity(label);
        label.setId(id);
    }

    public void createEmps(Emp[] emps) {
        for (Emp emp : emps) {
            create(emp);
            System.out.println(emp);
        }
    }

    @SQL(value = {
            "UPDATE emp SET salary = salary - {#arg[2]} WHERE id = {#arg[0].id}",
            "UPDATE emp SET salary = salary + {#arg[2]} WHERE id = {#arg[1].id}",
    }, type = TYPE.UPDATE
    )
    public abstract void moveSalary(Emp from, Emp to, int price);

    @SQL(value = "SELECT * FROM emp WHERE dept_id = {#arg[0].id}", bean = Emp.class)
    public abstract List<Emp> readEmpsFrom(Dept dept);
}
