(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit MainFormUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ExtCtrls, ComCtrls, StdCtrls, Buttons, gcryptUnit, KeyUnit,
  ActnList, ShellAPI;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    AboutMenu: TMenuItem;
    Panel1: TPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    StatusBar: TStatusBar;
    Image1: TImage;
    File1: TMenuItem;
    ExitMenu: TMenuItem;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    DateLabel: TLabel;
    UserIDLabel: TLabel;
    ExitButton: TButton;
    EncryptFileButton: TSpeedButton;
    LoadBagMenu: TMenuItem;
    N1: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ActionList: TActionList;
    ExitAction: TAction;
    LoadBagAction: TAction;
    AboutAction: TAction;
    EncryptFileAction: TAction;
    EncryptTextButton: TSpeedButton;
    EncryptTextAction: TAction;
    Bevel3: TBevel;
    KeyIDLabel: TLabel;
    SubkeyIDLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ExitActionExecute(Sender: TObject);
    procedure AboutActionExecute(Sender: TObject);
    procedure LoadBagActionExecute(Sender: TObject);
    procedure EncryptFileActionExecute(Sender: TObject);
    procedure EncryptTextActionExecute(Sender: TObject);
  private
    { Private 錾 }
    FPubKey: TPubKey;
    FLoadKey: Boolean;
    FPubKeyFileName: string;
  protected
    procedure LoadFile(FileName: string);
    procedure SetLoadKey(Value: Boolean);
    procedure OnEncryptTerminate(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property LoadKey: Boolean read FLoadKey write SetLoadKey;
  end;

var
  MainForm: TMainForm;

implementation

uses AboutFormUnit, EncryptFormUnit, EncryptThreadUnit, InputTextFormUnit;

{$R *.dfm}

procedure TMainForm.LoadFile(FileName: string);
var
  I: TFileStream;
begin
  try
    I := TFileStream.Create(FileName, fmOpenRead or fmShareExclusive);
    try
      FPubKey.LoadFromStream(I);
      LoadKey := FPubKey.CheckKey;
      if LoadKey then;
        FPubKeyFileName := FileName;
    finally
      I.Free;
    end;
  except
    on E: Exception do
      MessageDlg('ÍobN̓ǂݍ݂ŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0);
    else
      MessageDlg('ÍobN̓ǂݍ݂ŃG[܂', mtError, [mbAbort], 0);
  end;
end;

procedure TMainForm.SetLoadKey(Value: Boolean);
begin
  FLoadKey := Value;

  EncryptFileButton.Enabled := FLoadKey;
  EncryptTextButton.Enabled := FLoadKey;

  if FLoadKey then
  begin
    StatusBar.SimpleText  := '';
    UserIDLabel.Caption   := FPubKey.UserID.UID;
    DateLabel.Caption     := DateTimeToStr(FPubKey.PubKey.Date);
    KeyIDLabel.Caption    := FPubKey.PubKey.StrKeyID;
    SubkeyIDLabel.Caption := FPubKey.PubSubkey.StrKeyID;
  end;
end;

procedure TMainForm.OnEncryptTerminate(Sender: TObject);
var
 E: Exception;
begin
  if not (Sender is TThread) then
    Exit;

  if TThread(Sender).FatalException is Exception then
  begin
    E := Exception(TThread(Sender).FatalException);
    MessageDlg('t@C鏈ŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0);
    Close;
  end;
end;

constructor TMainForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  gcry_control(GCRYCTL_INIT_SECMEM, 16384, 0);

  FPubKey := TPubKey.Create;
  FLoadKey := False;
  FPubKeyFileName := '';
end;

destructor TMainForm.Destroy;
begin
  FPubKey.Free;
  inherited;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  UserIDLabel.Caption       := '';
  DateLabel.Caption         := '';
  KeyIDLabel.Caption        := '';
  SubkeyIDLabel.Caption     := '';
  StatusBar.SimpleText      := 'ÍobNǂݍ܂Ă܂';
  EncryptFileButton.Enabled := False;
  EncryptTextButton.Enabled := False;

  if ParamStr(1) <> '' then
    LoadFile(ParamStr(1));
end;

procedure TMainForm.ExitActionExecute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.AboutActionExecute(Sender: TObject);
var
  DLG: TAboutForm;
begin
  DLG := TAboutForm.Create(Self);
  try
    DLG.ShowModal;
  finally
    DLG.Free;
  end;
end;

procedure TMainForm.LoadBagActionExecute(Sender: TObject);
begin
  OpenDialog.Title    := 'ÍobNJ';
  OpenDialog.FileName := '';
  OpenDialog.Filter   := 'ÍobN (*.cbbag)|*.cbbag';
  OpenDialog.Options  := [ofHideReadOnly, ofFileMustExist, ofDontAddToRecent];

  if OpenDialog.Execute then
    LoadFile(OpenDialog.FileName);
end;

procedure TMainForm.EncryptFileActionExecute(Sender: TObject);
var
  DLG: TEncryptForm;
  ET: TEncryptThread;
begin
  OpenDialog.Title    := 'ÍobN֓t@CJ';
  OpenDialog.FileName := '';
  OpenDialog.Filter   := 't@C (*.*)|*.*';
  OpenDialog.Options  := [ofHideReadOnly, ofFileMustExist, ofDontAddToRecent];

  if not OpenDialog.Execute then
    Exit;

  SaveDialog.Title    := 'ÍobN֓ꂽt@C̕ۑ';
  SaveDialog.Filter   := 'bNꂽÍobN (*.cblbg)|*.cblbg';
  SaveDialog.FileName := ChangeFileExt(OpenDialog.FileName, '.cblbg');
  SaveDialog.Options  := [ofHideReadOnly, ofOverwritePrompt, ofDontAddToRecent];

  if not SaveDialog.Execute then
    Exit;

  if ExtractFileExt(SaveDialog.Filename) = '' then
    SaveDialog.Filename := SaveDialog.Filename + '.cblbg';

  try
    DLG := TEncryptForm.Create(Self);
    try
      ET := TEncryptThread.Create(True, FPubKey, OpenDialog.FileName, SaveDialog.FileName, DLG);
      ET.FreeOnTerminate := True;
      ET.OnTerminate := OnEncryptTerminate;
      ET.Resume;

      DLG.ShowModal;
    finally
      DLG.Free;
    end;
  except
    on E: Exception do
      MessageDlg('ÍŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0)
    else
      MessageDlg('ÍŃG[܂', mtError, [mbAbort], 0);
  end;
end;

procedure TMainForm.EncryptTextActionExecute(Sender: TObject);
var
  DLG: TInputTextForm;
  EDG: TEncryptForm;
  ET: TEncryptThread;
begin
  try
    DLG := TInputTextForm.Create(Self);
    try
      if DLG.ShowModal = mrCancel then
        Exit;

      SaveDialog.Title    := 'ÍobN֓ꂽt@C̕ۑ';
      SaveDialog.Filter   := 'bNꂽÍobN (*.cblbg)|*.cblbg';
      SaveDialog.FileName := ChangeFileExt(FPubKeyFileName, '.cblbg');
      SaveDialog.Options  := [ofHideReadOnly, ofOverwritePrompt, ofDontAddToRecent];

      if not SaveDialog.Execute then
        Exit;

      if ExtractFileExt(SaveDialog.Filename) = '' then
        SaveDialog.Filename := SaveDialog.Filename + '.cblbg';

      EDG := TEncryptForm.Create(Self);
      try
        ET := TEncryptThread.Create(True, FPubKey, DLG.Memo.Lines, SaveDialog.FileName, EDG);
        ET.FreeOnTerminate := True;
        ET.OnTerminate := OnEncryptTerminate;
        ET.Resume;

        EDG.ShowModal;
      finally
        EDG.Free;
      end;
    finally
      DLG.Free;
    end;
  except
    on E: Exception do
      MessageDlg('ÍŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0)
    else
      MessageDlg('ÍŃG[܂', mtError, [mbAbort], 0);
  end;
end;

end.
