/*
 * Common Source code Project -> VM -> FM-7/77AV -> Keyboard (Tables)
 * (C) 2015 K.Ohta <whatisthis.sowhat _at_ gmail.com>
 * Licence: GPLv2
 * History : 
 *  Jun 16, 2015 : Separate tables from keyboard.cpp .
 */

#ifndef _FM7_KEYBOARD_TABLES_H
#define _FM7_KEYBOARD_TABLES_H

#include "fm7_keyboard.h"

const uint16_t vk_matrix_106[0x68] = { // VK
	// +0, +1, +2, +3, +4, +5, +6, +7
	/* 0x00, ESC, 1 , 2, 3, 4, 5, 6 */
	0x00,		 VK_KANJI,	'1',		'2',		'3',		'4',		'5',		'6',		// +0x00	
	/* 7, 8, 9, 0, - , ^, \|, BS */
	'7',		'8',		'9',		'0',		0xbd,		0xde,		0xdc,		VK_BACK,	// +0x08
	/* TAB, Q, W, E, R, T, Y, U */
	VK_TAB,		'Q',		'W',		'E',		'R',		'T',		'Y',		'U',		// +0x10
	/* I, O, P, @, [, [RET], A, S */
	'I',		'O',		'P',		VK_OEM_3,	VK_OEM_4,	VK_RETURN,	'A',		'S',		//+0x18
	/* D, F, G, H, J, K, L, ; */
	'D',		'F',		'G',		'H',		'J',		'K',		'L',		VK_OEM_PLUS,		// +0x20
	/* :, ], Z, X, C, V, B, N */
	VK_OEM_1,	VK_OEM_6, 	'Z',		'X',		'C',		'V',		'B',		'N',		// +0x28
	/* M, , , ., / , \, RSPACE=Henkan , * , / */
	'M',		VK_OEM_COMMA,	VK_OEM_PERIOD,	VK_OEM_2,	VK_OEM_102,	VK_CONVERT,	VK_MULTIPLY,	VK_DIVIDE,	// +0x30
#if defined(_MSC_VER) || defined(Q_OS_WIN)
	/* + , - , 7, 8, 9, = = RWIN or Scroll Lock (Windows), 4, 5 */
	VK_ADD,		VK_SUBTRACT,	VK_NUMPAD7,	VK_NUMPAD8,	VK_NUMPAD9,	VK_SCROLL,	VK_NUMPAD4,	VK_NUMPAD5,	// +0x38
#else
	VK_ADD,		VK_SUBTRACT,	VK_NUMPAD7,	VK_NUMPAD8,	VK_NUMPAD9,	VK_RWIN,	VK_NUMPAD4,	VK_NUMPAD5,	// +0x38
#endif
	/* 6, NUMPADCOMMA=RMENU , 1, 2, 3, NUMPADENTER=RETURN,0, . */
	VK_NUMPAD6,	VK_RMENU,	VK_NUMPAD1,	VK_NUMPAD2,	VK_NUMPAD3,	VK_RETURN,	VK_NUMPAD0,	VK_DECIMAL,	// +0x40
	/* INS, EL, CLS, DEL, DUP, ↑, HOME,← */
	VK_INSERT,	VK_PRIOR,	VK_NEXT,	VK_DELETE,	VK_END,		VK_UP,		VK_HOME,	VK_LEFT,	// +0x48
	/* ↓, →, LCTRL, LSHIFT or SHIFT (Winwdows), RSHIFT, CAPS, Graph=LWIN or ALT (WIndows), Lspace=Muhenkan */
	VK_DOWN,	VK_RIGHT,	VK_CONTROL,	VK_LSHIFT,	VK_RSHIFT,	VK_CAPITAL,	VK_LMENU,	VK_NONCONVERT,	// +0x50
	/* Cspace=Space, *Unknown*, KANA, *Unknown* , ESC(Break), F1, F2, F3 */
	VK_SPACE,	0x00,		0x15,		0x00,		VK_ESCAPE,	VK_F1,		VK_F2,	VK_F3,	// +0x58
	/* F4, F5, F6, F7, F8, F9, F10 , *END* */
	VK_F4,		VK_F5,		VK_F6,		VK_F7,		VK_F8,		VK_F9,		VK_F10,		0xffff	// +0x60
};

struct key_tbl_t {
	uint16_t phy;
	uint16_t code;
};

// Key tables value from XM7.
const key_tbl_t standard_key[] = {
	{0x01, 0x1b},
	{0x02, 0x31},
	{0x03, 0x32},
	{0x04, 0x33},
	{0x05, 0x34},
	{0x06, 0x35},
	{0x07, 0x36},
	{0x08, 0x37},
	{0x09, 0x38},
	{0x0a, 0x39},
	{0x0b, 0x30},
	{0x0c, 0x2d},
	{0x0d, 0x5e},
	{0x0e, 0x5c},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0x71},
	{0x12, 0x77},
	{0x13, 0x65},
	{0x14, 0x72},
	{0x15, 0x74},
	{0x16, 0x79},
	{0x17, 0x75},
	{0x18, 0x69},
	{0x19, 0x6f},
	{0x1a, 0x70},
	{0x1b, 0x40},
	{0x1c, 0x5b},
	{0x1d, 0x0d},
	{0x1e, 0x61},
	{0x1f, 0x73},
	
	{0x20, 0x64},
	{0x21, 0x66},
	{0x22, 0x67},
	{0x23, 0x68},
	{0x24, 0x6a},
	{0x25, 0x6b},
	{0x26, 0x6c},
	{0x27, 0x3b},
	{0x28, 0x3a},
	{0x29, 0x5d},
	{0x2a, 0x7a},
	{0x2b, 0x78},
	{0x2c, 0x63},
	{0x2d, 0x76},
	{0x2e, 0x62},
	{0x2f, 0x6e},
	
	{0x30, 0x6d},
	{0x31, 0x2c},
	{0x32, 0x2e},
	{0x33, 0x2f},
	{0x34, 0x22},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
	
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x1e},
	{0x4e, 0x0b},
	{0x4f, 0x1d},
	
	{0x50, 0x1f},
	{0x51, 0x1c},
	
	{0x57, 0x20},
	{0x58, 0x20},
	
	{0x5d, 0x0101},
	{0x5e, 0x0102},
	{0x5f, 0x0103},
	{0x60, 0x0104},
	{0x61, 0x0105},
	{0x62, 0x0106},
	{0x63, 0x0107},
	{0x64, 0x0108},
	{0x65, 0x0109},
	{0x66, 0x010a},
	
	{0xffff, 0xffff}
};

const key_tbl_t standard_shift_key[] = {
	{0x01, 0x1b},
	{0x02, 0x21},
	{0x03, 0x22},
	{0x04, 0x23},
	{0x05, 0x24},
	{0x06, 0x25},
	{0x07, 0x26},
	{0x08, 0x27},
	{0x09, 0x28},
	{0x0a, 0x29},
	
	{0x0c, 0x3d},
	{0x0d, 0x7e},
	{0x0e, 0x7c},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0x51},
	{0x12, 0x57},
	{0x13, 0x45},
	{0x14, 0x52},
	{0x15, 0x54},
	{0x16, 0x59},
	{0x17, 0x55},
	{0x18, 0x49},
	{0x19, 0x4f},
	{0x1a, 0x50},
	{0x1b, 0x60},
	{0x1c, 0x7b},
	{0x1d, 0x0d},
	{0x1e, 0x41},
	{0x1f, 0x53},
	
	{0x20, 0x44},
	{0x21, 0x46},
	{0x22, 0x47},
	{0x23, 0x48},
	{0x24, 0x4a},
	{0x25, 0x4b},
	{0x26, 0x4c},
	{0x27, 0x2b},
	{0x28, 0x2a},
	{0x29, 0x7d},
	{0x2a, 0x5a},
	{0x2b, 0x58},
	{0x2c, 0x43},
	{0x2d, 0x56},
	{0x2e, 0x42},
	{0x2f, 0x4e},
	
	{0x30, 0x4d},
	{0x31, 0x3c},
	{0x32, 0x3e},
	{0x33, 0x3f},
	{0x34, 0x5f},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},

	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x19},
	{0x4e, 0x0b},
	{0x4f, 0x02},
	
	{0x50, 0x1a},
	{0x51, 0x06},

	{0x57, 0x20},
	{0x58, 0x20},
	{0xffff, 0xffff}
};

const struct key_tbl_t ctrl_key[] = {
	{0x0c, 0x1e},
	{0x0d, 0x1c},
	
	{0x11, 0x11},
	{0x12, 0x17},
	{0x13, 0x05},
	{0x14, 0x12},
	{0x15, 0x14},
	{0x16, 0x19},
	{0x17, 0x15},
	{0x18, 0x09},
	{0x19, 0x0f}, // 09
	{0x1a, 0x10},
	{0x1b, 0x00},
	{0x1c, 0x1b},
	{0x1e, 0x01},
	{0x1f, 0x13},
	
	{0x20, 0x04},
	{0x21, 0x06},
	{0x22, 0x07},
	{0x23, 0x08},
	{0x24, 0x0a},
	{0x25, 0x0b},
	{0x26, 0x0c},
	{0x29, 0x1d},
	{0x2a, 0x1a},
	{0x2b, 0x18},
	{0x2c, 0x03},
	{0x2d, 0x16},
	{0x2e, 0x02},
	{0x2f, 0x0e},
  
	{0x30, 0x0d},
	
	{0x34, 0x1f},
	{0xffff, 0xffff}
};

const struct key_tbl_t ctrl_shift_key[] = {
	{0x0c, 0x1e},
	{0x0d, 0x1c},
	
	{0x11, 0x11},
	{0x12, 0x17},
	{0x13, 0x05},
	{0x14, 0x12},
	{0x15, 0x14},
	{0x16, 0x19},
	{0x17, 0x15},
	{0x18, 0x09},
	{0x19, 0x09},
	{0x1a, 0x10},
	{0x1b, 0x00},
	{0x1c, 0x1b},
	{0x1e, 0x01},
	{0x1f, 0x13},
  
	{0x20, 0x04},
	{0x21, 0x06},
	{0x22, 0x07},
	{0x23, 0x08},
	{0x24, 0x0a},
	{0x25, 0x0b},
	{0x26, 0x0c},
	{0x29, 0x1d},
	{0x2a, 0x1a},
	{0x2b, 0x18},
	{0x2c, 0x03},
	{0x2d, 0x16},
	{0x2e, 0x02},
	{0x2f, 0x0e},
  
	{0x30, 0x0d},
	
	{0x34, 0x1f},
	{0xffff, 0xffff}
};

const struct key_tbl_t graph_key[] = {
	{0x01, 0x1b},
	{0x02, 0xf9},
	{0x03, 0xfa},
	{0x04, 0xfb},
	{0x05, 0xfc},
	{0x06, 0xf2},
	{0x07, 0xf3},
	{0x08, 0xf4},
	{0x09, 0xf5},
	{0x0a, 0xf6},
	{0x0b, 0xf7},
	{0x0c, 0x8c},
	{0x0d, 0x8b},
	{0x0e, 0xf1},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0xfd},
	{0x12, 0xf8},
	{0x13, 0xe4},
	{0x14, 0xe5},
	{0x15, 0x9c},
	{0x16, 0x9d},
	{0x17, 0xf0},
	{0x18, 0xe8},
	{0x19, 0xe9},
	{0x1a, 0x8d},
	{0x1b, 0x8a},
	{0x1c, 0xed},
	{0x1d, 0x0d},
	{0x1e, 0x95},
	{0x1f, 0x96},
  
	{0x20, 0xe6},
	{0x21, 0xe7},
	{0x22, 0x9e},
	{0x23, 0x9f},
	{0x24, 0xea},
	{0x25, 0xeb},
	{0x26, 0x8e},
	{0x27, 0x99},
	{0x28, 0x94},
	{0x29, 0xec},
	{0x2a, 0x80},
	{0x2b, 0x81},
	{0x2c, 0x82},
	{0x2d, 0x83},
	{0x2e, 0x84},
	{0x2f, 0x85},
	
	{0x30, 0x86},
	{0x31, 0x87},
	{0x32, 0x88},
	{0x33, 0x97},
	{0x34, 0xe0},
	{0x35, 0x20},
	{0x36, 0x98},
	{0x37, 0x91},
	{0x38, 0x99},
	{0x39, 0xee},
	{0x3a, 0xe1},
	{0x3b, 0xe2},
	{0x3c, 0xe3},
	{0x3d, 0xef},
	{0x3e, 0x93},
	{0x3f, 0x8f},

	{0x40, 0x92}, 
	
	{0x42, 0x9a},
	{0x43, 0x90},
	{0x44, 0x9b},
	{0x45, 0x0d},
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x1e},
	{0x4e, 0x0b},
	{0x4f, 0x1d},
  
	{0x50, 0x1f},
	{0x51, 0x1c},

	{0x57, 0x20},
	{0x58, 0x20},
	/* Belows is none when shift */
	{0x5d, 0x101},
	{0x5e, 0x102},
	{0x5f, 0x103},
	{0x60, 0x104},
	{0x61, 0x105},
	{0x62, 0x106},
	{0x63, 0x107},
	{0x64, 0x108},
	{0x65, 0x109},
	{0x66, 0x10a},
	{0xffff, 0xffff}
};
const struct key_tbl_t graph_shift_key[] = {
	{0x01, 0x1b},
	{0x02, 0xf9},
	{0x03, 0xfa},
	{0x04, 0xfb},
	{0x05, 0xfc},
	{0x06, 0xf2},
	{0x07, 0xf3},
	{0x08, 0xf4},
	{0x09, 0xf5},
	{0x0a, 0xf6},
	{0x0b, 0xf7},
	{0x0c, 0x8c},
	{0x0d, 0x8b},
	{0x0e, 0xf1},
	{0x0f, 0x08},

	{0x10, 0x09},
	{0x11, 0xfd},
	{0x12, 0xf8},
	{0x13, 0xe4},
	{0x14, 0xe5},
	{0x15, 0x9c},
	{0x16, 0x9d},
	{0x17, 0xf0},
	{0x18, 0xe8},
	{0x19, 0xe9},
	{0x1a, 0x8d},
	{0x1b, 0x8a},
	{0x1c, 0xed},
	{0x1d, 0x0d},
	{0x1e, 0x95},
	{0x1f, 0x96},
  
	{0x20, 0xe6},
	{0x21, 0xe7},
	{0x22, 0x9e},
	{0x23, 0x9f},
	{0x24, 0xea},
	{0x25, 0xeb},
	{0x26, 0x8e},
	{0x27, 0x99},
	{0x28, 0x94},
	{0x29, 0xec},
	{0x2a, 0x80},
	{0x2b, 0x81},
	{0x2c, 0x82},
	{0x2d, 0x83},
	{0x2e, 0x84},
	{0x2f, 0x85},
  
	{0x30, 0x86},
	{0x31, 0x87},
	{0x32, 0x88},
	{0x33, 0x97},
	{0x34, 0xe0},
	{0x35, 0x20},
	{0x36, 0x98},
	{0x37, 0x91},
	{0x38, 0x99},
	{0x39, 0xee},
	{0x3a, 0xe1},
	{0x3b, 0xe2},
	{0x3c, 0xe3},
	{0x3d, 0xef},
	{0x3e, 0x93},
	{0x3f, 0x8f},

	{0x40, 0x92}, 
	
	{0x42, 0x9a},
	{0x43, 0x90},
	{0x44, 0x9b},
	{0x45, 0x0d},
	
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x19},
	{0x4e, 0x0b},
	{0x4f, 0x02},
  
	{0x50, 0x1a},
	{0x51, 0x06},
	
	{0x57, 0x20},
	{0x58, 0x20},
	{0xffff, 0xffff}
};

const struct key_tbl_t kana_key[] = {
	{0x01, 0x1b},
	{0x02, 0xc7},
	{0x03, 0xcc},
	{0x04, 0xb1},
	{0x05, 0xb3},
	{0x06, 0xb4},
	{0x07, 0xb5},
	{0x08, 0xd4},
	{0x09, 0xd5},
	{0x0a, 0xd6},
	{0x0b, 0xdc},
	{0x0c, 0xce},
	{0x0d, 0xcd},
	{0x0e, 0xb0},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0xc0},
	{0x12, 0xc3},
	{0x13, 0xb2},
	{0x14, 0xbd},
	{0x15, 0xb6},
	{0x16, 0xdd},
	{0x17, 0xc5},
	{0x18, 0xc6},
	{0x19, 0xd7},
	{0x1a, 0xbe},
	{0x1b, 0xde},
	{0x1c, 0xdf},
	{0x1d, 0x0d},
	{0x1e, 0xc1},
	{0x1f, 0xc4},
	
	{0x20, 0xbc},
	{0x21, 0xca},
	{0x22, 0xb7},
	{0x23, 0xb8},
	{0x24, 0xcf},
	{0x25, 0xc9},
	{0x26, 0xd8},
	{0x27, 0xda},
	{0x28, 0xb9},
	{0x29, 0xd1},
	{0x2a, 0xc2},
	{0x2b, 0xbb},
	{0x2c, 0xbf},
	{0x2d, 0xcb},
	{0x2e, 0xba},
	{0x2f, 0xd0},
		  
	{0x30, 0xd3},
	{0x31, 0xc8},
	{0x32, 0xd9},
	{0x33, 0xd2},
	{0x34, 0xdb},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
		  
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
  
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x1e},
	
	{0x4e, 0x0b},
	{0x4f, 0x1d},
	{0x50, 0x1f},
	{0x51, 0x1c},
	
	
	{0x57, 0x20},
	{0x58, 0x20},
	
	{0x5d, 0x0101},
	{0x5e, 0x0102},
	{0x5f, 0x0103},
	{0x60, 0x0104},
	{0x61, 0x0105},
	{0x62, 0x0106},
	{0x63, 0x0107},
	{0x64, 0x0108},
	{0x65, 0x0109},
	{0x66, 0x010a},

	{0xffff, 0xffff}
};

const struct key_tbl_t kana_shift_key[] = {
	{0x01, 0x1b},
	{0x04, 0xa7},
	{0x05, 0xa9},
	{0x06, 0xaa},
	{0x07, 0xab},
	{0x08, 0xac},
	{0x09, 0xad},
	{0x0a, 0xae},
	{0x0b, 0xa6},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x13, 0xa8},
	{0x1c, 0xa2},
	{0x1d, 0x0d},
	
	{0x29, 0xa3},
	{0x2a, 0xaf},
	
	{0x31, 0xa4},
	{0x32, 0xa1},
	{0x33, 0xa5},
	
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
	
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
  
	{0x48, 0x12},
	{0x49, 0x05},
	{0x4a, 0x0c},
	{0x4b, 0x7f},
	{0x4c, 0x11},
	{0x4d, 0x19},

	{0x4e, 0x0b},
	{0x4f, 0x02},
	{0x50, 0x1a},
	{0x51, 0x06},
	
	{0x57, 0x20},
	{0x58, 0x20},

	{0xffff, 0xffff}
};

#if defined(_FM77AV_VARIANTS)
const key_tbl_t standard_key_16beta[] = {
	{0x01, 0x1b},
	{0x02, 0x31},
	{0x03, 0x32},
	{0x04, 0x33},
	{0x05, 0x34},
	{0x06, 0x35},
	{0x07, 0x36},
	{0x08, 0x37},
	{0x09, 0x38},
	{0x0a, 0x39},
	{0x0b, 0x30},
	{0x0c, 0x2d},
	{0x0d, 0x5e},
	{0x0e, 0x5c},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0x71},
	{0x12, 0x77},
	{0x13, 0x65},
	{0x14, 0x72},
	{0x15, 0x74},
	{0x16, 0x79},
	{0x17, 0x75},
	{0x18, 0x69},
	{0x19, 0x6f},
	{0x1a, 0x70},
	{0x1b, 0x40},
	{0x1c, 0x5b},
	{0x1d, 0x0d},
	{0x1e, 0x61},
	{0x1f, 0x73},
	
	{0x20, 0x64},
	{0x21, 0x66},
	{0x22, 0x67},
	{0x23, 0x68},
	{0x24, 0x6a},
	{0x25, 0x6b},
	{0x26, 0x6c},
	{0x27, 0x3b},
	{0x28, 0x3a},
	{0x29, 0x5d},
	{0x2a, 0x7a},
	{0x2b, 0x78},
	{0x2c, 0x63},
	{0x2d, 0x76},
	{0x2e, 0x62},
	{0x2f, 0x6e},
	
	{0x30, 0x6d},
	{0x31, 0x2c},
	{0x32, 0x2e},
	{0x33, 0x2f},
	{0x34, 0x22},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
	
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
	{0x48, 0x110},
	{0x49, 0x112},
	{0x4a, 0x111},
	{0x4b, 0x114},
	{0x4c, 0x133},
	{0x4d, 0x1e},
	{0x4e, 0x115},
	{0x4f, 0x118},
	
	{0x50, 0x117},
	{0x51, 0x119},
	
	{0x57, 0x10e},
	{0x58, 0x10d},
	
	{0x5d, 0x0101},
	{0x5e, 0x0102},
	{0x5f, 0x0103},
	{0x60, 0x0104},
	{0x61, 0x0105},
	{0x62, 0x0106},
	{0x63, 0x0107},
	{0x64, 0x0108},
	{0x65, 0x0109},
	{0x66, 0x010a},
	
	{0xffff, 0xffff}
};

const key_tbl_t standard_shift_key_16beta[] = {
	{0x01, 0x1b},
	{0x02, 0x21},
	{0x03, 0x22},
	{0x04, 0x23},
	{0x05, 0x24},
	{0x06, 0x25},
	{0x07, 0x26},
	{0x08, 0x27},
	{0x09, 0x28},
	{0x0a, 0x29},
	
	{0x0c, 0x3d},
	{0x0d, 0x7e},
	{0x0e, 0x7c},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0x51},
	{0x12, 0x57},
	{0x13, 0x45},
	{0x14, 0x52},
	{0x15, 0x54},
	{0x16, 0x59},
	{0x17, 0x55},
	{0x18, 0x49},
	{0x19, 0x4f},
	{0x1a, 0x50},
	{0x1b, 0x60},
	{0x1c, 0x7b},
	{0x1d, 0x0d},
	{0x1e, 0x41},
	{0x1f, 0x53},
	
	{0x20, 0x44},
	{0x21, 0x46},
	{0x22, 0x47},
	{0x23, 0x48},
	{0x24, 0x4a},
	{0x25, 0x4b},
	{0x26, 0x4c},
	{0x27, 0x2b},
	{0x28, 0x2a},
	{0x29, 0x7d},
	{0x2a, 0x5a},
	{0x2b, 0x58},
	{0x2c, 0x43},
	{0x2d, 0x56},
	{0x2e, 0x42},
	{0x2f, 0x4e},
	
	{0x30, 0x4d},
	{0x31, 0x3c},
	{0x32, 0x3e},
	{0x33, 0x3f},
	{0x34, 0x5f},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},

	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
	{0x48, 0x130},
	{0x49, 0x132},
	{0x4a, 0x131},
	{0x4b, 0x134},
	{0x4c, 0x133},
	{0x4d, 0x136},
	{0x4e, 0x135},
	{0x4f, 0x138},
	
	{0x50, 0x137},
	{0x51, 0x139},

	{0x57, 0x12e},
	{0x58, 0x12d},
	{0xffff, 0xffff}
};

const struct key_tbl_t ctrl_key_16beta[] = {
	{0x0c, 0x1e},
	{0x0d, 0x1c},
	
	{0x11, 0x11},
	{0x12, 0x17},
	{0x13, 0x05},
	{0x14, 0x12},
	{0x15, 0x14},
	{0x16, 0x19},
	{0x17, 0x15},
	{0x18, 0x09},
	{0x19, 0x0f}, // 09
	{0x1a, 0x10},
	{0x1b, 0x00},
	{0x1c, 0x1b},
	{0x1e, 0x01},
	{0x1f, 0x13},
	
	{0x20, 0x04},
	{0x21, 0x06},
	{0x22, 0x07},
	{0x23, 0x08},
	{0x24, 0x0a},
	{0x25, 0x0b},
	{0x26, 0x0c},
	{0x29, 0x1d},
	{0x2a, 0x1a},
	{0x2b, 0x18},
	{0x2c, 0x03},
	{0x2d, 0x16},
	{0x2e, 0x02},
	{0x2f, 0x0e},
  
	{0x30, 0x0d},
	{0x34, 0x1f},
	
	{0x48, 0x150},
	{0x49, 0x152},
	{0x4a, 0x151},
	{0x4b, 0x154},
	{0x4c, 0x153},
	{0x4d, 0x156},
	{0x4e, 0x155},
	{0x4f, 0x158},
	
	{0x50, 0x157},
	{0x51, 0x159},

	{0x57, 0x14e},
	{0x58, 0x14d},
	{0xffff, 0xffff}
};

const struct key_tbl_t ctrl_shift_key_16beta[] = {
	{0x0c, 0x1e},
	{0x0d, 0x1c},
	
	{0x11, 0x11},
	{0x12, 0x17},
	{0x13, 0x05},
	{0x14, 0x12},
	{0x15, 0x14},
	{0x16, 0x19},
	{0x17, 0x15},
	{0x18, 0x09},
	{0x19, 0x09},
	{0x1a, 0x10},
	{0x1b, 0x00},
	{0x1c, 0x1b},
	{0x1e, 0x01},
	{0x1f, 0x13},
  
	{0x20, 0x04},
	{0x21, 0x06},
	{0x22, 0x07},
	{0x23, 0x08},
	{0x24, 0x0a},
	{0x25, 0x0b},
	{0x26, 0x0c},
	{0x29, 0x1d},
	{0x2a, 0x1a},
	{0x2b, 0x18},
	{0x2c, 0x03},
	{0x2d, 0x16},
	{0x2e, 0x02},
	{0x2f, 0x0e},
  
	{0x30, 0x0d},
	
	{0x34, 0x1f},
	
	{0x48, 0x150},
	{0x49, 0x152},
	{0x4a, 0x151},
	{0x4b, 0x154},
	{0x4c, 0x153},
	{0x4d, 0x156},
	{0x4e, 0x155},
	{0x4f, 0x158},
	
	{0x50, 0x157},
	{0x51, 0x159},

	{0x57, 0x14e},
	{0x58, 0x14d},
	{0xffff, 0xffff}
};

const struct key_tbl_t graph_key_16beta[] = {
	{0x01, 0x1b},
	{0x02, 0xf9},
	{0x03, 0xfa},
	{0x04, 0xfb},
	{0x05, 0xfc},
	{0x06, 0xf2},
	{0x07, 0xf3},
	{0x08, 0xf4},
	{0x09, 0xf5},
	{0x0a, 0xf6},
	{0x0b, 0xf7},
	{0x0c, 0x8c},
	{0x0d, 0x8b},
	{0x0e, 0xf1},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0xfd},
	{0x12, 0xf8},
	{0x13, 0xe4},
	{0x14, 0xe5},
	{0x15, 0x9c},
	{0x16, 0x9d},
	{0x17, 0xf0},
	{0x18, 0xe8},
	{0x19, 0xe9},
	{0x1a, 0x8d},
	{0x1b, 0x8a},
	{0x1c, 0xed},
	{0x1d, 0x0d},
	{0x1e, 0x95},
	{0x1f, 0x96},
  
	{0x20, 0xe6},
	{0x21, 0xe7},
	{0x22, 0x9e},
	{0x23, 0x9f},
	{0x24, 0xea},
	{0x25, 0xeb},
	{0x26, 0x8e},
	{0x27, 0x99},
	{0x28, 0x94},
	{0x29, 0xec},
	{0x2a, 0x80},
	{0x2b, 0x81},
	{0x2c, 0x82},
	{0x2d, 0x83},
	{0x2e, 0x84},
	{0x2f, 0x85},
	
	{0x30, 0x86},
	{0x31, 0x87},
	{0x32, 0x88},
	{0x33, 0x97},
	{0x34, 0xe0},
	{0x35, 0x20},
	{0x36, 0x98},
	{0x37, 0x91},
	{0x38, 0x99},
	{0x39, 0xee},
	{0x3a, 0xe1},
	{0x3b, 0xe2},
	{0x3c, 0xe3},
	{0x3d, 0xef},
	{0x3e, 0x93},
	{0x3f, 0x8f},

	{0x40, 0x92}, 
	
	{0x42, 0x9a},
	{0x43, 0x90},
	{0x44, 0x9b},
	{0x45, 0x0d},
	{0x48, 0x110},
	{0x49, 0x112},
	{0x4a, 0x111},
	{0x4b, 0x114},
	{0x4c, 0x113},
	{0x4d, 0x116},
	{0x4e, 0x115},
	{0x4f, 0x118},
  
	{0x50, 0x117},
	{0x51, 0x119},

	{0x57, 0x10e},
	{0x58, 0x10d},
	/* Belows is none when shift */
	{0x5d, 0x101},
	{0x5e, 0x102},
	{0x5f, 0x103},
	{0x60, 0x104},
	{0x61, 0x105},
	{0x62, 0x106},
	{0x63, 0x107},
	{0x64, 0x108},
	{0x65, 0x109},
	{0x66, 0x10a},
	{0xffff, 0xffff}
};
const struct key_tbl_t graph_shift_key_16beta[] = {
	{0x01, 0x1b},
	{0x02, 0xf9},
	{0x03, 0xfa},
	{0x04, 0xfb},
	{0x05, 0xfc},
	{0x06, 0xf2},
	{0x07, 0xf3},
	{0x08, 0xf4},
	{0x09, 0xf5},
	{0x0a, 0xf6},
	{0x0b, 0xf7},
	{0x0c, 0x8c},
	{0x0d, 0x8b},
	{0x0e, 0xf1},
	{0x0f, 0x08},

	{0x10, 0x09},
	{0x11, 0xfd},
	{0x12, 0xf8},
	{0x13, 0xe4},
	{0x14, 0xe5},
	{0x15, 0x9c},
	{0x16, 0x9d},
	{0x17, 0xf0},
	{0x18, 0xe8},
	{0x19, 0xe9},
	{0x1a, 0x8d},
	{0x1b, 0x8a},
	{0x1c, 0xed},
	{0x1d, 0x0d},
	{0x1e, 0x95},
	{0x1f, 0x96},
  
	{0x20, 0xe6},
	{0x21, 0xe7},
	{0x22, 0x9e},
	{0x23, 0x9f},
	{0x24, 0xea},
	{0x25, 0xeb},
	{0x26, 0x8e},
	{0x27, 0x99},
	{0x28, 0x94},
	{0x29, 0xec},
	{0x2a, 0x80},
	{0x2b, 0x81},
	{0x2c, 0x82},
	{0x2d, 0x83},
	{0x2e, 0x84},
	{0x2f, 0x85},
  
	{0x30, 0x86},
	{0x31, 0x87},
	{0x32, 0x88},
	{0x33, 0x97},
	{0x34, 0xe0},
	{0x35, 0x20},
	{0x36, 0x98},
	{0x37, 0x91},
	{0x38, 0x99},
	{0x39, 0xee},
	{0x3a, 0xe1},
	{0x3b, 0xe2},
	{0x3c, 0xe3},
	{0x3d, 0xef},
	{0x3e, 0x93},
	{0x3f, 0x8f},

	{0x40, 0x92}, 
	
	{0x42, 0x9a},
	{0x43, 0x90},
	{0x44, 0x9b},
	{0x45, 0x0d},
	
	{0x48, 0x130},
	{0x49, 0x132},
	{0x4a, 0x131},
	{0x4b, 0x134},
	{0x4c, 0x133},
	{0x4d, 0x136},
	{0x4e, 0x135},
	{0x4f, 0x138},
  
	{0x50, 0x137},
	{0x51, 0x139},

	{0x57, 0x12e},
	{0x58, 0x12d},
	{0xffff, 0xffff}
};

const struct key_tbl_t kana_key_16beta[] = {
	{0x01, 0x1b},
	{0x02, 0xc7},
	{0x03, 0xcc},
	{0x04, 0xb1},
	{0x05, 0xb3},
	{0x06, 0xb4},
	{0x07, 0xb5},
	{0x08, 0xd4},
	{0x09, 0xd5},
	{0x0a, 0xd6},
	{0x0b, 0xdc},
	{0x0c, 0xce},
	{0x0d, 0xcd},
	{0x0e, 0xb0},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x11, 0xc0},
	{0x12, 0xc3},
	{0x13, 0xb2},
	{0x14, 0xbd},
	{0x15, 0xb6},
	{0x16, 0xdd},
	{0x17, 0xc5},
	{0x18, 0xc6},
	{0x19, 0xd7},
	{0x1a, 0xbe},
	{0x1b, 0xde},
	{0x1c, 0xdf},
	{0x1d, 0x0d},
	{0x1e, 0xc1},
	{0x1f, 0xc4},
	
	{0x20, 0xbc},
	{0x21, 0xca},
	{0x22, 0xb7},
	{0x23, 0xb8},
	{0x24, 0xcf},
	{0x25, 0xc9},
	{0x26, 0xd8},
	{0x27, 0xda},
	{0x28, 0xb9},
	{0x29, 0xd1},
	{0x2a, 0xc2},
	{0x2b, 0xbb},
	{0x2c, 0xbf},
	{0x2d, 0xcb},
	{0x2e, 0xba},
	{0x2f, 0xd0},
		  
	{0x30, 0xd3},
	{0x31, 0xc8},
	{0x32, 0xd9},
	{0x33, 0xd2},
	{0x34, 0xdb},
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
		  
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
  
	{0x48, 0x110},
	{0x49, 0x112},
	{0x4a, 0x111},
	{0x4b, 0x114},
	{0x4c, 0x113},
	{0x4d, 0x116},
	{0x4e, 0x115},
	{0x4f, 0x118},
	
	{0x50, 0x117},
	{0x51, 0x119},
	{0x57, 0x10e},
	{0x58, 0x10d},
	
	{0x5d, 0x0101},
	{0x5e, 0x0102},
	{0x5f, 0x0103},
	{0x60, 0x0104},
	{0x61, 0x0105},
	{0x62, 0x0106},
	{0x63, 0x0107},
	{0x64, 0x0108},
	{0x65, 0x0109},
	{0x66, 0x010a},

	{0xffff, 0xffff}
};

const struct key_tbl_t kana_shift_key_16beta[] = {
	{0x01, 0x1b},
	{0x04, 0xa7},
	{0x05, 0xa9},
	{0x06, 0xaa},
	{0x07, 0xab},
	{0x08, 0xac},
	{0x09, 0xad},
	{0x0a, 0xae},
	{0x0b, 0xa6},
	{0x0f, 0x08},
	
	{0x10, 0x09},
	{0x13, 0xa8},
	{0x1c, 0xa2},
	{0x1d, 0x0d},
	
	{0x29, 0xa3},
	{0x2a, 0xaf},
	
	{0x31, 0xa4},
	{0x32, 0xa1},
	{0x33, 0xa5},
	
	{0x35, 0x20},
	{0x36, 0x2a},
	{0x37, 0x2f},
	{0x38, 0x2b},
	{0x39, 0x2d},
	{0x3a, 0x37},
	{0x3b, 0x38},
	{0x3c, 0x39},
	{0x3d, 0x3d},
	{0x3e, 0x34},
	{0x3f, 0x35},
	
	{0x40, 0x36},
	{0x41, 0x2c},
	{0x42, 0x31},
	{0x43, 0x32},
	{0x44, 0x33},
	{0x45, 0x0d},
	{0x46, 0x30},
	{0x47, 0x2e},
  
	{0x48, 0x110},
	{0x49, 0x112},
	{0x4a, 0x111},
	{0x4b, 0x114},
	{0x4c, 0x113},
	{0x4d, 0x116},
	{0x4e, 0x115},
	{0x4f, 0x118},

	{0x50, 0x117},
	{0x51, 0x119},
	{0x57, 0x10e},
	{0x58, 0x10d},
	
	{0xffff, 0xffff}
};
#endif // _FM77AV_VARIANTS

#endif // _FM7_KEYBOARD_TABLES_H
