/*
	NEC TK-80BS (COMPO BS/80) Emulator 'eTK-80BS'

	Author : Takeda.Toshiya
	Date   : 2008.08.26 -

	[ display ]
*/

#include "display.h"

static const int led_pattern[46][33] = {
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,2,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,5,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
};

void DISPLAY::initialize()
{
	// load rom image
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(create_local_path(_T("FONT.ROM")), FILEIO_READ_BINARY)) {
		fio->Fread(font, sizeof(font), 1);
		fio->Fclose();
	}
	delete fio;
	
	mode = 2;
	dma = true;
}

void DISPLAY::write_signal(int id, uint32_t data, uint32_t mask)
{
	if(id == SIG_DISPLAY_MODE) {
		// 8255 PC on TK-80BS
		mode = data & mask;
	} else if(id == SIG_DISPLAY_DMA) {
		// 8255 PC on TK-80
		dma = ((data & mask) != 0);
	}
}

void DISPLAY::draw_screen()
{
	// draw screen
	scrntype_t color_w = (mode & 2) ? RGB_COLOR(255, 255, 255) : RGB_COLOR(0, 0, 1);
	scrntype_t color_b = (mode & 2) ? RGB_COLOR(0, 0, 1) : RGB_COLOR(255, 255, 255);
	int code_ofs = (mode & 1) << 8;
	int ptr = 0;

	for(int y = 0; y < 128; y += 8) {
		for(int x = 0; x < 256; x += 8) {
			int code = vram[ptr++];
			if(code != 0x20) {
				vm->draw_ranges = 9;
			}
			code |= code_ofs;
			uint8_t* font_base = &font[code << 3];
			
			for(int l = 0; l < 8; l++) {
				uint8_t pat = font_base[l];
				scrntype_t* dest = &screen[l][x];
				
				dest[0] = (pat & 0x80) ? color_w : color_b;
				dest[1] = (pat & 0x40) ? color_w : color_b;
				dest[2] = (pat & 0x20) ? color_w : color_b;
				dest[3] = (pat & 0x10) ? color_w : color_b;
				dest[4] = (pat & 0x08) ? color_w : color_b;
				dest[5] = (pat & 0x04) ? color_w : color_b;
				dest[6] = (pat & 0x02) ? color_w : color_b;
				dest[7] = (pat & 0x01) ? color_w : color_b;
			}
		}
		for(int l = 0; l < 8; l++) {
			scrntype_t* dest0 = emu->get_screen_buffer(vm_ranges[8].y + (y + l) * 2 + 0) + vm_ranges[8].x;
			scrntype_t* dest1 = emu->get_screen_buffer(vm_ranges[8].y + (y + l) * 2 + 1) + vm_ranges[8].x;
			scrntype_t* src = screen[l];
			for(int x = 0, xx = 0; x < 256; x++, xx += 2) {
				dest0[xx] = dest0[xx + 1] = src[x];
			}
			memcpy(dest1, dest0, 256 * 2 * sizeof(scrntype_t));
		}
	}
	// draw 7-seg LEDs
	scrntype_t col[10];
	scrntype_t color_on  = RGB_COLOR(255, 8, 72);
	scrntype_t color_off = RGB_COLOR(56, 0, 0);
	col[0] = RGB_COLOR(38, 8, 0);
	col[9] = color_off;
	
	memset(screen, 0, sizeof(screen));
	for(int i = 0; i < 8; i++) {
		uint8_t pat = dma ? led[i] : 0;
		col[1] = pat & 0x01 ? color_on : color_off;
		col[2] = pat & 0x02 ? color_on : color_off;
		col[3] = pat & 0x04 ? color_on : color_off;
		col[4] = pat & 0x08 ? color_on : color_off;
		col[5] = pat & 0x10 ? color_on : color_off;
		col[6] = pat & 0x20 ? color_on : color_off;
		col[7] = pat & 0x40 ? color_on : color_off;
		col[8] = pat & 0x80 ? color_on : color_off;
		for(int y = 0; y < 46; y++) {
			scrntype_t* dest = emu->get_screen_buffer(vm_ranges[i].y + y) + vm_ranges[i].x;
			for(int x = 0; x < 33; x++) {
				dest[x] = col[led_pattern[y][x]];
			}
		}
	}
}

#define STATE_VERSION	1

void DISPLAY::save_state(FILEIO* state_fio)
{
	state_fio->FputUint32(STATE_VERSION);
	state_fio->FputInt32(this_device_id);
	
	state_fio->FputInt32(mode);
	state_fio->FputBool(dma);
}

bool DISPLAY::load_state(FILEIO* state_fio)
{
	if(state_fio->FgetUint32() != STATE_VERSION) {
		return false;
	}
	if(state_fio->FgetInt32() != this_device_id) {
		return false;
	}
	mode = state_fio->FgetInt32();
	dma = state_fio->FgetBool();
	return true;
}

