/*
	NEC TK-80BS (COMPO BS/80) Emulator 'eTK-80BS'
	NEC TK-80 Emulator 'eTK-80'
	NEC TK-85 Emulator 'eTK-85'

	Author : Takeda.Toshiya
	Date   : 2008.08.26 -

	[ display ]
*/

#include "display.h"

static const int led_pattern[LED_SIZE_Y][LED_SIZE_X] = {
#if defined(_TK80BS) || defined(_TK80)
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,2,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,5,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,0,8,8,8,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
#else
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,0,1,1,1,1,1,1,1,1,1,1,1,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,9,9},
	{9,9,0,0,0,0,6,0,7,7,7,7,7,7,7,7,7,7,7,7,0,2,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,5,0,7,7,7,7,7,7,7,7,7,7,7,7,0,3,0,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,9,9},
	{9,9,0,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,9,9},
	{9,9,0,0,5,5,0,4,4,4,4,4,4,4,4,4,4,4,0,3,3,3,0,8,8,8,0,9,9},
	{9,9,0,0,5,0,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,3,0,8,8,8,0,9,9},
	{9,9,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,3,0,8,8,8,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
	{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9},
#endif
};

void DISPLAY::initialize()
{
#if defined(_TK80BS)
	// load rom image
	FILEIO* fio = new FILEIO();
	if(fio->Fopen(create_local_path(_T("FONT.ROM")), FILEIO_READ_BINARY)) {
		fio->Fread(font, sizeof(font), 1);
		fio->Fclose();
	}
	delete fio;
	
	mode = 2;
#endif
	dma = true;
}

void DISPLAY::write_signal(int id, uint32_t data, uint32_t mask)
{
#if defined(_TK80BS)
	if(id == SIG_DISPLAY_MODE) {
		// 8255 PC on TK-80BS
		mode = data & mask;
	} else
#endif
	if(id == SIG_DISPLAY_DMA) {
		// 8255 PC on TK-80
		dma = ((data & mask) != 0);
	}
}

void DISPLAY::draw_screen()
{
#if defined(_TK80BS)
	// draw screen
	scrntype_t color_w = (mode & 2) ? RGB_COLOR(255, 255, 255) : RGB_COLOR(0, 0, 1);
	scrntype_t color_b = (mode & 2) ? RGB_COLOR(0, 0, 1) : RGB_COLOR(255, 255, 255);
	scrntype_t screen[36][256] = {0};
	int code_ofs = (mode & 1) << 8;
	int ptr = 0;

	for(int y = 0; y < 128; y += 8) {
		for(int x = 0; x < 256; x += 8) {
			int code = vram[ptr++];
			if(code != 0x20) {
				vm->draw_ranges = 9;
			}
			code |= code_ofs;
			uint8_t* font_base = &font[code << 3];
			
			for(int l = 0; l < 8; l++) {
				uint8_t pat = font_base[l];
				scrntype_t* dest = &screen[l][x];
				
				dest[0] = (pat & 0x80) ? color_w : color_b;
				dest[1] = (pat & 0x40) ? color_w : color_b;
				dest[2] = (pat & 0x20) ? color_w : color_b;
				dest[3] = (pat & 0x10) ? color_w : color_b;
				dest[4] = (pat & 0x08) ? color_w : color_b;
				dest[5] = (pat & 0x04) ? color_w : color_b;
				dest[6] = (pat & 0x02) ? color_w : color_b;
				dest[7] = (pat & 0x01) ? color_w : color_b;
			}
		}
		for(int l = 0; l < 8; l++) {
			scrntype_t* dest0 = emu->get_screen_buffer(vm_ranges[8].y + (y + l) * 2 + 0) + vm_ranges[8].x;
			scrntype_t* dest1 = emu->get_screen_buffer(vm_ranges[8].y + (y + l) * 2 + 1) + vm_ranges[8].x;
			scrntype_t* src = screen[l];
			for(int x = 0, xx = 0; x < 256; x++, xx += 2) {
				dest0[xx] = dest0[xx + 1] = src[x];
			}
			memcpy(dest1, dest0, 256 * 2 * sizeof(scrntype_t));
		}
	}
#endif
	
	// draw 7-seg LEDs
	scrntype_t col[10];
	scrntype_t color_on  = RGB_COLOR(255, 8, 72);
#if defined(_TK80BS) || defined(_TK80)
	scrntype_t color_off = RGB_COLOR(56, 0, 0);
	col[0] = RGB_COLOR(38, 8, 0);
#else
	scrntype_t color_off = RGB_COLOR(111, 33, 33);
	col[0] = RGB_COLOR(96, 53, 53);
#endif
	col[9] = color_off;
	
	for(int i = 0; i < 8; i++) {
		uint8_t pat = dma ? led[i] : 0;
		col[1] = pat & 0x01 ? color_on : color_off;
		col[2] = pat & 0x02 ? color_on : color_off;
		col[3] = pat & 0x04 ? color_on : color_off;
		col[4] = pat & 0x08 ? color_on : color_off;
		col[5] = pat & 0x10 ? color_on : color_off;
		col[6] = pat & 0x20 ? color_on : color_off;
		col[7] = pat & 0x40 ? color_on : color_off;
		col[8] = pat & 0x80 ? color_on : color_off;
		for(int y = 0; y < LED_SIZE_Y; y++) {
			scrntype_t* dest = emu->get_screen_buffer(vm_ranges[i].y + y) + vm_ranges[i].x;
			for(int x = 0; x < LED_SIZE_X; x++) {
				dest[x] = col[led_pattern[y][x]];
			}
		}
	}
}

#define STATE_VERSION	1

#include "../../statesub.h"

void DISPLAY::decl_state()
{
	enter_decl_state(STATE_VERSION);

#if defined(_TK80BS)
	DECL_STATE_ENTRY_INT32(mode);
#endif
	DECL_STATE_ENTRY_BOOL(dma);
	
	leave_decl_state();
}

void DISPLAY::save_state(FILEIO* state_fio)
{
	if(state_entry != NULL) {
		state_entry->save_state(state_fio);
	}
//	state_fio->FputUint32(STATE_VERSION);
//	state_fio->FputInt32(this_device_id);
//	
//#if defined(_TK80BS)
//	state_fio->FputInt32(mode);
//#endif
//	state_fio->FputBool(dma);
}

bool DISPLAY::load_state(FILEIO* state_fio)
{
	bool mb = false;
	if(state_entry != NULL) {
		mb = state_entry->load_state(state_fio);
	}
	if(!mb) {
		return false;
	}
//	if(state_fio->FgetUint32() != STATE_VERSION) {
//		return false;
//	}
//	if(state_fio->FgetInt32() != this_device_id) {
//		return false;
//	}
//#if defined(_TK80BS)
//	mode = state_fio->FgetInt32();
//#endif
//	dma = state_fio->FgetBool();
	return true;
}

