/*
	SHARP MZ-5500 Emulator 'EmuZ-5500'

	Author : Takeda.Toshiya
	Date   : 2008.04.10 -

	[ system port ]
*/

#ifndef _SYSPORT_H_
#define _SYSPORT_H_

#include "../vm.h"
#include "../../emu.h"
#include "../device.h"

namespace MZ5500 {

class SYSPORT : public DEVICE
{
private:
	DEVICE *d_fdc, *d_ctc, *d_sio;
	int rst, highden;
	
public:
	SYSPORT(VM_TEMPLATE* parent_vm, EMU_TEMPLATE* parent_emu) : DEVICE(parent_vm, parent_emu)
	{
		set_device_name(_T("System I/O"));
	}
	~SYSPORT() {}
	
	// common functions
	void initialize();
	void __FASTCALL write_io8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_io8(uint32_t addr);
	void event_frame();
	bool process_state(FILEIO* state_fio, bool loading);
	
	// unique functions
	void set_context_fdc(DEVICE* device)
	{
		d_fdc = device;
	}
	void set_context_ctc(DEVICE* device)
	{
		d_ctc = device;
	}
	void set_context_sio(DEVICE* device)
	{
		d_sio = device;
	}
	void nmi_reset()
	{
		rst = 20;
	}
};

}
#endif

