/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.db.loader.impl;

import egeyama.bt.db.config.ImportConfig;
import egeyama.bt.db.config.MappingConfig;
import egeyama.bt.db.config.TableConfig;
import egeyama.bt.db.loader.Loader;
import egeyama.bt.db.model.Column;
import egeyama.bt.db.model.Table;
import egeyama.commons.io.FixedLengthInputStream;
import egeyama.commons.util.NullSafeUtils;
import egeyama.commons.xml.sax.helpers.EasySaxHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlvLoader
implements Loader {
    private static final Log LOGGER = LogFactory.getLog(FlvLoader.class);
    static final String NOT_CONFIG_MESSAGE = "You must specify a config file when using the -conf argument";
    static final String UNSET_CONFIG_MESSAGE = "-conf\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    static final String TABLE_NOT_FOUND = "\u30c6\u30fc\u30d6\u30eb[{0}]\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u30a4\u30f3\u30dd\u30fc\u30c8\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private static final String IMPORT_FAILED = "IMPORT FAILED";
    private String errorMessage;
    private String configFile;
    private ImportConfig importConfig;
    private List<MappingConfig> mappingConfigList = new ArrayList<MappingConfig>();
    private final SAXParserFactory factory = SAXParserFactory.newInstance();

    public static void main(String[] args) {
        try {
            FlvLoader idb = new FlvLoader();
            if (idb.parseArgs(args)) {
                System.out.println(idb.execute());
                String err = idb.getErrorMessage();
                if (err != null && err.length() > 0) {
                    System.err.println(idb.getErrorMessage());
                }
            } else {
                System.err.println(idb.getErrorMessage());
                System.out.println(IMPORT_FAILED);
            }
        }
        catch (Exception e) {
            StackTraceElement[] stackTraces;
            System.err.println(e);
            for (StackTraceElement ste : stackTraces = e.getStackTrace()) {
                System.err.println(ste);
            }
            System.out.println(IMPORT_FAILED);
        }
    }

    private ImportConfig parseImportConfig() throws Exception {
        SAXParser parser = this.factory.newSAXParser();
        ImportConfigHandler configHandler = new ImportConfigHandler();
        LOGGER.debug((Object)("configFile : [" + this.configFile + "]"));
        parser.parse(this.configFile, (DefaultHandler)((Object)configHandler));
        LOGGER.info((Object)"configFile parse end");
        return configHandler.getConfig();
    }

    @Override
    public boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!"-conf".equals(args[i])) continue;
            if (i == args.length - 1) {
                this.errorMessage = NOT_CONFIG_MESSAGE;
                return false;
            }
            this.configFile = args[i + 1];
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute() {
        if (this.configFile == null || this.configFile.length() < 1) {
            this.errorMessage = UNSET_CONFIG_MESSAGE;
            return IMPORT_FAILED;
        }
        String result = null;
        Connection conn = null;
        File file = new File(this.configFile);
        try {
            if (!file.exists()) throw new FileNotFoundException(this.configFile);
            this.importConfig = this.parseImportConfig();
            Class.forName(this.importConfig.getDriverClassName());
            conn = DriverManager.getConnection(this.importConfig.getUrl(), this.importConfig.getUser(), this.importConfig.getPassword());
            this.readMappingFiles();
            Iterator<MappingConfig> i$ = this.mappingConfigList.iterator();
            block6: while (true) {
                if (!i$.hasNext()) {
                    result = "IMPORT SUCCESSFUL";
                    NullSafeUtils.close((Connection)conn);
                    return result;
                }
                MappingConfig mappingConfig = i$.next();
                LOGGER.debug((Object)"processing mappging config ...");
                Iterator<TableConfig> i$2 = mappingConfig.getTableConfigList().iterator();
                while (true) {
                    if (!i$2.hasNext()) continue block6;
                    TableConfig tableConfig = i$2.next();
                    Table table = new Table(conn);
                    table.setName(tableConfig.getTableName());
                    table.setColumnList(tableConfig.getColumnList());
                    if (tableConfig.isCreate()) {
                        if (table.exists()) {
                            if (!tableConfig.isForce()) continue;
                            table.drop();
                        }
                        table.create();
                    }
                    if (table.exists()) {
                        this.importFile(table, tableConfig);
                        continue;
                    }
                    MessageFormat mf = new MessageFormat(TABLE_NOT_FOUND);
                    LOGGER.error((Object)mf.format(new String[]{tableConfig.getTableName()}));
                }
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
            catch (Exception e2) {
                this.errorMessage = e2.getClass().getSimpleName() + " : " + e2.getMessage();
                result = IMPORT_FAILED;
                return result;
            }
        }
        finally {
            NullSafeUtils.close(conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFile(Table table, TableConfig tableConfig) throws IOException, Table.TableException {
        String srcPath = tableConfig.getSourceDir();
        if (StringUtils.isEmpty((String)srcPath)) return;
        int recSize = tableConfig.getRecordSize();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setCaseSensitive(false);
        String baseDir = tableConfig.getBaseDir();
        if (StringUtils.isEmpty((String)baseDir)) {
            ds.setBasedir(".");
        } else {
            ds.setBasedir(baseDir);
        }
        ds.setIncludes(new String[]{srcPath});
        ds.scan();
        String[] importFiles = ds.getIncludedFiles();
        if (ds.getIncludedFilesCount() < 1) {
            LOGGER.error((Object)("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea[" + srcPath + "]\u306e\u30a2\u30af\u30bb\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
            return;
        }
        String[] arr$ = importFiles;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String filePath = arr$[i$];
            File file = new File(ds.getBasedir() + File.separator + filePath);
            if (!file.isDirectory()) {
                FixedLengthInputStream in = null;
                try {
                    in = new FixedLengthInputStream((InputStream)new FileInputStream(file));
                    String rec = null;
                    if (recSize > 0) {
                        while ((rec = in.readLine(recSize)) != null) {
                            table.insert(rec);
                        }
                    }
                    LOGGER.info((Object)(file.getCanonicalPath() + " import success."));
                }
                catch (IOException e) {
                    try {
                        LOGGER.error((Object)(file.getCanonicalPath() + " read failed."));
                        throw e;
                        catch (Table.TableException e2) {
                            LOGGER.error((Object)(file.getCanonicalPath() + " import failed."));
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        NullSafeUtils.close(in);
                        throw throwable;
                    }
                }
                NullSafeUtils.close((InputStream)in);
            }
            ++i$;
        }
    }

    private void readMappingFiles() throws Exception {
        File[] files;
        LOGGER.debug((Object)"Read MappingFiles start");
        File dir = new File(this.importConfig.getMappingFileDir());
        for (File f : files = dir.listFiles(new MappingFileFilter(this.importConfig.getMappingFileExt()))) {
            this.mappingConfigList.add(this.parseMappingConfig(f));
        }
        LOGGER.info((Object)"Read MappingFiles end");
    }

    private MappingConfig parseMappingConfig(File f) throws Exception {
        SAXParser parser = this.factory.newSAXParser();
        MappingConfigHandler mappingHandler = new MappingConfigHandler();
        parser.parse(f, (DefaultHandler)((Object)mappingHandler));
        LOGGER.debug((Object)("Parse MappingConfig end : " + f.getPath()));
        return mappingHandler.getMappingConfig();
    }

    private static class MappingFileFilter
    implements FilenameFilter {
        private String acceptExt = "";

        public MappingFileFilter(String ext) {
            if (ext != null) {
                this.acceptExt = ext;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            String[] names = name.split("\\.");
            return this.acceptExt.equals(names[names.length - 1]);
        }
    }

    private static class ImportConfigHandler
    extends EasySaxHandler {
        private static final String ELEMENT_DRIVER_CONFIG = "driver-config";
        private static final String ELEMENT_DRIVER_CLASS = "driverClassName";
        private static final String ELEMENT_URL = "url";
        private static final String ELEMENT_USER = "user";
        private static final String ELEMENT_PASSWORD = "password";
        private static final String ELEMENT_MAPPING_FILES = "mapping-files";
        private static final int STAGE_NOT_YET = 0;
        private static final int STAGE_DRIVER_SETTING = 1;
        private ImportConfig config = new ImportConfig();
        private String currentElement;
        private int processStage;

        private ImportConfigHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentElement = qName;
            if (ELEMENT_DRIVER_CONFIG.equals(this.currentElement)) {
                this.processStage = 1;
            } else if (ELEMENT_MAPPING_FILES.equals(this.currentElement)) {
                this.config.setMappingFileDir(attributes.getValue("dir"));
                this.config.setMappingFileExt(attributes.getValue("ext"));
            }
        }

        protected void textNode(String text) {
            text = text.replaceFirst("^\\s+", "");
            if ((text = text.replaceFirst("\\s+$", "")).length() < 1) {
                return;
            }
            if (this.processStage == 1) {
                if (ELEMENT_DRIVER_CLASS.equals(this.currentElement)) {
                    this.config.setDriverClassName(text);
                } else if (ELEMENT_URL.equals(this.currentElement)) {
                    this.config.setUrl(text);
                } else if (ELEMENT_USER.equals(this.currentElement)) {
                    this.config.setUser(text);
                } else if (ELEMENT_PASSWORD.equals(this.currentElement)) {
                    this.config.setPassword(text);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ELEMENT_DRIVER_CONFIG.equals(qName)) {
                this.processStage = 0;
            }
            this.currentElement = null;
        }

        public ImportConfig getConfig() {
            return this.config;
        }
    }

    private static class MappingConfigHandler
    extends EasySaxHandler {
        private static final String ELEMENT_TABLE = "table";
        private static final String ELEMENT_COLUMN = "column";
        private static final int STAGE_NOT_YET = 0;
        private static final int STAGE_TABLE = 1;
        private String currentElement;
        private MappingConfig mappingConfig = new MappingConfig();
        private int processStage;
        private TableConfig tableConfig;

        private MappingConfigHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentElement = qName;
            if (ELEMENT_TABLE.equals(this.currentElement)) {
                this.processStage = 1;
                this.tableConfig = new TableConfig();
                this.tableConfig.setTableName(attributes.getValue("name"));
                boolean create = Boolean.valueOf(attributes.getValue("create"));
                this.tableConfig.setCreate(create);
                this.tableConfig.setForce(Boolean.valueOf(attributes.getValue("force")));
                this.tableConfig.setBaseDir(attributes.getValue("baseDir"));
                this.tableConfig.setSourceDir(attributes.getValue("src"));
                this.tableConfig.setRecordSize(NumberUtils.toInt((String)attributes.getValue("recordSize"), (int)0));
                this.mappingConfig.addTableConfig(this.tableConfig);
            } else if (ELEMENT_COLUMN.equals(this.currentElement) && this.processStage == 1) {
                String size = attributes.getValue("size");
                Column column = new Column(attributes.getValue("name"), attributes.getValue("type"), Integer.valueOf(size), attributes.getValue("pattern"));
                column.setByteLength(Boolean.valueOf(attributes.getValue("byteLength")));
                this.tableConfig.addColumn(column);
            }
        }

        protected void textNode(String text) {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ELEMENT_TABLE.equals(qName)) {
                this.processStage = 0;
                this.tableConfig = null;
            }
            this.currentElement = null;
        }

        public MappingConfig getMappingConfig() {
            return this.mappingConfig;
        }
    }
}

