/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.db.loader.impl;

import egeyama.bt.db.config.ImportConfig;
import egeyama.bt.db.config.MappingConfig;
import egeyama.bt.db.config.TableConfig;
import egeyama.bt.db.loader.Loader;
import egeyama.bt.db.model.Column;
import egeyama.bt.db.model.Table;
import egeyama.commons.io.FixedLengthInputStream;
import egeyama.commons.util.NullSafeUtils;
import egeyama.commons.util.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FlvLoader
implements Loader {
    private static final Log LOGGER = LogFactory.getLog(FlvLoader.class);
    static final String NOT_CONFIG_MESSAGE = "You must specify a config file when using the -conf argument";
    static final String UNSET_CONFIG_MESSAGE = "-conf\u30aa\u30d7\u30b7\u30e7\u30f3\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    static final String TABLE_NOT_FOUND = "\u30c6\u30fc\u30d6\u30eb[{0}]\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u30a4\u30f3\u30dd\u30fc\u30c8\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    static final String MAPPING_FILE_NOT_FOUND = "\u30de\u30c3\u30d4\u30f3\u30b0\u30d5\u30a1\u30a4\u30eb\u304c\u4e00\u3064\u3082\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
    static final String MAPPING_FILE_DIR_NOT_FOUND = "\u30de\u30c3\u30d4\u30f3\u30b0\u30d5\u30a1\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
    private String errorMessage;
    private String configFile;
    private ImportConfig importConfig;
    private List<MappingConfig> mappingConfigList = new ArrayList<MappingConfig>();
    private String resultStatus;
    private final List<String> successList = new ArrayList<String>();
    private final List<String> failureList = new ArrayList<String>();
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    private synchronized ImportConfig parseImportConfig() throws Exception {
        LOGGER.info((Object)("\u30a4\u30f3\u30dd\u30fc\u30c8\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + this.configFile + "]\u306e\u30ed\u30fc\u30c9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002"));
        ImportConfig config = new ImportConfig();
        Document doc = this.documentBuilder.parse(new InputSource(this.configFile));
        String driverClassName = XPATH.evaluate("import-config/driver-config/driverClassName", doc);
        config.setDriverClassName(StringHelper.trim((String)driverClassName));
        String url = XPATH.evaluate("import-config/driver-config/url", doc);
        config.setUrl(StringHelper.trim((String)url));
        String user = XPATH.evaluate("import-config/driver-config/user", doc);
        config.setUser(StringHelper.trim((String)user));
        String password = XPATH.evaluate("import-config/driver-config/password", doc);
        config.setPassword(StringHelper.trim((String)password));
        String mappingFileDir = XPATH.evaluate("import-config/mapping-files/@dir", doc);
        config.setMappingFileDir(StringHelper.trim((String)mappingFileDir));
        String mappingFileExt = XPATH.evaluate("import-config/mapping-files/@ext", doc);
        config.setMappingFileExt(StringHelper.trim((String)mappingFileExt));
        LOGGER.info((Object)("\u30a4\u30f3\u30dd\u30fc\u30c8\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + this.configFile + "]\u306e\u30ed\u30fc\u30c9\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002"));
        return config;
    }

    @Override
    public boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!"-conf".equals(args[i])) continue;
            if (i == args.length - 1) {
                this.errorMessage = NOT_CONFIG_MESSAGE;
                return false;
            }
            this.configFile = args[i + 1];
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        Connection conn;
        boolean result;
        block11: {
            if (this.configFile == null || this.configFile.length() < 1) {
                this.errorMessage = UNSET_CONFIG_MESSAGE;
                this.resultStatus = "IMPORT FAILED";
                return false;
            }
            result = false;
            conn = null;
            File file = new File(this.configFile);
            if (!file.exists()) throw new FileNotFoundException(this.configFile);
            this.importConfig = this.parseImportConfig();
            Class.forName(this.importConfig.getDriverClassName());
            conn = DriverManager.getConnection(this.importConfig.getUrl(), this.importConfig.getUser(), this.importConfig.getPassword());
            if (this.readMappingFiles()) break block11;
            this.resultStatus = "IMPORT FAILED";
            boolean bl = false;
            NullSafeUtils.close((Connection)conn);
            return bl;
        }
        try {
            for (MappingConfig mappingConfig : this.mappingConfigList) {
                LOGGER.debug((Object)"processing mappging config ...");
                for (TableConfig tableConfig : mappingConfig.getTableConfigList()) {
                    Table table = new Table(conn);
                    table.setName(tableConfig.getTableName());
                    table.setColumnList(tableConfig.getColumnList());
                    if (tableConfig.isCreate()) {
                        if (table.exists()) {
                            if (!tableConfig.isForce()) continue;
                            table.drop();
                        }
                        table.create();
                    }
                    if (table.exists()) {
                        this.importFile(table, tableConfig);
                        continue;
                    }
                    MessageFormat mf = new MessageFormat(TABLE_NOT_FOUND);
                    LOGGER.error((Object)mf.format(new String[]{tableConfig.getTableName()}));
                }
            }
            this.resultStatus = "IMPORT SUCCESSFUL";
            result = true;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"\u4f8b\u5916\u304c\u30b9\u30ed\u30fc\u3055\u308c\u307e\u3057\u305f\u3002", (Throwable)e);
                this.errorMessage = e.getClass().getSimpleName() + " : " + e.getMessage();
                this.resultStatus = "IMPORT FAILED";
                result = false;
            }
            catch (Throwable throwable) {
                NullSafeUtils.close(conn);
                throw throwable;
            }
            NullSafeUtils.close((Connection)conn);
            return result;
        }
        NullSafeUtils.close((Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFile(Table table, TableConfig tableConfig) throws IOException, Table.TableException {
        String srcPath = tableConfig.getSourceDir();
        if (StringUtils.isEmpty((String)srcPath)) return;
        int recSize = tableConfig.getRecordSize();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setCaseSensitive(false);
        String baseDir = tableConfig.getBaseDir();
        if (StringUtils.isEmpty((String)baseDir)) {
            ds.setBasedir(".");
        } else {
            ds.setBasedir(baseDir);
        }
        ds.setIncludes(new String[]{srcPath});
        ds.scan();
        String[] importFiles = ds.getIncludedFiles();
        if (ds.getIncludedFilesCount() < 1) {
            LOGGER.error((Object)("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea[" + srcPath + "]\u306e\u30a2\u30af\u30bb\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
            return;
        }
        String[] arr$ = importFiles;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String filePath = arr$[i$];
            File file = new File(ds.getBasedir() + File.separator + filePath);
            if (!file.isDirectory()) {
                String canonicalPath = file.getCanonicalPath();
                FixedLengthInputStream in = null;
                try {
                    in = new FixedLengthInputStream((InputStream)new FileInputStream(file));
                    String rec = null;
                    if (recSize > 0) {
                        while ((rec = in.readLine(recSize)) != null) {
                            table.insert(rec);
                        }
                    }
                    this.successList.add(canonicalPath);
                    LOGGER.info((Object)(canonicalPath + " \u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f\u3002"));
                }
                catch (IOException e) {
                    try {
                        LOGGER.error((Object)(canonicalPath + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
                        throw e;
                        catch (Table.TableException e2) {
                            LOGGER.error((Object)(canonicalPath + " \u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"));
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        NullSafeUtils.close(in);
                        throw throwable;
                    }
                }
                NullSafeUtils.close((InputStream)in);
            }
            ++i$;
        }
    }

    private boolean readMappingFiles() throws Exception {
        File[] files;
        LOGGER.info((Object)"\u30de\u30c3\u30d4\u30f3\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        File dir = new File(this.importConfig.getMappingFileDir());
        if (!dir.exists() || !dir.isDirectory()) {
            this.errorMessage = MAPPING_FILE_DIR_NOT_FOUND;
            return false;
        }
        for (File f : files = dir.listFiles(new MappingFileFilter(this.importConfig.getMappingFileExt()))) {
            this.mappingConfigList.add(this.parseMappingConfig(f));
        }
        LOGGER.info((Object)"\u30de\u30c3\u30d4\u30f3\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
        if (files.length == 0) {
            this.errorMessage = MAPPING_FILE_NOT_FOUND;
            return false;
        }
        return true;
    }

    private synchronized MappingConfig parseMappingConfig(File f) throws Exception {
        LOGGER.info((Object)("\u30de\u30c3\u30d4\u30f3\u30b0\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + f + "]\u306e\u30ed\u30fc\u30c9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002"));
        Document doc = this.documentBuilder.parse(f);
        XPathExpression nameExpre = XPATH.compile("./@name");
        XPathExpression createExpre = XPATH.compile("./@create");
        XPathExpression forceExpre = XPATH.compile("./@force");
        XPathExpression baseDirExpre = XPATH.compile("./@baseDir");
        XPathExpression srcExpre = XPATH.compile("./@src");
        XPathExpression recSizeExpre = XPATH.compile("./@recordSize");
        XPathExpression columnExpre = XPATH.compile("./column");
        XPathExpression typeExpre = XPATH.compile("./@type");
        XPathExpression sizeExpre = XPATH.compile("./@size");
        XPathExpression patternExpre = XPATH.compile("./@pattern");
        XPathExpression byteLengthExpre = XPATH.compile("./@byteLength");
        MappingConfig mappingConfig = new MappingConfig();
        NodeList tableNodes = (NodeList)XPATH.evaluate("mapping-config/table", doc, XPathConstants.NODESET);
        for (int i = 0; i < tableNodes.getLength(); ++i) {
            TableConfig tableConfig = new TableConfig();
            Node tableNode = tableNodes.item(i);
            tableConfig.setTableName(nameExpre.evaluate(tableNode));
            tableConfig.setCreate(Boolean.valueOf(createExpre.evaluate(tableNode)));
            tableConfig.setForce(Boolean.valueOf(forceExpre.evaluate(tableNode)));
            tableConfig.setBaseDir(baseDirExpre.evaluate(tableNode));
            tableConfig.setSourceDir(srcExpre.evaluate(tableNode));
            tableConfig.setRecordSize(((Number)recSizeExpre.evaluate(tableNode, XPathConstants.NUMBER)).intValue());
            NodeList columnNodes = (NodeList)columnExpre.evaluate(tableNode, XPathConstants.NODESET);
            for (int j = 0; j < columnNodes.getLength(); ++j) {
                Node columnNode = columnNodes.item(j);
                Column col = new Column(nameExpre.evaluate(columnNode), typeExpre.evaluate(columnNode), ((Number)sizeExpre.evaluate(columnNode, XPathConstants.NUMBER)).intValue());
                col.setPattern(patternExpre.evaluate(columnNode));
                col.setByteLength(Boolean.valueOf(byteLengthExpre.evaluate(columnNode)));
                tableConfig.addColumn(col);
            }
            mappingConfig.addTableConfig(tableConfig);
        }
        LOGGER.info((Object)("\u30de\u30c3\u30d4\u30f3\u30b0\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb[" + f + "]\u306e\u30ed\u30fc\u30c9\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002"));
        return mappingConfig;
    }

    @Override
    public String getResultStatus() {
        return this.resultStatus;
    }

    @Override
    public List<String> getSuccessFiles() {
        return this.successList;
    }

    @Override
    public List<String> getFailureFiles() {
        return this.failureList;
    }

    private static class MappingFileFilter
    implements FilenameFilter {
        private String acceptExt = "";

        public MappingFileFilter(String ext) {
            if (ext != null) {
                this.acceptExt = ext;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            String[] names = name.split("\\.");
            return this.acceptExt.equals(names[names.length - 1]);
        }
    }
}

