/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.db.model;

import org.apache.commons.lang.StringUtils;

public class Column {
    private static final String MSG_PATTERN_NOTSET = "\u65e5\u4ed8\u30d1\u30bf\u30fc\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
    public static final String IGNORE = "ignore";
    public static final String DATE = "date";
    private String name;
    private String type;
    private String pattern;
    private int size;
    private boolean byteLength;

    public Column(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Column(String name, String type, int size) {
        this(name, type);
        this.size = size;
    }

    public Column(String name, String type, String pattern) {
        this(name, type);
        this.setPattern(pattern);
    }

    public Column(String name, String type, int size, String pattern) {
        this(name, type, size);
        this.setPattern(pattern);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getSize() {
        return this.size;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        if (DATE.equalsIgnoreCase(this.type) && StringUtils.isEmpty((String)pattern)) {
            throw new IllegalArgumentException(MSG_PATTERN_NOTSET);
        }
    }

    public boolean isByteLength() {
        return this.byteLength;
    }

    public void setByteLength(boolean byteLength) {
        this.byteLength = byteLength;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

