/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.db.model;

import egeyama.bt.db.model.Column;
import egeyama.commons.util.NullSafeUtils;
import egeyama.commons.util.StringHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Table {
    private static final String MSG_DATA_CONVERT_FAILD;
    private static final Log LOGGER;
    private Connection connection;
    private String name;
    private List<Column> columns = new ArrayList<Column>();

    public Table(Connection conn) {
        this.connection = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws SQLException, TableException {
        this.validTableName();
        if (this.columns == null || this.columns.isEmpty()) {
            throw new TableException("\u30ab\u30e9\u30e0\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
        }
        Statement stat = null;
        try {
            stat = this.connection.createStatement();
            StringBuilder sql = new StringBuilder("CREATE TABLE ");
            sql.append(this.name).append("(");
            int idx = 0;
            for (Column c : this.columns) {
                if ("ignore".equalsIgnoreCase(c.getType())) continue;
                if (idx != 0) {
                    sql.append(", ");
                }
                sql.append(c.getName()).append(" ").append(c.getType());
                ++idx;
            }
            sql.append(")");
            LOGGER.info((Object)("SQL : " + sql));
            stat.execute(sql.toString());
        }
        finally {
            NullSafeUtils.close((Statement)stat);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws TableException {
        boolean exits;
        block5: {
            exits = true;
            this.validTableName();
            PreparedStatement pstat = null;
            ResultSet rs = null;
            try {
                String sql = "SELECT 1 FROM " + this.name;
                LOGGER.info((Object)("SQL : " + sql));
                pstat = this.connection.prepareStatement(sql);
                rs = pstat.executeQuery();
                NullSafeUtils.close((ResultSet)rs);
            }
            catch (SQLException e) {
                LOGGER.info((Object)e.getMessage());
                exits = false;
                break block5;
            }
            finally {
                NullSafeUtils.close(rs);
                NullSafeUtils.close(pstat);
            }
            NullSafeUtils.close((Statement)pstat);
        }
        return exits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() throws TableException, SQLException {
        this.validTableName();
        Statement stat = null;
        try {
            stat = this.connection.createStatement();
            String sql = "DROP TABLE " + this.name;
            LOGGER.info((Object)("SQL : " + sql));
            stat.execute(sql);
        }
        finally {
            NullSafeUtils.close((Statement)stat);
        }
    }

    private void validTableName() throws TableException {
        if (this.name == null || this.name.length() == 0) {
            throw new TableException("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u672a\u8a2d\u5b9a\u3067\u3059\u3002");
        }
    }

    public void addColumn(Column col) {
        this.columns.add(col);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumnList(List<Column> cols) {
        this.columns = cols;
    }

    public void insert(Object[] values) throws TableException {
        this.validTableName();
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(this.name).append("(");
        ArrayList<Column> insertColumns = new ArrayList<Column>();
        ArrayList<Object> insertValues = new ArrayList<Object>();
        int insIdx = 0;
        for (int cIdx = 0; cIdx < this.columns.size() && cIdx < values.length; ++cIdx) {
            Column column = this.columns.get(cIdx);
            if ("ignore".equalsIgnoreCase(column.getType())) continue;
            if (insIdx == 0) {
                sql.append(column.getName());
            } else {
                sql.append(", ").append(column.getName());
            }
            insertColumns.add(column);
            insertValues.add(values[cIdx]);
            ++insIdx;
        }
        sql.append(") values(");
        int insertColCnt = insertColumns.size();
        for (int i = 0; i < insertColCnt; ++i) {
            if (i == 0) {
                sql.append("?");
                continue;
            }
            sql.append(", ?");
        }
        sql.append(")");
        PreparedStatement pstat = null;
        ArrayList<Object> valueList = new ArrayList<Object>();
        try {
            pstat = this.connection.prepareStatement(sql.toString());
            int aIdx = 0;
            int pIdx = 1;
            while (aIdx < insertColCnt) {
                Object convertValue = this.convert(insertValues.get(aIdx), (Column)insertColumns.get(aIdx));
                if (LOGGER.isDebugEnabled()) {
                    valueList.add(convertValue);
                }
                pstat.setObject(pIdx, convertValue);
                ++aIdx;
                ++pIdx;
            }
            pstat.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("SQL : " + sql));
                StringBuilder sb = new StringBuilder("values : ");
                if (LOGGER.isDebugEnabled()) {
                    for (Object e2 : valueList) {
                        sb.append("[").append(e2).append("]");
                    }
                }
                LOGGER.debug((Object)sb);
                throw new TableException(e);
            }
            catch (Throwable throwable) {
                NullSafeUtils.close(pstat);
                throw throwable;
            }
        }
        NullSafeUtils.close((Statement)pstat);
    }

    private Object convert(Object srcValue, Column column) throws TableException {
        Object result = srcValue;
        if (srcValue instanceof String) {
            String strValue = (String)srcValue;
            if ("date".equalsIgnoreCase(column.getType())) {
                SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                sdf.setLenient(false);
                sdf.applyPattern(column.getPattern());
                try {
                    Date utilDate = sdf.parse(strValue);
                    result = new java.sql.Date(utilDate.getTime());
                }
                catch (ParseException e) {
                    String message = new MessageFormat(MSG_DATA_CONVERT_FAILD).format(new String[]{this.name, column.getName(), strValue, column.getPattern()});
                    throw new TableException(message, e);
                }
            }
        }
        return result;
    }

    public void insert(String fixedString) throws TableException {
        LOGGER.debug((Object)("Insert String: " + fixedString));
        StringBuilder sb = new StringBuilder(fixedString);
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; sb.length() > 0 && i < this.columns.size(); ++i) {
            String carveString;
            Column col = this.columns.get(i);
            if (col.isByteLength()) {
                carveString = StringHelper.carveBytes((StringBuilder)sb, (int)col.getSize());
                values.add(carveString);
                continue;
            }
            carveString = StringHelper.carve((StringBuilder)sb, (int)col.getSize());
            values.add(carveString);
        }
        this.insert(values.toArray());
    }

    static {
        LOGGER = LogFactory.getLog(Table.class);
        StringBuilder sb = new StringBuilder("\u30c7\u30fc\u30bf\u578b\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(table={0}, name={1}, value={2},pattern={3})");
        MSG_DATA_CONVERT_FAILD = sb.toString();
    }

    public static final class TableException
    extends Exception {
        public TableException(String message) {
            super(message);
        }

        public TableException(Throwable cause) {
            super(cause);
        }

        public TableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

