/*
 * Decompiled with CFR 0.152.
 */
package egeyama.bt.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import egeyama.bt.doclet.AttributeElement;
import egeyama.bt.doclet.TagElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TaglibDoclet {
    private Map<String, TagElement> tagMap = new HashMap<String, TagElement>();
    private static TaglibDoclet instance;
    private static String destdir;

    public static boolean start(RootDoc root) {
        String[][] options = root.options();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i][0].equals("-destdir")) continue;
            destdir = options[i][1];
        }
        TaglibDoclet.getInstance();
        instance.parseClass(root);
        if (TaglibDoclet.instance.tagMap.isEmpty()) {
            return false;
        }
        try {
            instance.createXml();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-destdir")) {
            return 2;
        }
        return 0;
    }

    protected void createXml() throws IOException, ParserConfigurationException, TransformerException {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        Iterator<TagElement> tagIter = this.tagMap.values().iterator();
        while (tagIter.hasNext()) {
            Element rootElem = new Element("tag");
            TagElement te = tagIter.next();
            Element nameElem = new Element("name");
            rootElem.addContent((Content)nameElem);
            String tagName = te.getName();
            nameElem.addContent((Content)new Text(tagName));
            Element tagClassElem = new Element("tag-class");
            rootElem.addContent((Content)tagClassElem);
            tagClassElem.addContent((Content)new Text(te.getTagclass()));
            Element bodyConentElem = new Element("body-content");
            rootElem.addContent((Content)bodyConentElem);
            bodyConentElem.addContent((Content)new Text(te.getBodycontent()));
            AttributeElement[] attributes = te.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Element attributeElem = new Element("attribute");
                rootElem.addContent((Content)attributeElem);
                Element attributeNameElem = new Element("name");
                attributeElem.addContent((Content)attributeNameElem);
                attributeNameElem.addContent((Content)new Text(attributes[i].getName()));
                Element requiredElem = new Element("required");
                attributeElem.addContent((Content)requiredElem);
                requiredElem.addContent((Content)new Text(attributes[i].getRequired()));
                Element rtexprvalueElem = new Element("rtexprvalue");
                attributeElem.addContent((Content)rtexprvalueElem);
                rtexprvalueElem.addContent((Content)new Text(attributes[i].getRtexprvalue()));
            }
            File outputFile = new File(destdir, tagName + ".xml");
            System.out.println(outputFile + " \u3092\u51fa\u529b\u3057\u3066\u3044\u307e\u3059...");
            out.output(rootElem, (OutputStream)new FileOutputStream(outputFile));
        }
    }

    public static TaglibDoclet getInstance() {
        if (instance == null) {
            instance = new TaglibDoclet();
        }
        return instance;
    }

    protected void parseClass(RootDoc root) {
        ClassDoc[] classes = root.classes();
        for (int i = 0; i < classes.length; ++i) {
            Tag[] tags = classes[i].tags();
            String className = classes[i].qualifiedTypeName();
            for (int j = 0; j < tags.length; ++j) {
                TagElement te;
                String docTagName = tags[j].name();
                String text = tags[j].text();
                if (docTagName.equals("@taglib-tag.name")) {
                    te = this.getTag(className);
                    te.setName(text);
                    continue;
                }
                if (!docTagName.equals("@taglib-tag.bodycontent")) continue;
                te = this.getTag(className);
                te.setBodycontent(text);
            }
            this.parseMethod(className, classes[i].methods());
        }
    }

    private void parseMethod(String className, MethodDoc[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Tag[] tags = methods[i].tags();
            AttributeElement attr = null;
            for (int j = 0; j < tags.length; ++j) {
                String name = tags[j].name();
                String text = tags[j].text();
                if (name.equals("@taglib-attribute.name")) {
                    if (attr == null) {
                        attr = new AttributeElement();
                    }
                    attr.setName(text);
                    continue;
                }
                if (name.equals("@taglib-attribute.required")) {
                    if (attr == null) {
                        attr = new AttributeElement();
                    }
                    attr.setRequired(text);
                    continue;
                }
                if (!name.equals("@taglib-attribute.rtexprvalue")) continue;
                if (attr == null) {
                    attr = new AttributeElement();
                }
                attr.setRtexprvalue(text);
            }
            if (attr == null) continue;
            TagElement te = this.getTag(className);
            te.addAttribute(attr);
        }
    }

    private TagElement getTag(String name) {
        TagElement result = this.tagMap.get(name);
        if (result == null) {
            result = new TagElement();
            result.setTagclass(name);
            this.tagMap.put(name, result);
        }
        return result;
    }

    protected static String getDestdir() {
        return destdir;
    }
}

