package jp.sourceforge.csvparser;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;

import junit.framework.Assert;


public class CSVTestUtils {

    public static Reader openReader(String s) {
    
        return new BufferedReader(new StringReader(s));
    }

    public static void assertEquals(String[] expected, String[] actual) {
    
        Assert.assertEquals(expected.length, actual.length);
    
        for (int i = 0; i < expected.length; i++) {
            Assert.assertEquals(String.valueOf(i), expected[i], actual[i]);
        }
    }

    public static void assertEquals(String[][] expected, String[][] actual) {
    
        Assert.assertEquals(expected.length, actual.length);
    
        for (int i = 0; i < expected.length; i++) {
            Assert.assertEquals(String.valueOf(i), expected[i].length,
                    actual[i].length);
    
            for (int j = 0; j < expected[i].length; j++) {
                Assert.assertEquals(String.valueOf(i) + "." + String.valueOf(j),
                        expected[i][j], actual[i][j]);
            }
        }
    }

}
