/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.csvparser;

import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.csvparser.BasicCSVParser;
import jp.sourceforge.csvparser.BasicCSVReader;
import jp.sourceforge.csvparser.BulkCSVHandler;
import jp.sourceforge.csvparser.CSVParser;
import jp.sourceforge.csvparser.CSVReader;
import jp.sourceforge.csvparser.CSVUtility;

public class BasicCSVUtility
implements CSVUtility {
    private CSVParser parser;

    public BasicCSVUtility() {
        this(new BasicCSVParser());
    }

    public BasicCSVUtility(CSVParser parser) {
        this.parser = parser;
    }

    public String[][] parse(Reader reader) throws IOException {
        BulkCSVHandler handler = this.createBulkCSVHandler();
        this.parser.parse(reader, handler);
        return handler.getRecords();
    }

    protected BulkCSVHandler createBulkCSVHandler() {
        return new BulkCSVHandler();
    }

    public CSVReader createCSVReader(Reader reader) {
        return new BasicCSVReader(reader, this.parser);
    }

    public CSVParser getParser() {
        return this.parser;
    }

    public void setParser(CSVParser parser) {
        this.parser = parser;
    }
}

