#include <stdio.h>
#include <string.h>
#include "ctlString.h"
#include "ctlError.h"

/* Internal prototype */
void initErrMSG(int force);


void initErrMSG(int force)
{
	static ctl_errmsg_init = 0;

	if((ctl_errmsg_init == 0) || (force == 1)) {
		strcpy(ctl_errmsg_main, "");
		strcpy(ctl_errmsg_tmp, "");
	}
	ctl_errmsg_init = 1;
}


void clearErrMSG()
{
	initErrMSG(1);
}


char *addErrMSG(char *file, char *func, int line, char *message)
{
	initErrMSG(0);
	snprintf(ctl_errmsg_tmp, CTL_ERROR_MESSAGE_MAX, CTL_ERROR_MESSAGE_FORMAT,
							file, func, line, message);
	strncat(ctl_errmsg_main, ctl_errmsg_tmp,
					CTL_ERROR_MESSAGE_MAX - strlen(ctl_errmsg_main));
	return ctl_errmsg_tmp;
}


char *strErrMSG(int num)
{
	int n, offset = 0;
	char line[CTL_ERROR_MESSAGE_MAX + 1];
	char tmp[CTL_ERROR_MESSAGE_MAX + 1];

	initErrMSG(0);
	if(num < 1) {
		return ctl_errmsg_main;
	}
	strcpy(ctl_errmsg_tmp, "");
	while((n = getLine(ctl_errmsg_main + offset, line, CTL_ERROR_MESSAGE_MAX)) > 0) {
		offset += n;
		strcpy(tmp, ctl_errmsg_tmp);
		snprintf(ctl_errmsg_tmp, CTL_ERROR_MESSAGE_MAX, "%s%s\n", tmp, line);
		if(--num == 0) {
			break;
		}
	}
	return ctl_errmsg_tmp;
}


