#ifndef __LIBCTLPARAMETER_H
#define __LIBCTLPARAMETER_H

#define PARAMETER_NAME_MAX	32
#define PARAMETER_VALUE_MAX	5120
#define PARAGRAM_NAME_MAX	32
#define DEFAULT_PARAGRAM_NAME	"default"
#define NO_PARAGRAM_PARAMETER	""
#define CONFIG_FILE_LINE_MAX	5200
#define PARAGRAM_REGEX_FORMAT	"^[a-zA-Z0-9_]+:$"
#define NORMAL_PARAMETER_REGEX_FORMAT	"^[ \t]*[[:alnum:]_]+[ \t]*="
#define PARAGRAM_PARAMETER_REGEX_FORMAT	"^[\t][ \t]*[[:alnum:]_]+[ \t]*="
#define NORMAL_PARAMETER	0
#define NO_ENV_PARAMETER	1
#define NO_GET_DEF_PARAGRAM	2
#define NO_EXTRACT_STRING	4
#define NO_DEL_COMMENT		8
#define NO_TRIMMING		16
#define NO_PROCESSING		32


enum lineAnalyseResult {
	PARAGRAM_LINE,
	NORMAL_PARAMETER_LINE,
	PARAGRAM_PARAMETER_LINE,
	NEWLINE_ONLY,
	IGNORE_LINE,
	ANALYSE_ERROR
};

/* for error handling */
enum ctlParamErrCode {
	ERR_ERRNO,
	ERR_NULL,
	ERR_CR_PARAG_LST,
	ERR_CONV_FILE_TO_CHAR_FAIL,
	ERR_READ_CONF_FAIL,
	ERR_GET_PARAM_NAME_FAIL,
	ERR_GET_PARAG_NAME_FAIL,
	ERR_GET_PARAM_VAL_FAIL,
	ERR_PARAG_ANALYSE_FAIL,
	ERR_PARAM_ANALYSE_FAIL,
	ERR_LINE_ANALYSE_FAIL,
	ERR_ADD_STRING_FAIL,
	ERR_GET_LINE_FAIL,
	ERR_CNT_PARAG_FAIL,
	ERR_GET_ENV_FAIL,
	ERR_RM_COMM_FAIL,
	ERR_TRIM_VAL_FAIL,
	ERR_TRUNC_STR_FAIL,
	ERR_TRIM_STR_FAIL,
	ERR_REGEX_FAIL,
	ERR_PUT_PARAG_FAIL,
	ERR_PUT_PARAM_FAIL,
	ERR_EXTRACT_PARAM_FAIL,
	ERR_GET_SUBSTR_FAIL,
	ERR_ADD_PARAG_FAIL,
	ERR_ADD_PARAM_FAIL,
	ERR_CR_PARAG_ATTR_FAIL,
	ERR_MOD_PARAM_FAIL,
	ERR_CR_PARAM_ATTR_FAIL,
	ERR_GET_PARAGRAM_LIST_FAIL,
	ERR_CONV_PARAGRAM_TO_CHAR_FAIL,
	ERR_FILE_OPEN_FAIL,
	ERR_CR_CFG_LIST_FAIL,
	ERR_CR_ABS_PATH_FAIL,
	ERR_PASTE_STRING_FAIL,
	ERR_SPLIT_STRING_FAIL
};

struct parameterAttribute {
	char *parameterName;
	char *parameterValue;
};

struct parameterList {
	struct parameterAttribute *paramAttr;
	struct parameterList *nextParam;
};

struct paragramAttribute {
	char *paragramName;
	struct parameterList *paramList;
};

struct paragramList {
	struct paragramAttribute *paragAttr;
	struct paragramList *nextParag;
};

struct configList {
	struct paragramList *paragList;
};


/* Prototypes */
struct configList *initConfigList();
void freeConfigList(struct configList *cfgList);
int readConfigFile(int fd, struct configList *cfgList);
int readConfigChar(char *config, struct configList *cfgList);
char **getParagramList(struct configList *cfgList);
void clearParagramList(char **paragList);
int countParagram(struct configList *cfgList);
int getParameterValue(char *result, char *paragName, char *paramName, int MODE, struct configList *cfgList);
int getnParameterValue(char *result, char *paragName, char *paramName, int MODE, ...);
void showParagram(struct paragramList *paragList, int mode);
void showParameter(struct parameterList *paramList);
char *convConfig2Char(struct configList *cfgList);
int readConfig(char *file_path, struct configList *cfgList);
int readfConfig(char *dir, char *name, char *suffix, struct configList *cfgList);
int readdConfig(char *argv0, char *aux_dir, char *name, char *suffix, struct configList *cfgList);
char **getSplitValues(char *value);
void freeSplitValues(char **valueList);


#endif /* __LIBCTLPARAMETER_H */

