/*
 * Decompiled with CFR 0.152.
 */
package analyzeccode;

import analyzeccode.AnalyzeCcodeAboutBox;
import analyzeccode.AnalyzeCcodeApp;
import java.awt.Canvas;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class AnalyzeCcodeView
extends FrameView {
    private Canvas canvas1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel noofalfiles;
    private JLabel noofalfuncs;
    private JProgressBar progressBar;
    private JLabel result;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public AnalyzeCcodeView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalyzeCcodeView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalyzeCcodeView.this.busyIconIndex = (AnalyzeCcodeView.this.busyIconIndex + 1) % AnalyzeCcodeView.this.busyIcons.length;
                AnalyzeCcodeView.this.statusAnimationLabel.setIcon(AnalyzeCcodeView.this.busyIcons[AnalyzeCcodeView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!AnalyzeCcodeView.this.busyIconTimer.isRunning()) {
                        AnalyzeCcodeView.this.statusAnimationLabel.setIcon(AnalyzeCcodeView.this.busyIcons[0]);
                        AnalyzeCcodeView.this.busyIconIndex = 0;
                        AnalyzeCcodeView.this.busyIconTimer.start();
                    }
                    AnalyzeCcodeView.this.progressBar.setVisible(true);
                    AnalyzeCcodeView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    AnalyzeCcodeView.this.busyIconTimer.stop();
                    AnalyzeCcodeView.this.statusAnimationLabel.setIcon(AnalyzeCcodeView.this.idleIcon);
                    AnalyzeCcodeView.this.progressBar.setVisible(false);
                    AnalyzeCcodeView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    AnalyzeCcodeView.this.statusMessageLabel.setText(text == null ? "" : text);
                    AnalyzeCcodeView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    AnalyzeCcodeView.this.progressBar.setVisible(true);
                    AnalyzeCcodeView.this.progressBar.setIndeterminate(false);
                    AnalyzeCcodeView.this.progressBar.setValue(value);
                }
            }
        });
        this.setDispProp(AnalyzeCcodeApp.getCmain().sizeFiledats(), AnalyzeCcodeApp.getCmain().sizeFuncList());
        this.mainPanel.setTransferHandler(new FileDrop(this));
    }

    public void setDispProp(String nooffiles, String nooffunc) {
        this.noofalfiles.setText(nooffiles);
        this.noofalfuncs.setText(nooffunc);
    }

    @Action
    public void initaction() {
        AnalyzeCcodeApp.getCmain().init();
        this.setDispProp(AnalyzeCcodeApp.getCmain().sizeFiledats(), AnalyzeCcodeApp.getCmain().sizeFuncList());
    }

    @Action
    public Task openaction() {
        return new LoadFileTask(this.getApplication(), this);
    }

    @Action
    public void stubaction() {
        AnalyzeCcodeApp.creErlfile();
        this.setDispProp(AnalyzeCcodeApp.getCmain().sizeFiledats(), AnalyzeCcodeApp.getCmain().sizeFuncList());
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = AnalyzeCcodeApp.getApplication().getMainFrame();
            this.aboutBox = new AnalyzeCcodeAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        AnalyzeCcodeApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.noofalfuncs = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.result = new JLabel();
        this.noofalfiles = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.canvas1 = new Canvas();
        this.mainPanel.setName("mainPanel");
        ApplicationActionMap actionMap = Application.getInstance(AnalyzeCcodeApp.class).getContext().getActionMap(AnalyzeCcodeView.class, this);
        this.jButton1.setAction(actionMap.get("openaction"));
        ResourceMap resourceMap = Application.getInstance(AnalyzeCcodeApp.class).getContext().getResourceMap(AnalyzeCcodeView.class);
        this.jButton1.setBackground(resourceMap.getColor("jButton1.background"));
        this.jButton1.setIcon(resourceMap.getIcon("jButton1.icon"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setToolTipText(resourceMap.getString("jButton1.toolTipText", new Object[0]));
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setName("jButton1");
        this.jButton1.setVerticalTextPosition(3);
        this.jButton2.setAction(actionMap.get("stubaction"));
        this.jButton2.setBackground(resourceMap.getColor("jButton2.background"));
        this.jButton2.setIcon(resourceMap.getIcon("jButton2.icon"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setName("jButton2");
        this.jButton2.setVerticalTextPosition(3);
        this.jSeparator1.setName("jSeparator1");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.noofalfuncs.setBackground(resourceMap.getColor("noofalfuncs.background"));
        this.noofalfuncs.setFont(resourceMap.getFont("noofalfuncs.font"));
        this.noofalfuncs.setHorizontalAlignment(4);
        this.noofalfuncs.setText(resourceMap.getString("noofalfuncs.text", new Object[0]));
        this.noofalfuncs.setName("noofalfuncs");
        this.jSeparator2.setName("jSeparator2");
        this.result.setText(resourceMap.getString("result.text", new Object[0]));
        this.result.setName("result");
        this.noofalfiles.setBackground(resourceMap.getColor("noofalfiles.background"));
        this.noofalfiles.setHorizontalAlignment(4);
        this.noofalfiles.setText(resourceMap.getString("noofalfiles.text", new Object[0]));
        this.noofalfiles.setName("noofalfiles");
        this.jButton3.setAction(actionMap.get("initaction"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setBackground(resourceMap.getColor("jLabel4.background"));
        this.jLabel4.setFont(resourceMap.getFont("jLabel4.font"));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jSeparator3.setName("jSeparator3");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3, -1, 481, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 481, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jButton1, -2, 153, -2).addGap(36, 36, 36).addComponent(this.jLabel4)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.result).addGap(18, 18, 18).addComponent(this.jButton2, -2, 154, -2))).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 481, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 107, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 107, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.noofalfuncs, -1, -1, Short.MAX_VALUE).addComponent(this.noofalfiles, -1, 61, Short.MAX_VALUE)).addGap(294, 294, 294)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel4)).addGroup(mainPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel3)).addGroup(mainPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 49, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.result, -2, 20, -2).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noofalfiles, -1, 13, Short.MAX_VALUE).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noofalfuncs, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1)).addGap(24, 24, 24)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 481, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 306, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.canvas1.setName("canvas1");
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private class FileDrop
    extends TransferHandler {
        private AnalyzeCcodeApp.LoadFilesTask datapp;
        private AnalyzeCcodeView view;

        public FileDrop(AnalyzeCcodeView view) {
            this.view = view;
        }

        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            support.setShowDropLocation(true);
            return true;
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Object obj = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                List files = (List)obj;
                ArrayList<File> outfile = new ArrayList<File>();
                for (File file : files) {
                    if (!file.isFile()) continue;
                    outfile.add(file);
                }
                File[] outfiles = files.toArray(new File[outfile.size()]);
                this.datapp = new AnalyzeCcodeApp.LoadFilesTask(AnalyzeCcodeView.this.getApplication(), this.view);
                this.datapp.setFiles(outfiles);
                this.datapp.execute();
                return true;
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private class LoadFileTask
    extends AnalyzeCcodeApp.LoadFilesTask {
        LoadFileTask(Application app, AnalyzeCcodeView view) {
            super(app, view);
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("\u5909\u63db\u3057\u305f\u3044\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u9078\u629e");
            fc.setFileSelectionMode(0);
            int option = fc.showOpenDialog(AnalyzeCcodeView.this.getFrame());
            if (0 == option) {
                File sfile = fc.getSelectedFile();
                super.setFiles(new File[]{sfile});
            }
        }

        protected void succeeded(String fileContents) {
        }

        protected void failed(Throwable cause) {
            super.failed(cause);
        }
    }
}

