/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import java.io.Serializable;
import java.util.Collection;

public class MyUtil {

    public static class ArrayObject
    implements Cloneable,
    Serializable {
        private static final RemovedInd REMOVED = new RemovedInd();
        private static final long serialVersionUID = 200708020300001L;
        private int size = 0;
        private int del = 0;
        private Object[] objectlist;
        private int cursor = 0;
        private int endCursor = -1;
        private int latest = -1;

        public ArrayObject() {
            this.objectlist = new Object[10];
        }

        public ArrayObject(Object[] objArray) {
            int asize = 10 + objArray.length / 10 * 10;
            this.objectlist = new Object[asize];
            System.arraycopy(objArray, 0, this.objectlist, 0, objArray.length);
            this.size = objArray.length;
        }

        public void addAll(ArrayObject values) {
            values.first();
            while (values.hasNext()) {
                this.addItem(values.next());
            }
        }

        public void addAllNotContain(ArrayObject values) {
            values.first();
            while (values.hasNext()) {
                Object obj = values.next();
                if (this.contains(obj)) continue;
                this.addItem(obj);
            }
        }

        public boolean addAll(Collection c) {
            for (Object o : c) {
                this.addItem(o);
            }
            return true;
        }

        public boolean add(Object o) {
            return this.addItem(o) >= 0;
        }

        public boolean remove(Object o) {
            int idx = this.indexOf(o);
            this.removeItem(idx);
            return idx >= 0;
        }

        public synchronized int addItem(Object value) {
            if (this.size > 0xFFFFFFF) {
                return -1;
            }
            int retval = this.size;
            this.objectlist[this.size++] = value;
            if (this.size == this.objectlist.length) {
                int inc = this.objectlist.length / 2 > 1000 ? 1000 : this.objectlist.length / 2;
                Object[] back = new Object[this.objectlist.length + inc];
                System.arraycopy(this.objectlist, 0, back, 0, this.objectlist.length);
                this.objectlist = back;
            }
            return retval;
        }

        public synchronized void add(int idx, Object value) {
            ++this.size;
            Object[] source = (Object[])this.objectlist.clone();
            if (this.size == this.objectlist.length) {
                this.objectlist = new Object[this.objectlist.length + 10];
            }
            System.arraycopy(source, 0, this.objectlist, 0, idx);
            this.objectlist[idx] = value;
            System.arraycopy(source, idx, this.objectlist, idx + 1, source.length - idx - 1);
        }

        public int size() {
            return this.size - this.del;
        }

        public synchronized void clear() {
            this.size = 0;
            this.del = 0;
            this.first();
        }

        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        public int indexOf(Object in) {
            for (int i = 0; i < this.size; ++i) {
                if (!(in != null ? this.objectlist[i] != null && this.objectlist[i].equals(in) : this.objectlist[i] == null)) continue;
                return i;
            }
            return -1;
        }

        public int indexOflast(Object in) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!(in != null ? this.objectlist[i] != null && this.objectlist[i].equals(in) : this.objectlist[i] == null)) continue;
                return i;
            }
            return -1;
        }

        public Object getValue(int index) {
            if (this.size <= index || index < 0) {
                return null;
            }
            if (this.objectlist[index] == null) {
                return null;
            }
            if (this.objectlist[index] instanceof RemovedInd) {
                return null;
            }
            return this.objectlist[index];
        }

        public boolean isRemoved(int idx) {
            if (this.size <= idx || idx < 0) {
                return true;
            }
            if (this.objectlist[idx] == null) {
                return false;
            }
            return this.objectlist[idx] instanceof RemovedInd;
        }

        public Object getLastValue() {
            for (int idx = this.size - 1; idx >= 0; --idx) {
                if (this.objectlist[idx] instanceof RemovedInd) continue;
                this.latest = idx;
                return this.objectlist[idx];
            }
            return null;
        }

        public void removeItem(int start, int end) {
            if (start > end) {
                return;
            }
            for (int i = start; i < end; ++i) {
                this.removeItem(i);
            }
        }

        public synchronized void removeItem(int index) {
            if (this.size <= index) {
                return;
            }
            if (index < 0) {
                return;
            }
            if (this.objectlist[index] instanceof RemovedInd) {
                return;
            }
            this.objectlist[index] = REMOVED;
            ++this.del;
        }

        public boolean isEmpty() {
            return this.size() <= 0;
        }

        public void toArray(Object[] objectArray) {
            if (this.del == 0) {
                System.arraycopy(this.objectlist, 0, objectArray, 0, objectArray.length);
            } else {
                int j = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (this.objectlist[i] instanceof RemovedInd) continue;
                    objectArray[j++] = this.objectlist[i];
                }
            }
        }

        public Object[] toArray() {
            Object[] retval = new Object[this.size()];
            if (this.del == 0) {
                System.arraycopy(this.objectlist, 0, retval, 0, retval.length);
            } else {
                int j = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (this.objectlist[i] instanceof RemovedInd) continue;
                    retval[j++] = this.objectlist[i];
                }
            }
            return retval;
        }

        public Object remove(int index) {
            Object retval = this.objectlist[index];
            this.removeItem(index);
            return retval;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayObject)) {
                return false;
            }
            ArrayObject ao = (ArrayObject)obj;
            if (ao.size != this.size) {
                return false;
            }
            if (ao.del != this.del) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.objectlist[i].equals(ao.objectlist[i])) continue;
                return false;
            }
            return true;
        }

        public void first() {
            this.cursor = 0;
            this.endCursor = -1;
        }

        public Object getFirst() {
            this.first();
            return this.hasNext() ? this.next() : null;
        }

        public boolean last() {
            int n = this.cursor = this.size <= 0 ? 0 : this.size - 1;
            return this.hasPrevious();
        }

        public void removeLast() {
            if (!this.last()) {
                return;
            }
            if (!this.hasPrevious()) {
                return;
            }
            this.removeItem(this.cursor);
        }

        public void lastAfter() {
            this.cursor = this.size;
            this.endCursor = -1;
        }

        public void firstAndSetEnd() {
            this.cursor = 0;
            this.endCursor = this.size;
        }

        public int getLatestCursor() {
            return this.latest;
        }

        public int hasNext(int incursor) {
            if (incursor >= this.size) {
                return -1;
            }
            while (this.objectlist[incursor] instanceof RemovedInd && incursor < this.size) {
                ++incursor;
            }
            return incursor < this.size ? incursor : -1;
        }

        public boolean hasNext() {
            if (this.cursor >= this.size) {
                return false;
            }
            while (this.objectlist[this.cursor] instanceof RemovedInd && this.cursor < this.size) {
                ++this.cursor;
            }
            if (this.endCursor != -1 && this.cursor >= this.endCursor) {
                return false;
            }
            return this.cursor < this.size;
        }

        public boolean hasPrevious() {
            if (this.cursor < 0) {
                return false;
            }
            while (this.objectlist[this.cursor] instanceof RemovedInd && this.cursor >= 0) {
                --this.cursor;
            }
            return this.cursor >= 0;
        }

        public Object next() {
            this.latest = this.cursor;
            return this.objectlist[this.cursor++];
        }

        public Object previous() {
            this.latest = this.cursor;
            return this.objectlist[this.cursor--];
        }

        public void remove() {
            this.removeItem(this.latest);
        }

        public void addCursor(Object in) {
            this.latest = this.addItem(in);
        }

        public void setValue(Object in) {
            this.objectlist[this.latest] = in;
        }

        public void setValue(int index, Object in) {
            if (index >= this.size) {
                return;
            }
            if (index < 0) {
                return;
            }
            this.objectlist[index] = in;
        }

        public Object clone() {
            try {
                ArrayObject return_val = (ArrayObject)super.clone();
                return_val.objectlist = (Object[])this.objectlist.clone();
                return return_val;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }

    public static class RemovedInd
    implements Serializable {
        private static final long serialVersionUID = 200804010300001L;
    }

    public static class ObjectSetArray
    implements Cloneable,
    Serializable {
        private Object[] objectlist = new Object[10];
        private static final long serialVersionUID = 200708020400001L;

        public void set(int index, Object value) {
            if (this.objectlist.length <= index) {
                Object[] back = new Object[(index / 10 + 1) * 10];
                System.arraycopy(this.objectlist, 0, back, 0, this.objectlist.length);
                this.objectlist = back;
            }
            this.objectlist[index] = value;
        }

        public Object get(int index) {
            if (index < 0) {
                return null;
            }
            if (this.objectlist.length <= index) {
                return null;
            }
            return this.objectlist[index];
        }

        public Object[] toArray() {
            return this.objectlist;
        }

        public Object clone() {
            try {
                ObjectSetArray return_val = (ObjectSetArray)super.clone();
                return_val.objectlist = (Object[])this.objectlist.clone();
                return return_val;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }

    public static class PrimitiveArrayII
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 200709070300010L;
        private int size = 0;
        private int[] idxlist = new int[10];
        private int[] valuelist = new int[10];
        private int bakgetvalues = -1;
        private transient int count = 0;
        private int latest = -1;

        public synchronized boolean addSort(int idxkey, int value) {
            int idx;
            boolean retval = false;
            for (int i = idx = this.srSorted(idxkey); i < this.idxlist.length; ++i) {
                if (this.size == i) {
                    this.idxlist[i] = idxkey;
                    this.valuelist[i] = value;
                    retval = true;
                    ++this.size;
                    break;
                }
                if (this.idxlist[i] < idxkey) continue;
                if (this.idxlist[i] == idxkey && this.valuelist[i] == value) {
                    return false;
                }
                System.arraycopy(this.idxlist, i, this.idxlist, i + 1, this.size - i);
                System.arraycopy(this.valuelist, i, this.valuelist, i + 1, this.size - i);
                this.idxlist[i] = idxkey;
                this.valuelist[i] = value;
                retval = true;
                ++this.size;
                break;
            }
            if (this.size == this.idxlist.length) {
                int inc = this.idxlist.length / 2 > 1000 ? 1000 : this.idxlist.length / 2;
                int[] back = new int[this.idxlist.length + inc];
                System.arraycopy(this.idxlist, 0, back, 0, this.idxlist.length);
                this.idxlist = back;
                back = new int[this.valuelist.length + inc];
                System.arraycopy(this.valuelist, 0, back, 0, this.valuelist.length);
                this.valuelist = back;
            }
            return retval;
        }

        public int srSorted(int idxkey) {
            if (this.size == 0) {
                return 0;
            }
            if (this.idxlist[0] > idxkey) {
                return 0;
            }
            if (this.idxlist[this.size - 1] < idxkey) {
                return this.size - 1;
            }
            boolean sqchk = false;
            int start = 0;
            int end = this.size - 1;
            while (end - start >= 0) {
                if (this.idxlist[end] == idxkey) {
                    return end;
                }
                if (this.idxlist[start] == idxkey) {
                    return start;
                }
                if (end - start < 5 || sqchk) {
                    int retval = start;
                    int i = start + 1;
                    while (i <= end) {
                        if (this.idxlist[i] == idxkey) {
                            return i;
                        }
                        if (this.idxlist[i] >= idxkey) break;
                        retval = i++;
                    }
                    return retval;
                }
                int nextstart = (end - start - 1) / 2 + start;
                int nextend = end - (end - start - 1) / 2;
                if (this.idxlist[nextstart] > idxkey) {
                    if (this.idxlist[nextend] <= idxkey) {
                        sqchk = true;
                        continue;
                    }
                    end = nextend;
                    continue;
                }
                if (this.idxlist[nextstart] == idxkey) {
                    sqchk = true;
                    continue;
                }
                start = nextstart;
            }
            return 0;
        }

        public int indexofSorted(int idxkey) {
            if (this.size == 0) {
                return -1;
            }
            if (this.idxlist[0] > idxkey) {
                return -1;
            }
            if (this.idxlist[this.size - 1] < idxkey) {
                return -1;
            }
            boolean sqchk = false;
            int start = 0;
            int end = this.size - 1;
            while (end - start >= 0) {
                if (this.idxlist[end] == idxkey) {
                    return end;
                }
                if (this.idxlist[start] == idxkey) {
                    return start;
                }
                if (end - start < 5 || sqchk) {
                    int retval = end;
                    for (int i = start + 1; i <= end; ++i) {
                        if (this.idxlist[i] != idxkey) continue;
                        return i;
                    }
                    return -1;
                }
                int nextstart = (end - start - 1) / 2 + start;
                int nextend = end - (end - start - 1) / 2;
                if (this.idxlist[nextstart] > idxkey) {
                    if (this.idxlist[nextend] <= idxkey) {
                        sqchk = true;
                        continue;
                    }
                    end = nextend;
                    continue;
                }
                if (this.idxlist[nextstart] == idxkey) {
                    sqchk = true;
                    continue;
                }
                start = nextstart;
            }
            return 0;
        }

        public boolean containsSort(int idxkey) {
            int idx = this.indexofSorted(idxkey);
            return idx >= 0;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.size = 0;
        }

        public int getValues(int idxkey) {
            this.bakgetvalues = -1;
            int idx = this.indexofSorted(idxkey);
            if (idx < 0) {
                throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u306a\u3057");
            }
            this.bakgetvalues = idx;
            return this.valuelist[idx];
        }

        public PrimitiveArrayI getValues() {
            PrimitiveArrayI retval = new PrimitiveArrayI();
            for (int i = 0; i < this.size; ++i) {
                retval.addSort(this.valuelist[i]);
            }
            return retval;
        }

        public int getValuesCont(int idxkey) {
            if (this.bakgetvalues < 0) {
                throw new IllegalAccessError("\u7d9a\u304d\u306a\u3057");
            }
            return this.idxlist[++this.bakgetvalues] == idxkey && this.bakgetvalues < this.size ? this.valuelist[this.bakgetvalues] : -1;
        }

        public int getIdxKey(int value) {
            for (int i = 0; i < this.size; ++i) {
                if (this.valuelist[i] != value) continue;
                return this.idxlist[i];
            }
            throw new IllegalArgumentException("\u691c\u7d22\u5024\u306a\u3057");
        }

        public synchronized void remove(int idxkey, int value) {
            int idx = this.indexofSorted(idxkey);
            if (idx < 0) {
                return;
            }
            for (int i = idx; i < this.idxlist.length && this.idxlist[i] == idxkey && this.valuelist[i] == value; ++i) {
                System.arraycopy(this.idxlist, i + 1, this.idxlist, i, this.size - i - 1);
                System.arraycopy(this.valuelist, i + 1, this.valuelist, i, this.size - i - 1);
                --this.size;
            }
        }

        public synchronized void remove(int idxkey) {
            int idx = this.indexofSorted(idxkey);
            if (idx < 0) {
                return;
            }
            for (int i = idx; i < this.idxlist.length && this.idxlist[i] == idxkey; ++i) {
                System.arraycopy(this.idxlist, i + 1, this.idxlist, i, this.size - i - 1);
                System.arraycopy(this.valuelist, i + 1, this.valuelist, i, this.size - i - 1);
                --this.size;
            }
        }

        public boolean isEmpty() {
            return this.size <= 0;
        }

        public void first() {
            this.count = 0;
        }

        public boolean hasNext() {
            return this.count >= 0 && this.count < this.size;
        }

        public int nextIdxKey() {
            this.latest = this.count;
            return this.idxlist[this.count++];
        }

        public void last() {
            this.count = this.size - 1;
        }

        public boolean hasPrevious() {
            return this.count >= 0;
        }

        public int previousIdxKey() {
            this.latest = this.count;
            return this.idxlist[this.count--];
        }

        public int latestValue() {
            return this.latest >= 0 ? this.valuelist[this.latest] : 0;
        }

        public Object clone() {
            try {
                PrimitiveArrayII return_val = (PrimitiveArrayII)super.clone();
                return_val.valuelist = (int[])this.valuelist.clone();
                return_val.idxlist = (int[])this.idxlist.clone();
                return return_val;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }

    public static class PrimitiveArrayI
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 201008020300001L;
        private int size = 0;
        private int[] intlist = new int[10];
        private int cursor = 0;
        private int endCursor = -1;
        private int latest = -1;

        public PrimitiveArrayI() {
        }

        public PrimitiveArrayI(int[] intarray) {
            for (int i = 0; i < intarray.length; ++i) {
                this.add(intarray[i]);
            }
        }

        public void addAll(PrimitiveArrayI values) {
            values.first();
            while (values.hasNext()) {
                this.add(values.next());
            }
        }

        public synchronized int add(int value) {
            this.intlist[this.size] = value;
            int retval = this.size++;
            if (this.size == this.intlist.length) {
                int inc = this.intlist.length / 2 > 1000 ? 1000 : this.intlist.length / 2;
                int[] back = new int[this.intlist.length + inc];
                System.arraycopy(this.intlist, 0, back, 0, this.intlist.length);
                this.intlist = back;
            }
            return retval;
        }

        public void addAllSort(PrimitiveArrayI values) {
            values.first();
            while (values.hasNext()) {
                this.addSort(values.next());
            }
        }

        public synchronized int addSort(int value) {
            int retval;
            for (int i = retval = this.indexofSorted(value); i < this.intlist.length; ++i) {
                if (this.size == i) {
                    this.intlist[i] = value;
                    retval = i;
                    ++this.size;
                    break;
                }
                if (this.intlist[i] > value) {
                    System.arraycopy(this.intlist, i, this.intlist, i + 1, this.size - i);
                    this.intlist[i] = value;
                    retval = i;
                    ++this.size;
                    break;
                }
                if (this.intlist[i] != value) continue;
                retval = i;
                break;
            }
            if (this.size == this.intlist.length) {
                int inc = this.intlist.length / 2 > 1000 ? 1000 : this.intlist.length / 2;
                int[] back = new int[this.intlist.length + inc];
                System.arraycopy(this.intlist, 0, back, 0, this.intlist.length);
                this.intlist = back;
            }
            return retval;
        }

        public int indexofSorted(int value) {
            if (this.size == 0) {
                return 0;
            }
            if (this.intlist[0] > value) {
                return 0;
            }
            if (this.intlist[this.size - 1] < value) {
                return this.size - 1;
            }
            int start = 0;
            int end = this.size - 1;
            while (end - start >= 0) {
                if (this.intlist[end] == value) {
                    return end;
                }
                if (this.intlist[start] == value) {
                    return start;
                }
                if (end - start < 5) {
                    int retval = end;
                    int i = start + 1;
                    while (i <= end) {
                        if (this.intlist[i] == value) {
                            return i;
                        }
                        if (this.intlist[i] >= value) break;
                        retval = i++;
                    }
                    return retval;
                }
                int nextstart = (end - start - 1) / 2 + start;
                int nextend = end - (end - start - 1) / 2;
                if (this.intlist[nextstart] > value) {
                    end = nextend;
                    continue;
                }
                start = nextstart;
            }
            return 0;
        }

        public boolean containsSort(int value) {
            int idx = this.indexofSorted(value);
            if (idx < 0) {
                return false;
            }
            if (idx < 0 || this.intlist[idx] != value) {
                return false;
            }
            return this.intlist[idx] == value;
        }

        public boolean containsSort(PrimitiveArrayI in) {
            if (in.isEmpty()) {
                return false;
            }
            in.first();
            while (in.hasNext()) {
                if (this.containsSort(in.next())) continue;
                return false;
            }
            return true;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.size = 0;
        }

        public synchronized boolean contains(int value) {
            for (int i = 0; i < this.size; ++i) {
                if (this.intlist[i] != value) continue;
                return true;
            }
            return false;
        }

        public int getValue(int index) {
            return this.intlist[index];
        }

        public void setValue(int idx, int in) {
            this.intlist[idx] = in;
        }

        public synchronized void remove(int index) {
            if (this.size <= index) {
                return;
            }
            if (index < 0) {
                return;
            }
            if (index + 1 < this.intlist.length) {
                System.arraycopy(this.intlist, index + 1, this.intlist, index, this.size - index - 1);
            }
            --this.size;
        }

        public boolean equalsValue(int index, int inf) {
            if (this.size <= index) {
                return false;
            }
            return this.intlist[index] == inf;
        }

        public boolean equals(Object in) {
            if (!(in instanceof PrimitiveArrayI)) {
                return false;
            }
            PrimitiveArrayI inpi = (PrimitiveArrayI)in;
            if (this.size() != inpi.size()) {
                return false;
            }
            this.first();
            inpi.first();
            while (this.hasNext() && inpi.hasNext()) {
                if (this.next() == inpi.next()) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.size <= 0;
        }

        public int[] toArray() {
            int[] retval = new int[this.size()];
            System.arraycopy(this.intlist, 0, retval, 0, retval.length);
            return retval;
        }

        public int[] toArray(int statidx, int endidx) {
            if (endidx <= statidx) {
                throw new IllegalArgumentException();
            }
            int[] retval = new int[endidx - statidx + 1];
            System.arraycopy(this.intlist, statidx, retval, 0, retval.length);
            return retval;
        }

        public void first() {
            this.cursor = 0;
            this.endCursor = -1;
        }

        public void last() {
            this.cursor = this.size <= 0 ? 0 : this.size - 1;
            this.endCursor = -1;
        }

        public boolean setLatestCursor(int cursor) {
            if (cursor >= this.size) {
                return false;
            }
            this.latest = cursor;
            return true;
        }

        public void firstAndSetEnd() {
            this.cursor = 0;
            this.endCursor = this.size;
        }

        public int getValue() {
            this.latest = this.cursor;
            return this.intlist[this.cursor];
        }

        public boolean hasNext() {
            if (this.cursor >= this.size) {
                return false;
            }
            return this.endCursor == -1 || this.cursor < this.endCursor;
        }

        public int getCursor() {
            return this.cursor;
        }

        public boolean setCursor(int cursor) {
            if (cursor >= this.size) {
                return false;
            }
            this.cursor = cursor;
            return true;
        }

        public boolean hasPrevious() {
            if (this.cursor < 0) {
                return false;
            }
            return this.size != 0;
        }

        public void addCursor(int in) {
            this.latest = this.add(in);
        }

        public void setValue(int in) {
            this.intlist[this.latest] = in;
        }

        public int getLatestValue() {
            return this.intlist[this.latest];
        }

        public int[] getValuesWOlatest() {
            int sizemax = this.endCursor > 0 ? this.endCursor : this.size();
            sizemax = this.latest >= 0 && this.latest < this.endCursor ? sizemax - 1 : sizemax;
            int[] retval = new int[sizemax];
            int j = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.intlist[i] < 0) continue;
                if (i != this.latest && this.latest >= 0) {
                    retval[j++] = this.intlist[i];
                }
                if (retval.length == j) break;
            }
            return retval;
        }

        public int next() {
            this.latest = this.cursor;
            return this.intlist[this.cursor++];
        }

        public int previous() {
            this.latest = this.cursor;
            return this.intlist[this.cursor--];
        }

        public int getLatestCursor() {
            return this.latest;
        }

        public void remove() {
            this.remove(this.latest);
            --this.cursor;
            if (this.cursor < 0) {
                this.cursor = 0;
            }
        }

        public Object clone() {
            try {
                PrimitiveArrayI return_val = (PrimitiveArrayI)super.clone();
                return_val.intlist = (int[])this.intlist.clone();
                return return_val;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }
}

