/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import analyzecodeC.WRWordTable;
import analyzecodeC.WRwSplitTr;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WRwSplitChars {
    private WRwSplitTr wst = null;
    private static transient WRWordTable wtbls;
    private static transient WRWordTable wtblsword;
    private char[] chars = new char[100];
    private int index = 0;
    private int conjidx = 0;
    private int conjlastidx = -1;
    private static final String[] inisplitchar;
    private static final String[] inisplitWordchar;
    public static final char stringMark = '\"';
    private static final char stringArstart = '[';
    private static final char stringArend = ']';
    private static final String[] cmpMark;
    private static final String[] settoMark;
    private ArrayList<SentPart> sps = null;
    private static final int OFFSET = 10;
    private boolean nextstrmark = false;
    private transient int skipsplit = 0;

    public WRwSplitChars(WRwSplitTr tr) {
        this.wst = tr;
        if (wtbls == null) {
            WRwSplitChars.setWtbls();
        }
    }

    private static void setWtbls() {
        wtbls = new WRWordTable();
        wtblsword = new WRWordTable();
        for (int j = 0; j < inisplitchar.length; ++j) {
            wtbls.wordToWid(inisplitchar[j], true);
            if (inisplitWordchar.length <= j) continue;
            wtblsword.wordToWid(inisplitWordchar[j], true);
        }
    }

    public static boolean isKakkoStart(String conj) {
        return conj.equals("(") || conj.equals("{");
    }

    public static boolean isKakkoEnd(String conj) {
        return conj.equals(")") || conj.equals("}");
    }

    public static boolean isCompMark(String conj) {
        for (int i = 0; i < cmpMark.length; ++i) {
            if (!cmpMark[i].equals(conj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSettoMark(String conj) {
        for (int i = 0; i < settoMark.length; ++i) {
            if (!settoMark[i].equals(conj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSettoMarkEle(String conj) {
        return conj.equals("=");
    }

    public static boolean isKanma(String conj) {
        return conj.equals(",");
    }

    public static boolean isConj(String in) {
        return wtbls.wordToWid(in, false) != null;
    }

    private MyUtil.PrimitiveArrayII isInisplitchar() {
        WRWordTable sconj = wtbls;
        if (sconj.getWids(this.chars, this.conjidx)) {
            return sconj.getWidsOutWidLen();
        }
        return null;
    }

    public static boolean isSplitWord(String word) {
        for (int i = 0; i < inisplitWordchar.length; ++i) {
            if (!inisplitWordchar[i].equals(word)) continue;
            return true;
        }
        return false;
    }

    public static SentPart[] splitWordchar(SentPart sp) {
        char[] inchars = sp.word.toCharArray();
        String[] split = WRwSplitChars.splitWordchar(inchars, 1, inchars.length);
        if (split.length == 0) {
            return null;
        }
        ArrayList<SentPart> retval = new ArrayList<SentPart>();
        for (int i = 0; i < split.length - 1; ++i) {
            retval.add(new SentPart(split[i], split[i + 1]));
        }
        retval.add(new SentPart(split[split.length - 1], sp.getConjunc()));
        return retval.toArray(new SentPart[retval.size()]);
    }

    public static String[] splitWordchar(char[] inchars, int start, int end) {
        WRWordTable swconj = wtblsword;
        WRWordTable skconj = wtbls;
        ArrayList<String> retval = new ArrayList<String>();
        String word2 = null;
        for (int i = start; i < end; ++i) {
            MyUtil.PrimitiveArrayII cids = null;
            if (!swconj.getWids(inchars, i)) {
                if (!skconj.getWids(inchars, i)) continue;
                cids = skconj.getWidsOutWidLen();
            } else {
                cids = swconj.getWidsOutWidLen();
            }
            cids.last();
            int lastidx = cids.previousIdxKey();
            String word = new String(inchars, 0, i);
            retval.add(word);
            String conj = new String(inchars, i, lastidx + 1);
            retval.add(conj);
            word2 = new String(inchars, lastidx + i + 1, inchars.length - (lastidx + i + 1));
        }
        if (word2 != null) {
            retval.add(word2);
        }
        return retval.toArray(new String[retval.size()]);
    }

    private int getLastIdx(MyUtil.PrimitiveArrayII sconj) {
        sconj.last();
        int lastidx = sconj.previousIdxKey();
        int conjid = sconj.latestValue();
        return lastidx;
    }

    public ArrayList<SentPart> getSps() {
        return this.sps;
    }

    public SentPart[] getSpsArray() {
        if (this.sps == null) {
            return null;
        }
        SentPart[] retval = new SentPart[this.sps.size()];
        this.sps.toArray(retval);
        return retval;
    }

    public void creSps() {
        this.sps = new ArrayList();
        StringBuffer word = new StringBuffer();
        StringBuffer conj = new StringBuffer();
        if (!this.wst.first()) {
            return;
        }
        this.initChars();
        do {
            char c;
            if (this.wst.isDicarding() || this.wst.isDiscardchar() || this.addChars(c = this.wst.getChar()) || this.skipsplit('[', ']') || this.chkChars('\"', '\"')) continue;
            this.addSps2(word, conj);
            this.updateChars();
        } while (this.wst.next());
        for (int i = 0; i <= 10 && i < this.index; ++i) {
            if (this.skipsplit('[', ']') || this.chkChars('\"', '\"')) continue;
            this.addSps2(word, conj);
            this.updateChars();
            i = 0;
        }
        if (this.index > 0) {
            this.addSps2(word, conj);
        }
    }

    private void addSps2(StringBuffer word, StringBuffer conj) {
        SentPart ws;
        boolean normal = true;
        if (this.conjlastidx < 0) {
            return;
        }
        char strc = '\"';
        if (strc == this.chars[this.conjidx] && strc == this.chars[this.conjlastidx]) {
            word.append(this.chars, this.conjidx, this.conjlastidx - this.conjidx + 1);
            ws = new SentPart(word.toString(), conj.toString());
            this.sps.add(ws);
            normal = false;
        } else {
            word.append(this.chars, 0, this.conjidx);
            conj.append(this.chars, this.conjidx, this.conjlastidx - this.conjidx + 1);
        }
        if (normal) {
            ws = new SentPart(word.toString(), conj.toString());
            this.sps.add(ws);
        }
        word.delete(0, word.length());
        conj.delete(0, conj.length());
    }

    private boolean addChars(char inc) {
        if (this.index + 1 >= this.chars.length) {
            return false;
        }
        if (this.index > 0 && (this.chars[this.index - 1] == '\t' || this.chars[this.index - 1] == '\n' || this.chars[this.index - 1] == ' ') && this.chars[this.index - 1] == inc) {
            return true;
        }
        this.chars[this.index++] = inc;
        return this.index - this.conjidx <= 10;
    }

    private boolean skipsplit(char strs, char stre) {
        if (strs == this.chars[this.conjidx] && (this.conjidx == 0 || this.chars[this.conjidx - 1] != '\\')) {
            ++this.conjidx;
            this.conjlastidx = -1;
            ++this.skipsplit;
            return true;
        }
        if (this.skipsplit > 0) {
            if (stre == this.chars[this.conjidx] && this.chars[this.conjidx - 1] != '\\') {
                --this.skipsplit;
            }
            ++this.conjidx;
            this.conjlastidx = -1;
            return true;
        }
        return false;
    }

    private boolean chkChars(char strs, char stre) {
        MyUtil.PrimitiveArrayII conjids;
        if (this.nextstrmark) {
            if (this.conjidx != 0) {
                this.conjlastidx = this.conjidx;
                return false;
            }
            this.conjlastidx = 1;
            while ((this.chars[this.conjlastidx] != stre || this.chars[this.conjlastidx - 1] == '\\') && this.conjlastidx < this.index) {
                ++this.conjlastidx;
            }
            if (this.conjlastidx == this.index) {
                this.conjlastidx = -1;
                return true;
            }
            this.nextstrmark = false;
            return false;
        }
        if (strs == this.chars[this.conjidx + 1] && this.chars[this.conjidx] != '\\') {
            this.nextstrmark = true;
        }
        if ((conjids = this.isInisplitchar()) == null) {
            ++this.conjidx;
            this.conjlastidx = -1;
            return true;
        }
        this.conjlastidx = this.getLastIdx(conjids) + this.conjidx;
        return false;
    }

    private void updateChars() {
        try {
            System.arraycopy(this.chars, this.conjlastidx + 1, this.chars, 0, this.index - this.conjlastidx - 1);
        }
        catch (Exception e) {
            throw new Error();
        }
        this.index -= this.conjlastidx + 1;
        this.conjidx = 0;
        this.conjlastidx = -1;
    }

    private void initChars() {
        this.index = 0;
        this.conjidx = 0;
        this.conjlastidx = -1;
    }

    static {
        inisplitchar = new String[]{".", "->", "=", ";", "<", ">", ",", "\n", " ", "==", "!=", "&=", "+=", "-=", "%=", "*=", "/=", "^=", ">=", "<=", "|=", "+", "++", "-", "--", "&&", "|", "||", "^", "~", "/", "%", "(", ")", "{", "}", "<<", ">>", "<<=", ">>=", "!", "?", ":"};
        inisplitWordchar = new String[]{"*", "&"};
        cmpMark = new String[]{"<", ">", "==", "!=", ">=", "<=", "&&", "||"};
        settoMark = new String[]{"=", "&=", "+=", "-=", "%=", "*=", "/=", "^=", "|=", "<<=", ">>="};
    }
}

