/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import analyzecodeC.WRWordTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.CharBuffer;
import java.util.ArrayList;

public class WRwSplitTr {
    private File infile = null;
    private transient CharBuffer inchars = null;
    private int nowindex = -1;
    private static final int BUFFSIZE = 50000;
    private boolean discardchar = false;
    private boolean discarding = false;
    private static final char[] dischars = new char[]{'\f', '\r', '\b', '\t'};
    private transient WRWordTable discparT;
    private transient MyUtil.ObjectSetArray discparE;
    private static final String[] discardingsPare = new String[]{"/*", "*/", "//", "\n", "#", "\n", "__declspec", ";", "[returnvalue:", ";", "static __inline", "}"};
    private int preEndindex = -1;
    private char[] endTag = null;

    public WRwSplitTr() {
        this.creDisDataTable();
    }

    public WRwSplitTr(char[] inchars) {
        this();
        this.setInchars(inchars);
    }

    public WRwSplitTr(File file) {
        this();
        this.infile = file;
    }

    public void setInchars(char[] in) {
        this.inchars = CharBuffer.wrap(in);
    }

    public boolean first() {
        if (this.inchars == null || this.inchars.length() == 0) {
            if (this.infile == null) {
                return false;
            }
            if (!this.fileLoad(this.infile)) {
                return false;
            }
        }
        this.nowindex = 0;
        this.setDiscarding();
        if (!this.isDicarding()) {
            this.setDiscardChar();
        }
        return true;
    }

    private boolean fileLoad(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader rdr = new BufferedReader(fr);
            ArrayList<CharBuffer> bufs = new ArrayList<CharBuffer>();
            int len = 50000;
            while (len == 50000) {
                CharBuffer tmp = CharBuffer.allocate(50000);
                bufs.add(tmp);
                len = rdr.read(tmp);
            }
            rdr.close();
            this.inchars = CharBuffer.allocate(50000 * bufs.size());
            for (CharBuffer cbuf : bufs) {
                cbuf.position(0);
                this.inchars.put(cbuf);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean next() {
        if (this.inchars.length() == this.nowindex + 1 || this.inchars.get(this.nowindex + 1) == '\u0000') {
            return false;
        }
        ++this.nowindex;
        this.setDiscarding();
        if (!this.isDicarding()) {
            this.setDiscardChar();
        }
        return true;
    }

    private void setDiscardChar() {
        for (int i = 0; i < dischars.length; ++i) {
            if (dischars[i] != this.inchars.get(this.nowindex)) continue;
            this.discardchar = true;
            return;
        }
        this.discardchar = false;
    }

    private void creDisDataTable() {
        this.discparT = new WRWordTable();
        this.discparE = new MyUtil.ObjectSetArray();
        for (int i = 0; i < discardingsPare.length; ++i) {
            Integer wid = this.discparT.wordToWid(discardingsPare[i++], true);
            this.discparE.set(wid, discardingsPare[i]);
        }
    }

    private void setDiscarding() {
        if (this.endTag != null) {
            for (int i = 0; i < this.endTag.length; ++i) {
                if (this.endTag[i] == this.inchars.get(this.nowindex + i)) continue;
                return;
            }
            if (this.inchars.get(this.nowindex - 1) == '\\' || this.inchars.get(this.nowindex - 1) == '\r' && this.inchars.get(this.nowindex - 2) == '\\') {
                return;
            }
            this.preEndindex = this.nowindex + this.endTag.length - 1;
            this.endTag = null;
        }
        if (this.preEndindex >= 0) {
            if (this.nowindex < this.preEndindex) {
                return;
            }
            this.preEndindex = -1;
            return;
        }
        if (this.discparT.getWids(this.inchars.array(), this.nowindex)) {
            MyUtil.PrimitiveArrayII tags = this.discparT.getWidsOutWidLen();
            tags.last();
            int lastidx = tags.previousIdxKey();
            int tagsid = tags.latestValue();
            this.endTag = ((String)this.discparE.get(tagsid)).toCharArray();
            this.discarding = true;
        } else {
            this.discarding = false;
        }
    }

    public boolean isDicarding() {
        return this.discarding;
    }

    public boolean isDiscardchar() {
        return this.discardchar;
    }

    public char getChar() {
        return this.inchars.get(this.nowindex);
    }
}

