/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.SentPart;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSystemRev {
    private static final String[] C_SYSWORD = new String[]{"auto", "double", "int", "struct", "break", "else", "long", "switch", "case", "enum", "register", "typedef", "char", "extern", "return", "union", "const", "float", "short", "unsigned", "continue", "for", "signed", "void", "default", "goto", "sizeof", "volatile", "do", "if", "static", "while", "fortran", "pascal", "far", "near"};
    private static final String[] C_SYSWORD_ValType = new String[]{"double", "int", "long", "enum", "char", "float", "short", "void"};
    private static final String[] C_SYSWORD_StructType = new String[]{"else", "for", "do", "if", "while", "switch"};
    private static final String[] C_SYSWORD_StructType2 = new String[]{"break", "return", "continue", "goto"};
    private static final String[] C_SYSWORD_StructSwitch = new String[]{"break", "case", "default", "switch"};
    private static final String[] IGNOR_WORD = new String[]{"register", "auto", "extern", "const", "unsigned", "signed", "goto", "volatile", "static", "fortran", "pascal", "far", "near"};
    private static final String WORDTYPE1 = "typedef";
    private static HashMap<String, Integer> csysword;

    public WordSystemRev() {
        if (csysword == null) {
            csysword = new HashMap();
            for (int i = 0; i < C_SYSWORD.length; ++i) {
                int j;
                int type = 0;
                if (WORDTYPE1.equals(C_SYSWORD[i])) {
                    type |= 1;
                }
                for (j = 0; j < C_SYSWORD_ValType.length; ++j) {
                    if (!C_SYSWORD_ValType[j].equals(C_SYSWORD[i])) continue;
                    type |= 2;
                    break;
                }
                for (j = 0; j < C_SYSWORD_StructType.length; ++j) {
                    if (!C_SYSWORD_StructType[j].equals(C_SYSWORD[i])) continue;
                    type |= 4;
                    break;
                }
                for (j = 0; j < C_SYSWORD_StructType2.length; ++j) {
                    if (!C_SYSWORD_StructType2[j].equals(C_SYSWORD[i])) continue;
                    type |= 8;
                    break;
                }
                for (j = 0; j < C_SYSWORD_StructSwitch.length; ++j) {
                    if (!C_SYSWORD_StructSwitch[j].equals(C_SYSWORD[i])) continue;
                    type |= 0x10;
                    break;
                }
                csysword.put(C_SYSWORD[i], type);
            }
        }
    }

    public static boolean isStructType2Word(String word) {
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word);
        if (i == null) {
            return false;
        }
        return (i & 8) != 0;
    }

    public static boolean isStructTypeSwitch(String word) {
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word);
        if (i == null) {
            return false;
        }
        return (i & 0x10) != 0;
    }

    public static boolean isStructTypeWord(String word) {
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word);
        if (i == null) {
            return false;
        }
        return (i & 4) != 0;
    }

    public static boolean isStructTypeWord(SentPart sp) {
        String word = sp.getWord();
        if (word == null) {
            return false;
        }
        return WordSystemRev.isStructTypeWord(word);
    }

    public static boolean isPrimTypeWord(SentPart sp) {
        String word = sp.getWord();
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word = WordSystemRev.cutAster(word));
        if (i == null) {
            return false;
        }
        return (i & 2) != 0;
    }

    public static boolean isUnionStruct(SentPart sp) {
        if (sp == null) {
            return false;
        }
        return sp.word.equals("union") || sp.word.equals("struct");
    }

    public static String getIf() {
        return "if";
    }

    public static String getElse() {
        return "else";
    }

    public static String getDefault() {
        return "default";
    }

    public static boolean isEnum(SentPart sp) {
        return sp != null && sp.word.equals("enum");
    }

    public static boolean isTyeDef(SentPart sp) {
        return sp != null && sp.word.equals(WORDTYPE1);
    }

    public static void addExtCsWord(HashMap<String, SentPart[]> extracsysword, ArrayList<SentPart> sps) {
        if (sps.size() < 2) {
            throw new Error();
        }
        SentPart[] extsps = new SentPart[sps.size() - 1];
        for (int i = 0; i < extsps.length; ++i) {
            extsps[i] = (SentPart)sps.get(i).clone();
        }
        extracsysword.put(sps.get((int)(sps.size() - 1)).word, extsps);
    }

    public static boolean isSysWord(ArrayList<SentPart> sps, int idx) {
        SentPart sp = sps.get(idx);
        if (sp == null) {
            return false;
        }
        String word = WordSystemRev.cutAster(sp.word);
        Integer o = csysword.get(word);
        return o != null;
    }

    public static boolean isSysWord(SentPart sp) {
        if (sp == null) {
            return false;
        }
        String word = WordSystemRev.cutAster(sp.word);
        Integer o = csysword.get(word);
        return o != null;
    }

    private static String cutAster(String word) {
        char lca;
        if (word.length() > 2 && (lca = word.charAt(word.length() - 1)) == '*') {
            word = word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static SentPart[] getTypeDefSps(HashMap<String, SentPart[]> extracsysword, SentPart sp) {
        return extracsysword.get(sp.word);
    }
}

