/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.decode.BlockType;
import analyzecodeC.decode.MemObject;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.ErlangCreator;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class BasicBlock
implements BlockType,
Serializable {
    private InputMemnames input;
    private static final long serialVersionUID = 201002060007000001L;
    private ArrayList<Element> eleline = new ArrayList();
    private int casenos;
    private BasicBlock nextlink;
    private BasicBlock childbb;

    public void setInput(InputMemnames input) {
        this.input = input;
    }

    public InputMemnames getInput() {
        if (this.input == null) {
            this.creInput();
        }
        return this.input;
    }

    public void creInput() {
        this.input = new InputMemnames();
        for (Element ele : this.eleline) {
            ArrayList<MemObject> inmos = ele.collectMemobj();
            for (MemObject mo : inmos) {
                this.input.putInput(mo);
            }
        }
    }

    public void addLine(Element bb) {
        this.eleline.add(bb);
    }

    public boolean isEmpty() {
        return this.eleline.isEmpty();
    }

    public boolean creFuncTopBody(String fname, ElementOutput output, EditBuffer retval, boolean ramdaend) {
        boolean bret = false;
        BasicBlock work = this;
        while (work != null) {
            if (work.casenos > 0) {
                ErlangCreator.getFuncTopSTBB(fname, work.getInput().toErlang(output), work.casenos, retval);
                bret |= work.getFuncBody(output, retval, ramdaend);
                retval.setLineEndSN();
            } else {
                ErlangCreator.getFuncTopBB(fname, work.getInput().toErlang(output), retval);
                bret |= work.getFuncBody(output, retval, ramdaend);
            }
            work = work.nextlink;
        }
        return bret;
    }

    public boolean getFuncBody(ElementOutput output, EditBuffer retval, boolean ramdaend) {
        Iterator<Element> it = this.eleline.iterator();
        boolean doexe = false;
        while (it.hasNext()) {
            Element ele = it.next();
            ele.setExtflg(output);
            if (!it.hasNext() && ramdaend) {
                boolean ramda = output.toErlangRamdPara(retval);
                if (ramda) {
                    retval.setLineEndKN();
                }
                retval.append(ele.toErlang(output));
                retval.setLineEndKN();
                doexe = true;
                break;
            }
            if (ele.isSetSent()) {
                if (output.updateRamdParaVal(ele)) continue;
                doexe = true;
                retval.append(ele.getEleC_ToErlang(output));
                retval.setLineEndKN();
                continue;
            }
            doexe = true;
            retval.append(ele.toErlang(output));
            retval.setLineEndKN();
        }
        return doexe;
    }

    public int getCasenos() {
        return this.casenos;
    }

    public void setCasenos(int casenos) {
        this.casenos = casenos;
    }

    public void setNextLink(BasicBlock inbb) {
        this.nextlink = inbb;
    }

    public boolean isSingle() {
        return this.nextlink == null;
    }

    public boolean chkSMP() {
        return false;
    }

    public void addBBinput(InputMemnames bbinput) {
    }

    public BasicBlock getChildbb() {
        return this.childbb;
    }

    public void setChildbb(BasicBlock childbb) {
        this.childbb = childbb;
    }

    public boolean getFuncBodyEnd(String funcname, ElementOutput output, EditBuffer retval, boolean smp) {
        retval.setLineEndSN();
        return true;
    }

    public boolean getFuncBodyTop(String funcname, ElementOutput output, EditBuffer retval) {
        if (this.casenos > 0) {
            ErlangCreator.getFuncTopSTBB(funcname, this.getInput().toErlang(output), this.casenos, retval);
            return true;
        }
        ErlangCreator.getFuncTopBB(funcname, this.getInput().toErlang(output), retval);
        return true;
    }
}

