/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.SentPart;
import analyzecodeC.WordSystemRev;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumTypeData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201003180088000001L;
    private String name;
    private HashMap<String, EnumTypeData> enumtypes;
    private EnumTypeData usedat;
    private int state = 0;
    private transient String tmpword = null;
    private transient String tmpval = null;
    private ArrayList<String> enumkeys;
    private ArrayList<String> enumvalues;

    public EnumTypeData(HashMap<String, EnumTypeData> inetypdata) {
        new WordSystemRev();
        this.enumtypes = inetypdata;
    }

    public String getName() {
        return this.name;
    }

    public boolean exeStateTrans(SentPart sp) {
        boolean retval = true;
        block8: while (retval) {
            switch (this.state) {
                case 0: {
                    retval = this.state0(sp);
                    continue block8;
                }
                case 1: {
                    retval = this.state1(sp);
                    continue block8;
                }
                case 2: {
                    retval = this.state2(sp);
                    continue block8;
                }
                case 3: {
                    retval = this.state3(sp);
                    continue block8;
                }
                case 4: {
                    retval = this.state4(sp);
                    continue block8;
                }
                case 5: {
                    retval = this.state5(sp);
                    continue block8;
                }
            }
            throw new Error();
        }
        return this.state != 0;
    }

    private boolean state0(SentPart sp) {
        this.usedat = null;
        this.tmpword = null;
        this.tmpval = null;
        if (WordSystemRev.isSysWord(sp) && sp.getWord().equals("enum")) {
            this.state = 1;
        }
        return false;
    }

    private boolean state1(SentPart sp) {
        if (sp.getWord() == null || sp.getWord().equals("")) {
            this.state = 0;
            return false;
        }
        this.name = sp.getWord();
        this.usedat = this.enumtypes.get(this.name);
        if (this.usedat != null) {
            this.state = 0;
            return false;
        }
        String conj = sp.getConjunc();
        this.state = conj == null || !conj.equals(" ") ? 0 : 2;
        return false;
    }

    private boolean state2(SentPart sp) {
        String conj = sp.getConjunc();
        String word = sp.getWord();
        if (this.usedat != null) {
            throw new Error();
        }
        if (conj == null) {
            this.state = 0;
            return false;
        }
        if (conj.equals(" ")) {
            return false;
        }
        if (!conj.equals("{")) {
            this.state = 0;
            return false;
        }
        this.state = 3;
        return false;
    }

    private boolean state3(SentPart sp) {
        this.tmpword = sp.getWord();
        if (sp.getConjunc().equals("}")) {
            this.state = 0;
            this.enumtypes.put(this.name, this);
            this.usedat = this;
            return false;
        }
        if (this.tmpword == null || this.tmpword.equals("")) {
            this.usedat = null;
            this.state = 0;
            return false;
        }
        this.state = 4;
        return true;
    }

    private boolean state4(SentPart sp) {
        String tmpconj = sp.getConjunc();
        if (tmpconj == null || tmpconj.equals("")) {
            this.usedat = null;
            this.state = 0;
            return false;
        }
        if (tmpconj.equals(",")) {
            this.state = 3;
            this.addEnumDats(this.tmpword, null);
            this.tmpword = null;
            tmpconj = null;
            return false;
        }
        if (tmpconj.equals("=")) {
            this.state = 5;
        }
        return false;
    }

    private boolean state5(SentPart sp) {
        this.tmpval = sp.getWord();
        if (this.tmpval == null) {
            this.usedat = null;
            this.state = 0;
            return false;
        }
        String tmpconj = sp.getConjunc();
        if (tmpconj == null || tmpconj.equals("")) {
            this.usedat = null;
            this.state = 0;
            return false;
        }
        if (tmpconj.equals(",")) {
            this.state = 3;
            this.addEnumDats(this.tmpword, this.tmpval);
            this.tmpword = null;
            this.tmpval = null;
            return false;
        }
        this.state = 5;
        return false;
    }

    private void addEnumDats(String key, String value) {
        if (this.enumkeys == null) {
            this.enumkeys = new ArrayList();
            this.enumvalues = new ArrayList();
        }
        this.enumkeys.add(key);
        if (value == null) {
            this.enumvalues.add(new Integer(this.enumkeys.indexOf(key)).toString());
        } else {
            this.enumvalues.add(value);
        }
    }

    public String getValue(String key) {
        return this.enumvalues.get(this.enumkeys.indexOf(key));
    }

    public EnumTypeData getUsedat() {
        return this.usedat;
    }
}

