/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;

public class Function
implements Serializable {
    private static final long serialVersionUID = 201003030101000101L;
    private String fname;
    private ProcessKakko pk = null;
    private String module;
    private String[] paras;

    public Function(String module, ProcessKakko funcobj) {
        this.pk = funcobj;
        this.fname = funcobj.getScopname();
        this.module = module;
        this.paras = this.creParas(this.pk.getInput(), this.pk.getInmems());
    }

    public Function(String fname, int parasize) {
        this.fname = fname;
        this.paras = this.creParas(parasize);
    }

    public ProcessKakko getPk() {
        return this.pk;
    }

    public boolean modParasize(int parasize) {
        if (this.pk != null) {
            return false;
        }
        this.paras = this.creParas(parasize);
        return true;
    }

    public void setPk(String modname, ProcessKakko inpk) {
        this.module = modname;
        this.pk = inpk;
    }

    private String[] creParas(int size) {
        ArrayList<String> retval = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            retval.add("P" + i);
        }
        return retval.toArray(new String[retval.size()]);
    }

    private String[] creParas(InputMemnames input, MemObjects mojs) {
        String[] creparas = input.getparas();
        creparas = mojs.sortRamdaparaNames(creparas);
        for (int i = 0; i < creparas.length; ++i) {
            String lower = creparas[i].substring(1);
            String upper = creparas[i].substring(0, 1);
            creparas[i] = upper.toUpperCase() + lower;
        }
        return creparas;
    }

    public String getErlFuncCall() {
        if (this.fname.contains(":")) {
            return this.fname;
        }
        if (this.module == null) {
            return "ctoerlstub:" + this.fname;
        }
        return this.module + ":" + this.fname;
    }

    public String getErlFuncStbCode() {
        EditBuffer retval = new EditBuffer();
        StringBuffer parasstr = new StringBuffer();
        for (int i = 0; i < this.paras.length; ++i) {
            if (i > 0) {
                parasstr.append(",");
            }
            parasstr.append(this.paras[i]);
        }
        retval.append(this.fname + "(" + parasstr.toString() + ") ->");
        retval.setLineEndN();
        retval.incNest();
        if (this.module == null) {
            retval.append("0");
        } else {
            retval.append(this.module + ":" + this.fname + "(" + parasstr.toString() + ")");
        }
        retval.setFuncEnd();
        return retval.toString();
    }

    public String getParaSize() {
        Integer it = new Integer(this.paras.length);
        return it.toString();
    }

    public boolean isLiblary() {
        if (this.fname.contains(":")) {
            return false;
        }
        return this.pk == null;
    }

    public String getErlfileTopExport() {
        StringBuffer retval = new StringBuffer();
        retval.append("-export([" + this.fname + "/" + this.getParaSize() + "]).\n");
        return retval.toString();
    }
}

