/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.WRwSplitChars;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ErlangCreator;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemObjArray
implements Serializable {
    private static final long serialVersionUID = 201002060009000001L;
    private String name = "";
    private String arrayKey;
    private ArrayList<String> arraynest = new ArrayList();
    private Defaultval toparray = new Defaultval();

    public MemObjArray() {
    }

    protected MemObjArray(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getArrayKey() {
        return this.arrayKey;
    }

    public void setArrayKey(String arrayKey) {
        this.arrayKey = arrayKey;
    }

    public String getSizeElements() {
        StringBuffer retval = new StringBuffer();
        for (String size : this.arraynest) {
            retval.append("(");
            retval.append(size);
            retval.append(") * ");
        }
        retval.append("1");
        return retval.toString();
    }

    public ArrayList<String> getArrayNest() {
        return this.arraynest;
    }

    protected void addNest(int size) {
        int nownest = this.arraynest.size();
        Defaultval dfv = this.getDfv(new int[nownest]);
        if (dfv == null) {
            this.toparray.setSize(size);
        } else {
            dfv.addChild(size);
        }
        this.arraynest.add(new Integer(size).toString());
    }

    public static String getArraySymName(String word) {
        StringBuffer synm = new StringBuffer();
        char[] cas = word.toCharArray();
        for (int index = 0; index < cas.length; ++index) {
            if (cas[index] == '[') {
                return synm.toString();
            }
            synm.append(cas[index]);
        }
        return null;
    }

    public static MyUtil.ArrayObject getArrayIdx(MemObjects mobjs, String word) {
        MyUtil.ArrayObject retval = new MyUtil.ArrayObject();
        char[] cas = word.toCharArray();
        int index = 0;
        int start = -1;
        int kstart = 0;
        int ksend = 0;
        while (index < cas.length) {
            if (cas[index] == '[') {
                if (start < 0) {
                    start = index + 1;
                }
                ++kstart;
            } else if (cas[index] == ']') {
                if (kstart - ++ksend > 0) {
                    ++index;
                    continue;
                }
                String[] outidx = MemObjArray.cntArraySize(cas, start, index);
                if (outidx == null) {
                    return null;
                }
                CtoErlangTrans cet = MemObjArray.convertCtoErlangTr(mobjs, outidx);
                Element ele = Element.newInstanceBase(cet);
                if (ele == null) {
                    ele = cet.getMemObj() != null ? new Element(cet.getMemObj()) : new Element(cet.getString());
                }
                retval.add(ele);
                kstart = 0;
                ksend = 0;
                start = -1;
            } else if (kstart > 0) {
                // empty if block
            }
            ++index;
        }
        return retval;
    }

    public static MemObjArray instance(String word) {
        StringBuffer synm = new StringBuffer();
        MemObjArray retval = null;
        char[] cas = word.toCharArray();
        int start = -1;
        for (int index = 0; index < cas.length; ++index) {
            if (cas[index] == '[') {
                if (synm.length() == 0) {
                    return null;
                }
                start = index + 1;
                continue;
            }
            if (cas[index] == ']') {
                if (start < index) {
                    String[] outidx;
                    if (retval == null) {
                        retval = new MemObjArray();
                    }
                    if ((outidx = MemObjArray.cntArraySize(cas, start, index)) == null) {
                        return null;
                    }
                    retval.arraynest.add(MemObjArray.margeStringArray(outidx));
                }
                if (index + 1 == cas.length || cas[index + 1] != '[') break;
                start = index;
                continue;
            }
            if (start >= 0) continue;
            synm.append(cas[index]);
        }
        if (retval != null) {
            retval.name = synm.toString();
        }
        return retval;
    }

    private static String margeStringArray(String[] words) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            retval.append(words[i]);
            if (i + 1 >= words.length) continue;
            retval.append(" ");
        }
        return retval.toString();
    }

    private static CtoErlangTrans convertCtoErlangTr(MemObjects mobjs, String[] words) {
        CtoErlangTrans tmp = null;
        CtoErlangTrans retval = null;
        for (int i = 0; i < words.length; ++i) {
            MemObject mo = mobjs.getMemObjectFromAll(words[i]);
            tmp = mo != null ? new CtoErlangTrans(mo) : new CtoErlangTrans(words[i]);
            if (retval == null) {
                retval = tmp;
                continue;
            }
            retval.addnext(tmp);
        }
        return retval;
    }

    private static String[] cntArraySize(char[] cas, int start, int end) {
        char[] ncas = new char[end - start];
        System.arraycopy(cas, start, ncas, 0, end - start);
        int nstart = 0;
        for (int i = 0; i < ncas.length; ++i) {
            if (ncas[i] != ']') continue;
            nstart = i + 1;
        }
        String[] words = WRwSplitChars.splitWordchar(ncas, nstart, ncas.length);
        if (words.length == 0) {
            words = new String[]{ErlangCreator.cnvertNum(new String(ncas))};
        } else {
            for (int i = 0; i < words.length; ++i) {
                words[i] = ErlangCreator.cnvertNum(words[i]);
            }
        }
        return words;
    }

    public boolean setdefault(int[] idx, String val) {
        if (idx == null) {
            return false;
        }
        Defaultval setdfv = this.getCreateDfv(idx);
        if (setdfv.child != null) {
            return false;
        }
        setdfv.val = val;
        return true;
    }

    private Defaultval getDfv(int[] idx) {
        Defaultval retval = null;
        int srnest = 0;
        Defaultval loop = this.toparray;
        while (loop != null && srnest < idx.length) {
            int currentidx = idx[srnest++];
            for (int i = 0; i < currentidx; ++i) {
                loop = loop.nextidx;
            }
            if (loop == null) {
                return null;
            }
            retval = loop;
            loop = loop.child;
        }
        return retval;
    }

    private Defaultval getCreateDfv(int[] idx) {
        int srnest = 0;
        Defaultval retval = null;
        Defaultval loop = this.toparray;
        while (loop != null && srnest < idx.length) {
            int currentidx;
            Defaultval tmp;
            if ((tmp = loop.getnextidx(currentidx = idx[srnest++])) == null) {
                loop.addnextidx(currentidx);
            }
            retval = tmp = loop.getnextidx(currentidx);
            if (srnest < idx.length && tmp.child == null) {
                tmp.addchild();
                loop = tmp.child;
                continue;
            }
            loop = tmp.child;
        }
        return retval;
    }

    public String getInitval() {
        if (this.toparray == null) {
            return null;
        }
        return this.toparray.toErlang();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemObjArray)) {
            return false;
        }
        MemObjArray in = (MemObjArray)obj;
        if (!this.name.equals(in.name)) {
            return false;
        }
        return this.arraynest.size() == in.arraynest.size();
    }

    private class Defaultval
    implements Serializable {
        private int noof = 0;
        private static final long serialVersionUID = 201003050009000002L;
        private String val;
        private Defaultval child;
        private Defaultval nextidx;

        private Defaultval() {
        }

        private Defaultval(String defval) {
            this.val = defval;
        }

        private void addnextidx(int idx) {
            Defaultval tmp = this;
            for (int count = 0; count < idx; ++count) {
                if (tmp.nextidx == null) {
                    tmp.nextidx = new Defaultval();
                    this.noof = idx;
                }
                tmp = tmp.nextidx;
            }
        }

        private Defaultval getnextidx(int idx) {
            Defaultval tmp = this;
            Defaultval ret = null;
            int retidx = 0;
            while (tmp != null) {
                ret = tmp;
                if (retidx == idx) {
                    return ret;
                }
                tmp = tmp.nextidx;
                ++retidx;
            }
            return null;
        }

        private void addchild() {
            Defaultval tmp = this;
            Defaultval ret = null;
            while (tmp != null) {
                ret = tmp;
                tmp = tmp.child;
            }
            ret.child = new Defaultval();
        }

        private void setSize(int size) {
            if (this.noof != 0) {
                return;
            }
            Defaultval setdfv = this;
            this.noof = size;
            for (int i = 0; i < this.noof; ++i) {
                setdfv.nextidx = new Defaultval();
            }
        }

        private void addChild(int size) {
            Defaultval setdfv = this;
            while (setdfv != null) {
                setdfv.child = new Defaultval();
                setdfv.child.setSize(size);
                setdfv = setdfv.nextidx;
            }
        }

        private String toErlang() {
            boolean edit = false;
            StringBuffer retval = new StringBuffer();
            retval.append("[");
            Defaultval setdfv = this;
            while (setdfv != null) {
                String out = null;
                out = setdfv.child != null ? setdfv.child.toErlang() : setdfv.val;
                if (out == null) {
                    setdfv = setdfv.nextidx;
                    continue;
                }
                if (edit) {
                    retval.append(",");
                }
                edit = true;
                retval.append(out);
                setdfv = setdfv.nextidx;
            }
            retval.append("]");
            if (edit) {
                return retval.toString();
            }
            return null;
        }
    }
}

