/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import analyzecodeC.decode.EnumTypeData;
import analyzecodeC.decode.MemObjArray;
import analyzecodeC.decode.MemObjRef;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.StructtypeData;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementBasic;
import analyzecodeC.erlang.ErlangCreator;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060006000001L;
    private int memid = 0;
    private EnumTypeData enumt;
    private String name;
    private MemObjArray arraydat;
    private MyUtil.ArrayObject arraygetidx;
    private MemObject parent;
    private MemObjects member;
    private String defultval = null;
    private StructtypeData structdat;
    private MyUtil.ArrayObject[] setvalue = new MyUtil.ArrayObject[5];
    private String[] setconj = new String[5];
    private MemObjRef[] setcond = new MemObjRef[5];
    private int appidx = -1;
    private int nowidx = 0;

    public MemObject(String name, int id) {
        this.name = name;
        this.memid = id;
        this.arraydat = MemObjArray.instance(name);
        if (this.arraydat != null) {
            this.name = this.arraydat.getName();
        }
    }

    public MemObject(String name, int id, StructtypeData struct) {
        this.memid = id;
        this.name = name;
        this.structdat = struct;
        try {
            this.member = (MemObjects)this.structdat.getMember().clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new Error();
        }
    }

    public MemObject(String name, int id, EnumTypeData etd) {
        this.memid = id;
        this.name = name;
        this.enumt = etd;
    }

    public int getMemid() {
        return this.memid;
    }

    public EnumTypeData getEnumt() {
        return this.enumt;
    }

    public String getSymble() {
        if (this.parent != null) {
            return this.parent.getName();
        }
        if (this.arraygetidx != null) {
            return null;
        }
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MemObjArray getArraydat() {
        return this.arraydat;
    }

    public boolean modify(ProcessKakko pk) {
        MemObjArray moa = this.getArraydat();
        if (this.getArraydat() == null) {
            return false;
        }
        String fname = pk.getScopname();
        String keyname = ErlangCreator.getErlArrayName(fname, this);
        moa.setArrayKey(keyname);
        return true;
    }

    public MyUtil.ArrayObject getArraygetidx() {
        return this.arraygetidx;
    }

    public void setArraygetidx(MyUtil.ArrayObject arraygetidx) {
        if (this.arraydat == null || arraygetidx == null) {
            return;
        }
        if (this.arraydat.getArrayNest().size() != arraygetidx.size()) {
            return;
        }
        this.arraygetidx = arraygetidx;
    }

    public MemObject getChild(String name) {
        MemObject retval = this.member.getMemObject(name);
        retval.parent = this;
        return retval;
    }

    public MemObject getParent() {
        return this.parent;
    }

    public String getDefaultKey() {
        if (this.structdat != null) {
            return this.structdat.getDefKey();
        }
        if (this.arraydat != null) {
            return "0";
        }
        return this.name;
    }

    public String getMyKey() {
        if (this.parent != null) {
            return this.parent.getMyKey() + "@" + this.name;
        }
        return this.name;
    }

    public String getDefaultVal() {
        if (this.structdat != null) {
            return this.structdat.getDefValue();
        }
        if (this.arraydat != null) {
            return this.getArrayDefault();
        }
        return this.defultval;
    }

    public void setStructDat(StructtypeData struct) {
        this.structdat = struct;
    }

    public StructtypeData getStructdat() {
        return this.structdat;
    }

    public String getArrayDefault() {
        String ret = null;
        if (this.arraydat != null) {
            String toerl = this.arraydat.getInitval();
            if (toerl == null) {
                return "";
            }
            StringBuffer retval = new StringBuffer();
            retval.append("lists:flatten(");
            retval.append(toerl);
            retval.append(")");
            ret = ErlangCreator.getErlArrayIni(this.arraydat.getArrayKey(), retval.toString());
            return ret;
        }
        return null;
    }

    public String getArrayVal() {
        StringBuffer retval = new StringBuffer();
        if (this.arraygetidx != null) {
            retval.append("gval_lookup(");
            retval.append(this.getArraydat().getArrayKey());
            retval.append(",");
            retval.append(this.getArrayIdxcal());
            retval.append(")");
            return retval.toString();
        }
        return this.getArrayDefault();
    }

    public Element getArrayIdxcalEl() {
        ArrayList<CtoErlangTrans> work = new ArrayList<CtoErlangTrans>();
        if (this.arraygetidx == null || this.arraydat == null) {
            return null;
        }
        ArrayList<String> nest = this.arraydat.getArrayNest();
        this.arraygetidx.first();
        while (this.arraygetidx.hasNext()) {
            Element idx = (Element)this.arraygetidx.next();
            int idxcu = this.arraygetidx.getLatestCursor();
            if (nest.size() > idxcu + 1) {
                int count = idxcu + 1;
                while (nest.size() > count) {
                    String size = nest.get(count++);
                    work.add(new CtoErlangTrans("(" + idx.toErlang() + ")"));
                    work.add(new CtoErlangTrans("*"));
                    work.add(new CtoErlangTrans("(" + size + ")"));
                    if (nest.size() <= count) continue;
                    work.add(new CtoErlangTrans("+"));
                }
                continue;
            }
            if (!work.isEmpty()) {
                work.add(new CtoErlangTrans("+"));
            }
            work.add(new CtoErlangTrans("(" + idx.toErlang() + ")"));
        }
        return ElementBasic.creBasic(work);
    }

    public String getArrayIdxcal() {
        Element el = this.getArrayIdxcalEl();
        return el == null ? "" : this.getArrayIdxcalEl().toErlang();
    }

    public ArrayList<MemObject> collectMemobj() {
        ArrayList<MemObject> output = new ArrayList<MemObject>();
        output.add(this);
        if (this.arraygetidx == null) {
            return output;
        }
        this.arraygetidx.first();
        while (this.arraygetidx.hasNext()) {
            Element idx = (Element)this.arraygetidx.next();
            idx.collectMemobj(output);
        }
        return output;
    }

    public String getSetArrayValFunc() {
        return "ets:insert";
    }

    public int getSetArrayParaSize() {
        return 2;
    }

    public String ctoErlnagVal(boolean atmflg) {
        StringBuffer retval = new StringBuffer();
        if (this.parent != null) {
            retval.append(this.parent.ctoErlnagVal(false));
            retval.append(".");
            retval.append(this.name);
            return retval.toString();
        }
        if (this.structdat == null) {
            if (atmflg) {
                return this.name;
            }
            String after = this.name.substring(1);
            String bef = this.name.substring(0, 1);
            bef = bef.toUpperCase();
            return bef + after;
        }
        return this.name;
    }

    public int getAppidx() {
        return this.appidx;
    }

    public void setSetConD(MemObjRef cond) {
        this.setcond[this.appidx] = cond;
    }

    public void setSetConj(String conj) {
        this.setconj[this.appidx] = conj;
    }

    public void addSetValue(SentPart addval) {
        if (this.setvalue[this.appidx] == null) {
            this.setvalue[this.appidx] = new MyUtil.ArrayObject();
        }
        if (this.defultval == null || this.defultval.equals("")) {
            this.defultval = addval.getWord();
        }
        this.setvalue[this.appidx].add(addval);
    }

    public boolean appendNewData() {
        if (this.appidx >= 0) {
            return false;
        }
        if (this.nowidx == this.setvalue.length) {
            this.updatarea();
        }
        this.appidx = this.nowidx++;
        return true;
    }

    public boolean commit() {
        int idx = this.getIdx();
        if (idx == this.appidx) {
            this.appidx = -1;
            return true;
        }
        return false;
    }

    public void canNewData() {
        if (this.appidx < 0) {
            return;
        }
        this.setvalue[this.appidx].clear();
        --this.nowidx;
        if (this.nowidx < 0) {
            this.nowidx = 0;
        }
        this.appidx = -1;
    }

    private void updatarea() {
        MyUtil.ArrayObject[] workao = new MyUtil.ArrayObject[this.setvalue.length + 5];
        System.arraycopy(this.setvalue, 0, workao, 0, this.setvalue.length);
        this.setvalue = workao;
        String[] works = new String[this.setconj.length + 5];
        System.arraycopy(this.setconj, 0, works, 0, this.setconj.length);
        this.setconj = works;
        MemObjRef[] workm = new MemObjRef[this.setcond.length + 5];
        System.arraycopy(this.setcond, 0, workm, 0, this.setcond.length);
        this.setcond = workm;
    }

    public int getIdx() {
        if (this.appidx < 0) {
            return -1;
        }
        return this.getIdx(this.setcond[this.appidx], this.setvalue[this.appidx], this.setconj[this.appidx]);
    }

    private int getIdx(MemObjRef addcond, MyUtil.ArrayObject value, String conj) {
        for (int i = 0; i < this.nowidx; ++i) {
            if (!(this.setcond[i] == addcond ? this.setvalue[i] != null && this.setvalue[i].equals(value) && this.setconj[i] != null && this.setconj[i].equals(conj) : this.setcond[i] != null && this.setcond[i].equals(addcond) && this.setvalue[i] != null && this.setvalue[i].equals(value) && this.setconj[i] != null && this.setconj[i].equals(conj))) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[" + this.getMyKey() + "]");
        if (this.arraydat != null) {
            retval.append("[array]");
        }
        return retval.toString();
    }

    public MemObject getcopy() {
        try {
            return (MemObject)this.clone();
        }
        catch (CloneNotSupportedException cns) {
            throw new Error();
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemObject)) {
            return false;
        }
        MemObject inobj = (MemObject)obj;
        if (!(this.chkObject(this.arraydat, inobj.arraydat) && this.chkObject(this.arraygetidx, inobj.arraygetidx) && this.chkObject(this.defultval, inobj.defultval) && this.chkObject(this.member, inobj.member) && this.chkObject(this.name, inobj.name) && this.chkObject(this.parent, inobj.parent) && this.chkObject(this.structdat, inobj.structdat))) {
            return false;
        }
        return this.nowidx == inobj.nowidx;
    }

    private boolean chkObject(Object a, Object b) {
        if (a != null && b == null) {
            return false;
        }
        if (a == null && b != null) {
            return false;
        }
        return a == null || a.equals(b);
    }
}

