/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import analyzecodeC.WRwSplitChars;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.EnumTypeData;
import analyzecodeC.decode.MemObjArray;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemToProBlTrans;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.StructtypeData;
import analyzecodeC.erlang.ErlangCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemObjects
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060003000001L;
    private ProcessKakko kakko;
    private int mobjscnt = 0;
    private HashMap<String, MemObject> mobjs = new HashMap();
    private HashMap<String, MemObject> extmobjs = new HashMap();
    private int state = 0;
    private boolean retind = true;
    private transient MemToProBlTrans retvaltmp;
    private transient MemObject tmpMObj = null;
    private transient MyUtil.PrimitiveArrayI state4tmp;
    private transient ArrayList<SentPart> tmpstate11;
    private transient boolean tmpstate11addind = false;
    private transient boolean tmpstate11primhit = false;
    private transient EnumTypeData tmpetd;
    private StructtypeData stucttype;
    private static final int SPECIAL_NO11 = 11;
    private static final int SPECIAL_NO12 = 12;
    private static final int SPECIAL_NO21 = 21;
    private static final int SPECIAL_NO22 = 22;
    private static final int SPECIAL_NO23 = 23;
    private transient StructtypeData tmpstate22;
    private String endword = null;
    private String endconj = null;

    public static MemObjects forTestInstace() {
        throw new IllegalAccessError();
    }

    public void setKakko(ProcessKakko in) {
        this.kakko = in;
    }

    public HashMap<String, MemObject> getExtmobjs() {
        return this.extmobjs;
    }

    public boolean isExtMo(String sym) {
        return MemObjects.getMemobject(this.extmobjs, sym) != null;
    }

    public MemObject getMemObjectFromAll(String valname) {
        MemObject retval;
        String array = MemObjArray.getArraySymName(valname);
        MyUtil.ArrayObject arrayidx = null;
        if (array != null) {
            arrayidx = MemObjArray.getArrayIdx(this, valname);
            valname = array;
        }
        if ((retval = this.getMemObject(valname)) != null) {
            try {
                MemObject clretval = (MemObject)retval.clone();
                clretval.setArraygetidx(arrayidx);
                return clretval;
            }
            catch (CloneNotSupportedException cn) {
                throw new Error("MemObject clone error");
            }
        }
        retval = this.extmobjs.get(valname);
        if (retval != null && retval instanceof MemObject) {
            try {
                MemObject clretval = (MemObject)retval.clone();
                clretval.setArraygetidx(arrayidx);
                return clretval;
            }
            catch (CloneNotSupportedException cn) {
                throw new Error("MemObject clone error2");
            }
        }
        if (this.kakko != null && this.kakko.getParas() != null && (retval = this.kakko.getParas().mobjs.get(valname)) != null && retval instanceof MemObject) {
            try {
                MemObject clretval = (MemObject)retval.clone();
                clretval.setArraygetidx(arrayidx);
                return clretval;
            }
            catch (CloneNotSupportedException cn) {
                throw new Error("MemObject clone error3");
            }
        }
        return retval;
    }

    private static MemObject getMemobject(HashMap<String, MemObject> mos, String valname) {
        String[] split = valname.split("@");
        MemObject retval = null;
        if (split.length == 1) {
            return mos.get(valname);
        }
        for (int i = 0; i < split.length; i += 2) {
            retval = mos.get(split[i]);
            if (i + 1 >= split.length) continue;
            retval = retval.getChild(split[i + 1]);
        }
        return retval;
    }

    public MemObject getMemObject(String valname) {
        return MemObjects.getMemobject(this.mobjs, valname);
    }

    public void getMemObjects(Map<String, MemObject> output) {
        output.putAll(this.mobjs);
    }

    public void putExtMemFromIn(MemObjects input) {
        this.extmobjs.putAll(input.mobjs);
    }

    public String getExtMemKeysCVS() {
        StringBuffer retval = new StringBuffer();
        Collection<MemObject> cl = this.extmobjs.values();
        Iterator<MemObject> it = cl.iterator();
        while (it.hasNext()) {
            MemObject mo = it.next();
            retval.append(mo.getDefaultKey());
            if (!it.hasNext()) continue;
            retval.append(",");
        }
        return retval.toString();
    }

    public String getArrayNameListCVS() {
        ArrayList<MemObject> out = new ArrayList<MemObject>();
        this.getArrayMemObjs(out);
        String retval = MemObjects.getSymbCvs(out);
        return retval;
    }

    public String getExtMemNameListCVS() {
        Collection<MemObject> cl = this.extmobjs.values();
        String retval2 = MemObjects.getSymbCvs(cl);
        return retval2;
    }

    private static String getSymbCvs(Collection cl) {
        StringBuffer retval = new StringBuffer();
        Iterator it = cl.iterator();
        while (it.hasNext()) {
            MemObject mo = (MemObject)it.next();
            if (mo.getArraydat() != null) {
                retval.append(mo.getArraydat().getArrayKey());
            } else {
                retval.append(mo.getName());
            }
            if (!it.hasNext()) continue;
            retval.append(",");
        }
        return retval.toString();
    }

    public String getArrayMemDefCVS() {
        ArrayList<MemObject> out = new ArrayList<MemObject>();
        this.getArrayMemObjs(out);
        Collection<MemObject> cl = this.extmobjs.values();
        out.addAll(cl);
        return MemObjects.getDefValCVS(out);
    }

    public String getExtMemDefCVS() {
        Collection<MemObject> cl = this.extmobjs.values();
        return MemObjects.getDefValCVS(cl);
    }

    private static String getDefValCVS(Collection cl) {
        StringBuffer retval = new StringBuffer();
        Iterator it = cl.iterator();
        while (it.hasNext()) {
            MemObject mo = (MemObject)it.next();
            retval.append(mo.getDefaultVal());
            if (!it.hasNext()) continue;
            retval.append(",");
        }
        return retval.toString();
    }

    public MemToProBlTrans exeStateTrans(SentPart sp) {
        MemToProBlTrans retval = null;
        this.retvaltmp = new MemToProBlTrans();
        this.retind = false;
        block15: while (!this.retind) {
            this.retind = true;
            switch (this.state) {
                case 0: {
                    retval = this.state0_idle(sp);
                    continue block15;
                }
                case 1: {
                    retval = this.state1_primval(sp);
                    continue block15;
                }
                case 2: {
                    retval = this.state2_primval(sp);
                    continue block15;
                }
                case 3: {
                    retval = this.state3_primval(sp);
                    continue block15;
                }
                case 4: {
                    retval = this.state4_primval(sp);
                    continue block15;
                }
                case 11: {
                    retval = this.state11_primval(sp);
                    continue block15;
                }
                case 12: {
                    retval = this.state12_primval(sp);
                    continue block15;
                }
                case 51: {
                    retval = this.state51_primval(sp);
                    continue block15;
                }
                case 21: {
                    retval = this.state21_struct(sp);
                    continue block15;
                }
                case 22: {
                    retval = this.state22_struct(sp);
                    continue block15;
                }
                case 23: {
                    retval = this.state23_struct(sp);
                    continue block15;
                }
                case 41: {
                    retval = this.state41(sp);
                    continue block15;
                }
                case 100: {
                    retval = this.state100(sp);
                    continue block15;
                }
            }
            throw new IllegalAccessError();
        }
        return this.retvaltmp.getRetVal(this.tmpMObj, sp);
    }

    private MemToProBlTrans state0_idle(SentPart sp) {
        this.retind = true;
        if (WordSystemRev.isSysWord(sp)) {
            if (WordSystemRev.isPrimTypeWord(sp)) {
                if (WordSystemRev.isEnum(sp)) {
                    this.tmpetd = new EnumTypeData(this.kakko.getEnumdats());
                    this.state = 12;
                    this.retind = false;
                } else {
                    this.state = 1;
                }
            } else if (WordSystemRev.isTyeDef(sp)) {
                this.state = 11;
                this.tmpstate11 = new ArrayList();
            } else if (WordSystemRev.isUnionStruct(sp)) {
                this.state = 21;
            } else if (WordSystemRev.isStructTypeWord(sp) || WordSystemRev.isStructTypeSwitch(sp.getWord())) {
                this.state = 0;
            } else if (WordSystemRev.isStructType2Word(sp.getWord())) {
                this.endconj = ";";
                this.endword = null;
                this.state = 100;
                this.retind = false;
            } else {
                this.retvaltmp.setMemToProBlTrans(new SentPart("", ""));
            }
        } else {
            String word = sp.getWord();
            if (word == null || word.equals("") || word.equals(" ")) {
                return null;
            }
            if (word.charAt(0) == '\"') {
                return null;
            }
            MemObject geto = this.getMemObjectFromAll(word = ErlangCreator.cnvertNum(word));
            if (geto != null) {
                String conj = sp.getConjunc();
                if (conj != null && conj.equals(".")) {
                    this.tmpMObj = geto;
                    this.state = 41;
                    return null;
                }
                this.tmpMObj = geto;
                this.state = 2;
                this.retind = false;
            } else {
                String val;
                SentPart[] tmpgetsps = WordSystemRev.getTypeDefSps(this.kakko.getExtracysword(), sp);
                if (tmpgetsps != null) {
                    int i;
                    for (i = 0; i < tmpgetsps.length; ++i) {
                        this.exeStateTrans(tmpgetsps[i]);
                    }
                    this.retvaltmp.setMemToProBlTrans(tmpgetsps[0]);
                    for (i = 1; i < tmpgetsps.length; ++i) {
                        this.retvaltmp.addNext(tmpgetsps[i]);
                    }
                } else if (this.tmpetd != null && (val = this.tmpetd.getValue(word)) != null) {
                    sp.setWord(val);
                    this.exeStateTrans(sp);
                    this.retvaltmp.setMemToProBlTrans(sp);
                }
            }
        }
        return null;
    }

    private MemToProBlTrans state1_primval(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            this.retind = false;
            return null;
        }
        String word = sp.getWord();
        if (word == null || word.equals("") || word.equals(" ")) {
            if (sp.getConjunc().equals(";")) {
                this.crearFunc();
                return null;
            }
            return null;
        }
        this.tmpMObj = new MemObject(word, this.mobjscnt++);
        this.tmpMObj.modify(this.kakko);
        this.mobjs.put(this.tmpMObj.getMyKey(), this.tmpMObj);
        this.state = 2;
        this.retind = false;
        return null;
    }

    private MemToProBlTrans state2_primval(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            this.tmpMObj = null;
            return null;
        }
        String conj = sp.getConjunc();
        if (conj == null || conj.equals("") || conj.equals(" ") || conj.equals("\n")) {
            return null;
        }
        if (WRwSplitChars.isSettoMark(conj)) {
            if (!this.tmpMObj.appendNewData()) {
                throw new NullPointerException();
            }
            if (this.tmpMObj.getArraygetidx() != null) {
                this.tmpMObj.getDefaultVal();
            }
            this.tmpMObj.setSetConj(conj);
            this.state = 3;
            this.retvaltmp.setMemToProBlTrans(this.tmpMObj, conj);
            return null;
        }
        if (WRwSplitChars.isKakkoStart(conj)) {
            this.mobjs.remove(this.tmpMObj.getMyKey());
            this.endconj = ")";
            this.endword = null;
            this.state = 100;
            this.tmpMObj = null;
        } else {
            this.tmpMObj.canNewData();
            this.retvaltmp.setMemToProBlTrans(this.tmpMObj, conj);
            this.crearFunc();
            if (WRwSplitChars.isKanma(conj)) {
                this.state = 1;
            }
        }
        return null;
    }

    private MemToProBlTrans state3_primval(SentPart sp) {
        String conj;
        if (WordSystemRev.isSysWord(sp)) {
            return this.crearFunc();
        }
        MemObject geto = null;
        String word = sp.getWord();
        if (word != null && !word.equals("") && !word.equals(" ")) {
            geto = this.getMemObjectFromAll(word);
        }
        if (!(conj = sp.getConjunc()).equals(";")) {
            if (conj.equals("{")) {
                this.state4tmp = new MyUtil.PrimitiveArrayI();
                this.state4tmp.add(0);
                this.state = 4;
                return null;
            }
            this.tmpMObj.addSetValue(sp);
            if (geto == null || conj.equals("(")) {
                this.retvaltmp.setMemToProBlTrans(sp);
            } else {
                this.retvaltmp.setMemToProBlTrans(geto, conj);
            }
            return null;
        }
        this.tmpMObj.addSetValue(sp);
        int idx = this.tmpMObj.getAppidx();
        if (!this.tmpMObj.commit()) {
            this.tmpMObj.canNewData();
            return this.crearFunc();
        }
        if (geto == null) {
            this.retvaltmp.setMemToProBlTrans(sp);
        } else {
            this.retvaltmp.setMemToProBlTrans(geto, conj);
        }
        this.crearFunc();
        return null;
    }

    private MemToProBlTrans state4_primval(SentPart sp) {
        String word = sp.getWord();
        String conj = sp.getConjunc();
        if (word == null || word.equals("") || word.equals(" ")) {
            if (conj.equals("") || conj.equals(" ")) {
                return null;
            }
        } else {
            int[] arrayidx = this.state4tmp.toArray();
            this.tmpMObj.getArraydat().setdefault(arrayidx, word);
        }
        if (conj != null) {
            if (conj.equals(",")) {
                int now = this.state4tmp.getValue(this.state4tmp.size() - 1);
                this.state4tmp.setValue(this.state4tmp.size() - 1, now + 1);
            } else if (conj.equals("}")) {
                this.state4tmp.remove(this.state4tmp.size() - 1);
            } else if (conj.equals("{")) {
                this.state4tmp.add(0);
            }
        }
        if (this.state4tmp.isEmpty()) {
            sp.setWord(this.tmpMObj.getArrayDefault());
            sp.setConjunc("");
            this.retvaltmp.setMemToProBlTrans(sp);
            this.state = 3;
            this.state4tmp = null;
        }
        return null;
    }

    private MemToProBlTrans state11_primval(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.tmpstate11primhit = true;
            this.tmpstate11.clear();
            if (WordSystemRev.isPrimTypeWord(sp)) {
                if (WordSystemRev.isEnum(sp)) {
                    this.tmpstate11addind = true;
                }
                this.tmpstate11.add(sp);
            } else if (WordSystemRev.isUnionStruct(sp)) {
                this.tmpstate11addind = true;
                this.tmpstate11.add(sp);
            }
        } else {
            SentPart[] tmpgetsps = WordSystemRev.getTypeDefSps(this.kakko.getExtracysword(), sp);
            if (tmpgetsps != null) {
                for (int i = 0; i < tmpgetsps.length; ++i) {
                    this.tmpstate11.add(tmpgetsps[i]);
                }
                if (sp.getConjunc().equals(";")) {
                    throw new Error();
                }
            } else {
                if (this.tmpstate11addind && sp.getWord() != null) {
                    this.tmpstate11.add(sp);
                    this.tmpstate11addind = false;
                }
                if (sp.getConjunc().equals(";")) {
                    this.tmpstate11.add(sp);
                    WordSystemRev.addExtCsWord(this.kakko.getExtracysword(), this.tmpstate11);
                    this.tmpstate11primhit = false;
                    this.state = 0;
                } else if (!this.tmpstate11primhit) {
                    this.tmpstate11.add(sp);
                }
            }
        }
        return null;
    }

    private MemToProBlTrans state12_primval(SentPart sp) {
        this.retind = true;
        if (this.tmpetd.exeStateTrans(sp)) {
            this.retvaltmp.onNullind();
        } else {
            this.tmpetd = this.tmpetd.getUsedat();
            if (this.tmpetd != null) {
                this.retvaltmp.onNullind();
                this.state = 1;
            } else {
                this.state = 0;
            }
        }
        return null;
    }

    private MemToProBlTrans state51_primval(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            return null;
        }
        if (sp.getWord() == null || sp.getWord().equals("")) {
            return null;
        }
        String word = sp.getWord();
        this.tmpMObj = this.getMemObjectFromAll(word);
        this.state = 2;
        this.retind = false;
        return null;
    }

    private MemToProBlTrans state21_struct(SentPart sp) {
        this.stucttype = new StructtypeData(this.kakko.getStructdats());
        this.stucttype.setPk(this.kakko);
        this.state = 22;
        this.retind = false;
        return null;
    }

    private MemToProBlTrans state22_struct(SentPart sp) {
        if (this.stucttype.exeStateTrans(sp)) {
            return null;
        }
        this.tmpstate22 = this.stucttype.getUseStruct();
        if (this.tmpstate22 != null) {
            this.state = 23;
            this.retind = false;
        } else {
            this.stucttype = null;
            this.state = 0;
        }
        return null;
    }

    private MemToProBlTrans state23_struct(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            return null;
        }
        if (sp.getWord() == null || sp.getWord().equals("")) {
            return null;
        }
        String word = sp.getWord();
        MemObject mobj = this.tmpstate22.getNewInstance(word, this.mobjscnt++);
        this.mobjs.put(mobj.getMyKey(), mobj);
        this.state = 0;
        this.retind = false;
        return null;
    }

    private MemToProBlTrans state41(SentPart sp) {
        MemObject moj;
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            this.retind = false;
            return null;
        }
        String word = sp.getWord();
        if (word == null || word.equals("") || word.equals(" ")) {
            this.state = 0;
            return null;
        }
        this.tmpMObj = moj = this.tmpMObj.getChild(word);
        String conj = sp.getConjunc();
        if (conj != null && conj.equals(".")) {
            return null;
        }
        this.state = 2;
        this.retind = false;
        return null;
    }

    private MemToProBlTrans state100(SentPart sp) {
        MemObject out = this.getMemObjectFromAll(sp.getWord());
        if (out != null) {
            this.retvaltmp.setMemToProBlTrans(out, sp.getConjunc());
        }
        if (sp.contain(this.endword, this.endconj)) {
            this.state = 0;
            this.endword = null;
            this.endconj = null;
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        MemObjects retval = (MemObjects)super.clone();
        retval.mobjs = (HashMap)this.mobjs.clone();
        return retval;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemObjects other = (MemObjects)obj;
        if (!(this.kakko == other.kakko || this.kakko != null && this.kakko.equals(other.kakko))) {
            return false;
        }
        if (this.mobjscnt != other.mobjscnt) {
            return false;
        }
        if (!(this.mobjs == other.mobjs || this.mobjs != null && this.mobjs.equals(other.mobjs))) {
            return false;
        }
        if (!(this.extmobjs == other.extmobjs || this.extmobjs != null && this.extmobjs.equals(other.extmobjs))) {
            return false;
        }
        return this.stucttype == other.stucttype || this.stucttype != null && this.stucttype.equals(other.stucttype);
    }

    private MemToProBlTrans crearFunc() {
        this.state = 0;
        this.tmpMObj = null;
        this.retind = true;
        this.tmpetd = null;
        this.tmpstate11primhit = false;
        return null;
    }

    public boolean isIgnoring() {
        return this.state == 21 || this.state == 22 || this.state == 11 || this.state == 12 || this.state == 23;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("Ext=");
        Collection<MemObject> co = this.extmobjs.values();
        for (MemObject mo : co) {
            retval.append(mo.getName());
            retval.append("");
        }
        retval.append("\n");
        retval.append("INMem=");
        co = this.mobjs.values();
        for (MemObject mo : co) {
            retval.append(mo.getName());
            retval.append(" ");
        }
        retval.append("\n");
        return retval.toString();
    }

    public boolean hasArrayMemObjs() {
        Collection<MemObject> co = this.mobjs.values();
        for (MemObject mo : co) {
            if (mo.getArraydat() == null) continue;
            return true;
        }
        return false;
    }

    public MemObject[] getArrayMemObjs() {
        ArrayList<MemObject> out = new ArrayList<MemObject>();
        this.getArrayMemObjs(out);
        MemObject[] retval = new MemObject[out.size()];
        out.toArray(retval);
        return retval;
    }

    private void getArrayMemObjs(ArrayList<MemObject> out) {
        Collection<MemObject> co = this.mobjs.values();
        for (MemObject mo : co) {
            if (mo.getArraydat() == null) continue;
            out.add(mo);
        }
    }

    public String[] sortRamdaparaNames(String[] innames) {
        MyUtil.PrimitiveArrayII worki = new MyUtil.PrimitiveArrayII();
        for (int i = 0; i < innames.length; ++i) {
            MemObject mo;
            MemObject memObject = mo = this.kakko != null ? this.getMemObjectFromAll(innames[i]) : this.getMemObject(innames[i]);
            if (mo == null) continue;
            worki.addSort(mo.getMemid(), i);
        }
        String[] retval = new String[worki.size()];
        int reti = 0;
        worki.first();
        while (worki.hasNext()) {
            worki.nextIdxKey();
            int idx = worki.latestValue();
            retval[reti++] = innames[idx];
        }
        return retval;
    }
}

