/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.SentPart;
import analyzecodeC.WRwSplitChars;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.LoopBlock;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemToProBlTrans;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.StructBlock;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementBasic;
import analyzecodeC.erlang.ElementGuard;
import analyzecodeC.erlang.ElementLoop;
import analyzecodeC.erlang.Guardtype;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ProcessBlock
implements Comparable,
Serializable {
    private static final long serialVersionUID = 201002060002000001L;
    private ProcessKakko pk;
    private int state = 0;
    private int subnest = 0;
    private int nest = 0;
    private boolean retind = true;
    private ArrayList<OneLine> block = new ArrayList();
    private OneLine line = new OneLine();
    private int blockno = -1;
    private int caseno = 0;
    private boolean elseifsubnestind = false;
    private String endword = null;
    private String endconj = null;
    private InputMemnames allinput;
    private ProcessBlock nextnest;

    public ProcessBlock(ProcessKakko prokakko) {
        this.pk = prokakko;
    }

    public ProcessBlock(int nest, ProcessKakko prokakko) {
        this.nest = nest;
        this.pk = prokakko;
    }

    public ProcessKakko getPk() {
        return this.pk;
    }

    public int getNest() {
        return this.nest;
    }

    public int getSubNest() {
        return this.subnest;
    }

    public int getBlockno() {
        return this.blockno;
    }

    public void setBlockno(int no) {
        this.blockno = no;
    }

    public int getCaseno() {
        return this.caseno;
    }

    public void setCaseno(int caseno) {
        this.caseno = caseno;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ProcessBlock)) {
            throw new ClassCastException();
        }
        ProcessBlock pb = (ProcessBlock)o;
        if (this.getBlockno() == pb.getBlockno()) {
            return 0;
        }
        if (this.getBlockno() > pb.getBlockno()) {
            return -1;
        }
        return 1;
    }

    public boolean isLoop() {
        if (this.block.isEmpty()) {
            return false;
        }
        return this.block.get(0).getTop().isLoop();
    }

    public boolean isSwitch() {
        if (this.block.isEmpty()) {
            return false;
        }
        return this.block.get(0).getTop().isInSwitch();
    }

    public boolean containDefault() {
        for (OneLine ol : this.block) {
            if (!ol.getTop().tick.equals(WordSystemRev.getDefault())) continue;
            return true;
        }
        return false;
    }

    public boolean isElse() {
        return this.isCondition() && !this.block.isEmpty() && this.block.get(0).getTop().tick.equals(WordSystemRev.getElse());
    }

    public boolean isElseIf() {
        if (!this.isElse()) {
            return false;
        }
        if (this.block.size() < 2) {
            return false;
        }
        return WordSystemRev.isStructTypeWord(this.block.get(1).getTop().tick);
    }

    public boolean isCondition() {
        if (this.block.isEmpty()) {
            if (this.line != null && this.line.getTop() != null) {
                return this.line.getTop().isCondition();
            }
            return false;
        }
        return this.block.get(0).getTop().isCondition();
    }

    public CtoErlangTrans[] getLines() {
        CtoErlangTrans[] retval = new CtoErlangTrans[this.block.size()];
        int cnt = 0;
        for (OneLine ol : this.block) {
            retval[cnt++] = ol.getLine();
        }
        return retval;
    }

    public BasicBlock getBasicBlock() {
        if (this.block.isEmpty()) {
            return new BasicBlock();
        }
        if (this.isSwitch()) {
            return this.getBasicBlockSwitch();
        }
        BasicBlock retval = new BasicBlock();
        Iterator<OneLine> it = this.block.iterator();
        while (it.hasNext()) {
            OneLine ol = it.next();
            if (!ol.getTop().isCondition() && !ol.getTop().isInSwitch()) {
                Element el = Element.newInstanceBase(ol.getLine());
                if (el == null) continue;
                retval.addLine(el);
                continue;
            }
            if (!ol.getTop().isLoop()) continue;
            CtoErlangTrans cet = ol.getLine();
            int offset = ElementLoop.getBBtopOffset(cet);
            for (int i = 1; i < offset; ++i) {
                it.next();
            }
        }
        if (this.isCondition()) {
            retval.setCasenos(this.caseno + 1);
        }
        return retval;
    }

    public BasicBlock getBasicBlockSwitch() {
        if (!this.isSwitch()) {
            throw new Error();
        }
        if (this.block.isEmpty()) {
            return null;
        }
        int size = this.setSwitchCaseval();
        BasicBlock[] retwrok = new BasicBlock[size];
        for (int i = 0; i < size; ++i) {
            retwrok[i] = new BasicBlock();
            if (i <= 0) continue;
            retwrok[i - 1].setNextLink(retwrok[i]);
        }
        BasicBlock retval = retwrok[0];
        int idx = -1;
        for (OneLine ol : this.block) {
            Element el;
            if (ol.switchcaseval >= 0) {
                retwrok[++idx].setCasenos(ol.switchcaseval);
            }
            if (ol.getTop().isStrcType2()) {
                for (int j = idx; j >= 0; --j) {
                    retwrok[j] = null;
                }
            }
            if (ol.getTop().isCondition() || ol.getTop().isInSwitch() || (el = Element.newInstanceBase(ol.getLine())) == null) continue;
            for (int j = idx; j >= 0; --j) {
                if (retwrok[j] == null) continue;
                retwrok[j].addLine(el);
            }
        }
        return retval;
    }

    private int setSwitchCaseval() {
        int strretval = 1;
        boolean beforcase = false;
        boolean beforbase = false;
        OneLine defaultol = null;
        for (OneLine ol : this.block) {
            if (!ol.getTop().isInSwitch()) {
                beforbase = true;
                continue;
            }
            if (ElementGuard.isBreak(ol.getTop().tick)) {
                beforcase = false;
                beforbase = false;
                if (defaultol != null) continue;
                ++strretval;
                continue;
            }
            if (ElementGuard.isDefault(ol.getTop().tick)) {
                defaultol = ol;
                ol.switchcaseval = strretval;
                return strretval;
            }
            if (!ElementGuard.isCase(ol.getTop().tick)) continue;
            if (beforcase && beforbase) {
                ++strretval;
            }
            ol.switchcaseval = strretval;
            beforbase = false;
            beforcase = true;
        }
        if (beforcase) {
            return strretval;
        }
        return strretval - 1;
    }

    public StructBlock getStructSwitchBlock(StructBlock retval) {
        if (!this.isSwitch()) {
            throw new Error();
        }
        Element bef = null;
        this.setSwitchCaseval();
        for (OneLine ol : this.block) {
            Element el;
            if (!ol.getTop().isInSwitch() || (el = Element.newInstanceGuard(ol.getLine())) == null) continue;
            if (ol.switchcaseval >= 0) {
                ((ElementGuard)el).setStrretval(ol.switchcaseval);
            }
            if (bef instanceof ElementGuard) {
                ((ElementGuard)bef).setExpress(el);
                bef = el;
                continue;
            }
            if (bef != null) continue;
            retval.addLine(el);
            bef = el;
        }
        return retval;
    }

    public StructBlock getStructBlock(StructBlock retval, int funcrtval) {
        if (this.block.isEmpty()) {
            return null;
        }
        if (this.isSwitch()) {
            return this.getStructSwitchBlock(retval);
        }
        Element bef = null;
        for (OneLine ol : this.block) {
            Element el;
            if (!ol.getTop().isCondition() || (el = Element.newInstanceGuard(ol.getLine())) == null) continue;
            if (bef instanceof Guardtype) {
                ((Guardtype)((Object)bef)).setExpress(el);
            }
            bef = el;
            retval.addLine(el);
        }
        if (retval.isEmptyLine()) {
            return null;
        }
        Element ret = new Element();
        ret.setEleA(new Integer(funcrtval).toString());
        if (bef instanceof Guardtype) {
            ((Guardtype)((Object)bef)).setExpress(ret);
        }
        return retval;
    }

    public StructBlock getStructBlockDefault(StructBlock retval, int funcrtval) {
        ElementGuard bef = ElementGuard.creElementDefault();
        retval.addLine(bef);
        Element ret = new Element();
        ret.setEleA(new Integer(funcrtval).toString());
        bef.setExpress(ret);
        return retval;
    }

    public LoopBlock getLoopBlock() {
        CtoErlangTrans[] lines = this.getLines();
        LoopBlock getloop = LoopBlock.getLoopBlock(lines, this.getPk());
        return getloop;
    }

    public InputMemnames getInput(boolean struct) {
        InputMemnames retval = new InputMemnames();
        this.getInput(retval, struct);
        return retval;
    }

    public void getInput(InputMemnames retval, boolean struct) {
        for (OneLine ol : this.block) {
            if (!ol.getTop().isCondition() && struct || ol.getTop().isCondition() && !struct) continue;
            CtoErlangTrans cet = ol.getLine();
            retval.creInput(cet, this.pk);
        }
    }

    public ProcessBlock exeStateTrans(MemToProBlTrans mtob) {
        ProcessBlock retval = null;
        MemToProBlTrans exmtpb = mtob;
        while (exmtpb != null) {
            if (exmtpb.isEmpty()) {
                exmtpb = exmtpb.getNext();
                continue;
            }
            this.retind = false;
            while (!this.retind) {
                this.retind = true;
                switch (this.state) {
                    case 0: {
                        retval = this.state0(exmtpb);
                        break;
                    }
                    case 1: {
                        retval = this.state1(exmtpb);
                        break;
                    }
                    case 2: {
                        retval = this.state2(exmtpb);
                        break;
                    }
                    case 3: {
                        retval = this.state3(exmtpb);
                        break;
                    }
                    case 4: {
                        retval = this.state4(exmtpb);
                        break;
                    }
                    case 10: {
                        retval = this.state10(exmtpb);
                        break;
                    }
                    case 100: {
                        retval = this.state100(exmtpb);
                        break;
                    }
                    default: {
                        throw new IllegalAccessError();
                    }
                }
                if (retval == null) continue;
                return retval;
            }
            exmtpb = exmtpb.getNext();
        }
        return null;
    }

    private ProcessBlock state0(MemToProBlTrans mtob) {
        this.retind = false;
        this.state = 1;
        switch (mtob.getWordDatatype()) {
            case 1: {
                this.line.addLine(mtob.getMemObj());
                return null;
            }
            case 0: {
                return null;
            }
            case 2: {
                this.retind = true;
                this.state = 2;
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                this.endword = null;
                this.endconj = "}";
                this.state = 100;
                return null;
            }
            case 5: {
                this.state = 0;
                this.retind = true;
                return this.newBlock(mtob);
            }
        }
        this.line.addLine(mtob.getSentPart().getWord());
        return null;
    }

    private ProcessBlock newBlock(MemToProBlTrans mtob) {
        if (!this.line.isEmpty()) {
            this.block.add(this.line);
        }
        ProcessBlock retval = null;
        if (this.isElse() && mtob.getSentPart().getWord().equals(WordSystemRev.getIf())) {
            ++this.nest;
            this.line = new OneLine();
            retval = this;
        } else {
            retval = new ProcessBlock(this.nest - this.subnest, this.pk);
        }
        retval.line.addLine(mtob.getSentPart().getWord());
        retval.state1(mtob);
        return retval != this ? retval : null;
    }

    private ProcessBlock newBlock2(MemToProBlTrans mtob) {
        ProcessBlock retval = new ProcessBlock(this.nest - this.subnest, this.pk);
        ProcessBlock out = retval.exeStateTrans(mtob);
        if (out != null) {
            throw new IllegalAccessError();
        }
        return retval;
    }

    private ProcessBlock state1(MemToProBlTrans mtob) {
        this.state = 0;
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent()) {
            return null;
        }
        if (conj.equals("{") && this.isCondition()) {
            ++this.nest;
        } else if (this.nest > 0 && conj.equals("}")) {
            ++this.subnest;
            if (this.isElseIf() && !this.elseifsubnestind) {
                this.elseifsubnestind = true;
                ++this.subnest;
            }
            this.state = 10;
        }
        if (mtob.isEndofLine()) {
            if (this.line.isEmpty()) {
                return null;
            }
            if (!this.line.isEmpty()) {
                this.block.add(this.line);
            }
            this.line = new OneLine();
            return null;
        }
        if (conj.equals(".")) {
            this.line.modAddLine(conj);
        } else {
            this.line.addLine(conj);
        }
        return null;
    }

    private ProcessBlock state2(MemToProBlTrans mtob) {
        switch (mtob.getWordDatatype()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.state = 0;
                return null;
            }
        }
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent() || conj.equals("\n")) {
            this.state = 3;
            return null;
        }
        if (WRwSplitChars.isSettoMark(conj)) {
            this.retind = false;
            this.state = 0;
            return null;
        }
        if (WRwSplitChars.isKakkoStart(conj)) {
            if (!conj.equals("(")) {
                throw new IllegalAccessError();
            }
        } else {
            this.retind = false;
            this.state = 0;
            return null;
        }
        this.endconj = ")";
        this.endword = null;
        this.state = 100;
        return null;
    }

    private ProcessBlock state3(MemToProBlTrans mtob) {
        if (mtob.isMemObject()) {
            throw new IllegalArgumentException();
        }
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent() || conj.equals("\n")) {
            this.state = 3;
            return null;
        }
        if (WRwSplitChars.isSettoMark(conj)) {
            this.retind = false;
            this.state = 0;
            return null;
        }
        if (WRwSplitChars.isKakkoStart(conj)) {
            if (!conj.equals("(")) {
                throw new IllegalAccessError();
            }
        } else {
            this.retind = false;
            this.state = 0;
            return null;
        }
        this.endconj = ")";
        this.endword = null;
        this.state = 100;
        return null;
    }

    private ProcessBlock state4(MemToProBlTrans mtob) {
        throw new Error();
    }

    private ProcessBlock state10(MemToProBlTrans mtob) {
        this.retind = false;
        this.state = 1;
        switch (mtob.getWordDatatype()) {
            case 1: {
                return this.newBlock2(mtob);
            }
            case 0: {
                return null;
            }
            case 5: {
                this.state = 0;
                return this.newBlock(mtob);
            }
        }
        return this.newBlock2(mtob);
    }

    private ProcessBlock state100(MemToProBlTrans mtob) {
        if (mtob.isMemObject()) {
            return null;
        }
        SentPart sp = mtob.getSentPart();
        if (sp.contain(this.endword, this.endconj)) {
            this.state = 0;
            this.endword = null;
            this.endconj = null;
        }
        return null;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("blockno=" + this.blockno + "  nest=" + this.nest + "  -nest=" + this.subnest + "  state=" + this.state + "\n");
        for (OneLine ol : this.block) {
            retval.append(ol.toLog());
        }
        retval.append("\n");
        return retval.toString();
    }

    public boolean chkSMP() {
        ArrayList<MemObject> allrefmo = new ArrayList<MemObject>();
        ArrayList<MemObject> allsetmo = new ArrayList<MemObject>();
        Iterator<OneLine> it = this.block.iterator();
        while (it.hasNext()) {
            ArrayList<MemObject> mos;
            OneLine ol = it.next();
            CtoErlangTrans cet = ol.getLine();
            int offset = ElementLoop.getBBtopOffset(cet);
            for (int i = 1; i < offset; ++i) {
                it.next();
            }
            if (offset > 0) continue;
            ElementBasic eb = cet.isSetSent();
            if (eb != null) {
                if (!allsetmo.contains(cet.getMemObj())) {
                    allsetmo.add(cet.getMemObj());
                }
                eb.setEleA("");
                mos = eb.collectMemobj();
                allrefmo.addAll(mos);
                cet = cet.getNext();
            }
            mos = cet.getRefMemObj();
            allrefmo.addAll(mos);
        }
        Iterator itm = allsetmo.iterator();
        while (itm.hasNext()) {
            if (!allrefmo.contains(itm.next())) continue;
            return false;
        }
        return this.isLoop();
    }

    public InputMemnames getAllinput() {
        return this.allinput;
    }

    public void setAllinput(InputMemnames allinput) {
        this.allinput = allinput;
    }

    public ProcessBlock getChildnest() {
        return this.nextnest;
    }

    public void setNextnest(ProcessBlock nextnest) {
        this.nextnest = nextnest;
    }

    private class OneLine
    implements Serializable {
        private static final long serialVersionUID = 201003050002000003L;
        private int switchcaseval = -1;
        private ArrayList<OneTick> line = new ArrayList();

        private OneLine() {
        }

        private void addLine(String addstr) {
            this.line.add(new OneTick(addstr));
        }

        private void addLine(MemObject addstr) {
            this.line.add(new OneTick(addstr));
        }

        private void modAddLine(String modstr) {
            OneTick ot = this.getLast();
            if (ot.mobj == null) {
                throw new Error();
            }
            ot.tick = ot.tick + modstr;
        }

        private OneTick getTop() {
            if (this.line.isEmpty()) {
                return null;
            }
            return this.line.get(0);
        }

        private boolean isEmpty() {
            return this.line.isEmpty();
        }

        private OneTick getLast() {
            return this.line.get(this.line.size() - 1);
        }

        private CtoErlangTrans getLine() {
            CtoErlangTrans top = null;
            for (OneTick ot : this.line) {
                if (top == null) {
                    top = ot.getCET();
                    continue;
                }
                top.addnext(ot.getCET());
            }
            return top;
        }

        private String toLog() {
            StringBuffer retval = new StringBuffer();
            retval.append("  Line=");
            for (OneTick ot : this.line) {
                retval.append(ot.toLog());
            }
            retval.append("\n");
            return retval.toString();
        }
    }

    private class OneTick
    implements Serializable {
        private static final long serialVersionUID = 201003050002000004L;
        private String tick;
        private MemObject mobj;

        private OneTick(String onetick) {
            this.tick = onetick;
        }

        private OneTick(MemObject onetick) {
            this.mobj = onetick;
        }

        private boolean isCondition() {
            if (this.mobj != null) {
                return false;
            }
            return WordSystemRev.isStructTypeWord(this.tick);
        }

        private boolean isInSwitch() {
            if (this.mobj != null) {
                return false;
            }
            return WordSystemRev.isStructTypeSwitch(this.tick);
        }

        private boolean isStrcType2() {
            if (this.mobj != null) {
                return false;
            }
            return WordSystemRev.isStructType2Word(this.tick);
        }

        private boolean isLoop() {
            return this.getCET().isLoopLine();
        }

        private CtoErlangTrans getCET() {
            if (this.mobj != null) {
                return new CtoErlangTrans(this.mobj);
            }
            return new CtoErlangTrans(this.tick);
        }

        public String toLog() {
            StringBuffer retval = new StringBuffer();
            if (this.tick != null) {
                retval.append(this.tick);
            } else {
                retval.append("[");
                retval.append(this.mobj.getName());
                retval.append("]");
            }
            retval.append(" ");
            return retval.toString();
        }
    }
}

