/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.EnumTypeData;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.MemToProBlTrans;
import analyzecodeC.decode.ProcessBlock;
import analyzecodeC.decode.ProcessRoute;
import analyzecodeC.decode.StructtypeData;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessKakko
implements Serializable {
    private static final long serialVersionUID = 201002060001000001L;
    private String path;
    private HashMap<String, StructtypeData> structdats;
    private HashMap<String, EnumTypeData> enumdats;
    private HashMap<String, SentPart[]> extracsysword;
    private String modname;
    private ProcessKakko parent = null;
    private ArrayList<ProcessKakko> chscops = new ArrayList();
    private String scopname;
    private MemObjects paras;
    private int state = 0;
    private MemObjects inmems = null;
    private ArrayList<ProcessBlock> blocks = new ArrayList();
    private ProcessBlock block = new ProcessBlock(this);
    private MyUtil.ArrayObject tempsps = new MyUtil.ArrayObject();
    private String temptitle = null;
    private InputMemnames input;

    public ProcessKakko(String name) {
        this.scopname = name;
        this.block.setBlockno(0);
        this.blocks.add(this.block);
        this.modname = null;
        this.structdats = null;
        this.extracsysword = null;
        this.enumdats = null;
    }

    public ProcessKakko(String modname, String name) {
        this(name);
        this.modname = modname;
        this.structdats = new HashMap();
        this.extracsysword = new HashMap();
        this.enumdats = new HashMap();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HashMap<String, StructtypeData> getStructdats() {
        if (this.parent != null) {
            return this.parent.getStructdats();
        }
        return this.structdats;
    }

    public HashMap<String, EnumTypeData> getEnumdats() {
        if (this.parent != null) {
            return this.parent.getEnumdats();
        }
        return this.enumdats;
    }

    public HashMap<String, SentPart[]> getExtracysword() {
        if (this.parent != null) {
            return this.parent.getExtracysword();
        }
        return this.extracsysword;
    }

    public String getModname() {
        return this.modname;
    }

    public ProcessKakko getParent() {
        return this.parent;
    }

    public ProcessKakko getChild(String name) {
        for (ProcessKakko pk : this.chscops) {
            if (!pk.scopname.equals(name)) continue;
            return pk;
        }
        return null;
    }

    public String[] getChildList() {
        ArrayList<String> retval = new ArrayList<String>();
        for (ProcessKakko pk : this.chscops) {
            retval.add(pk.scopname);
        }
        String[] ret = new String[retval.size()];
        retval.toArray(ret);
        return ret;
    }

    public ProcessKakko[] getChildPks() {
        ArrayList<ProcessKakko> retval = new ArrayList<ProcessKakko>();
        for (ProcessKakko pk : this.chscops) {
            retval.add(pk);
        }
        ProcessKakko[] ret = new ProcessKakko[retval.size()];
        retval.toArray(ret);
        return ret;
    }

    public String getScopname() {
        return this.scopname;
    }

    public MemObjects getParas() {
        return this.paras;
    }

    public ProcessRoute getRoutes() {
        ProcessRoute retval = new ProcessRoute();
        for (ProcessBlock pb : this.blocks) {
            retval.addBlock(pb);
        }
        return retval;
    }

    public void setInmems(MemObjects inmem) {
        this.inmems = inmem;
    }

    public MemObjects getInmems() {
        return this.inmems;
    }

    public ProcessKakko exeStateTrans(SentPart sp) {
        boolean befor = this.inmems.isIgnoring();
        MemToProBlTrans mtob = this.inmems.exeStateTrans(sp);
        if (befor || this.inmems.isIgnoring()) {
            return null;
        }
        ProcessBlock blockret = this.block.exeStateTrans(mtob);
        if (blockret != null) {
            blockret.setBlockno(this.blocks.size());
            this.blocks.add(blockret);
            this.block = blockret;
        }
        return this.state(sp);
    }

    private ProcessKakko state(SentPart sp) {
        int evt = this.analyze(sp);
        switch (evt) {
            case 1: {
                ++this.state;
                return null;
            }
            case 4: {
                ++this.state;
                return null;
            }
            case 11: {
                this.temptitle = this.srTitle();
                ProcessKakko retval = this.addChild(this.temptitle);
                retval.paras = this.creParas();
                retval.creInput(retval.paras);
                this.temptitle = null;
                this.tempsps.clear();
                return retval;
            }
            case 2: {
                --this.state;
                if (this.state < 0) {
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent;
                }
                return null;
            }
        }
        return null;
    }

    private int analyze(SentPart sp) {
        if (WordSystemRev.isStructTypeWord(sp)) {
            this.temptitle = sp.getWord();
        } else {
            this.tempsps.add(sp);
        }
        if (sp.contain(null, "{")) {
            if (this.temptitle != null) {
                return 1;
            }
            if (this.chkFunk()) {
                return 11;
            }
            return 4;
        }
        if (sp.contain(null, "}")) {
            return 2;
        }
        return 0;
    }

    public InputMemnames getInput() {
        return this.input;
    }

    private ProcessKakko addChild(String kaname) {
        ProcessKakko nsp = new ProcessKakko(kaname);
        nsp.parent = this;
        this.chscops.add(nsp);
        try {
            MemObjects inmemnew = (MemObjects)this.inmems.clone();
            inmemnew.setKakko(nsp);
            nsp.setInmems(inmemnew);
        }
        catch (CloneNotSupportedException cs) {
            throw new IllegalAccessError();
        }
        return nsp;
    }

    private String srTitle() {
        int hit = 0;
        this.tempsps.last();
        block4: while (this.tempsps.hasPrevious()) {
            SentPart bfsp = (SentPart)this.tempsps.previous();
            String conj = bfsp.getConjunc();
            String word = bfsp.getWord();
            switch (hit) {
                case 1: {
                    if (conj == null || !conj.equals("(")) continue block4;
                    if (word != null && !word.equals("") && !word.equals(" ")) {
                        return word;
                    }
                    hit = 2;
                    continue block4;
                }
                case 2: {
                    if (word == null || word.equals("") || word.equals(" ")) continue block4;
                    return word;
                }
            }
            if (conj != null && conj.equals(")")) {
                hit = 1;
                continue;
            }
            if (word == null || word.equals("") || word.equals(" ")) continue;
            return word;
        }
        return null;
    }

    private boolean chkFunk() {
        int hit = 0;
        this.tempsps.last();
        block3: while (this.tempsps.hasPrevious()) {
            SentPart bfsp = (SentPart)this.tempsps.previous();
            String conj = bfsp.getConjunc();
            switch (hit) {
                case 1: {
                    if (conj == null || !conj.equals("(")) continue block3;
                    return true;
                }
            }
            if (conj == null || !conj.equals(")")) continue;
            hit = 1;
        }
        return false;
    }

    private MemObjects creParas() {
        SentPart bfsp;
        MemObjects retval = new MemObjects();
        retval.setKakko(this);
        int firidx = -1;
        int stopper = 0;
        this.tempsps.last();
        while (this.tempsps.hasPrevious()) {
            bfsp = (SentPart)this.tempsps.previous();
            String conj = bfsp.getConjunc();
            if (conj != null && conj.equals("(")) {
                firidx = this.tempsps.getLatestCursor() + 1;
                break;
            }
            if (conj == null || !conj.equals(")")) continue;
            stopper = this.tempsps.getLatestCursor() + 1;
        }
        if (firidx < 0) {
            return null;
        }
        while (firidx < stopper) {
            bfsp = (SentPart)this.tempsps.getValue(firidx);
            retval.exeStateTrans(bfsp);
            ++firidx;
        }
        return retval;
    }

    private void creInput(MemObjects inmem) {
        this.input = new InputMemnames();
        Hashtable<String, MemObject> out = new Hashtable<String, MemObject>();
        inmem.getMemObjects(out);
        Enumeration<String> em = out.keys();
        while (em.hasMoreElements()) {
            String key = em.nextElement();
            MemObject mo = out.get(key);
            this.input.putInput(mo);
        }
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("scopname = " + this.scopname + "\n");
        retval.append(this.inmems.toLog());
        for (ProcessBlock pb : this.blocks) {
            retval.append(pb.toLog());
        }
        return retval.toString();
    }
}

