/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.ProcessBlock;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRoute
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060013000001L;
    private Route getrtnow = null;
    private RouteTick getnow = null;
    private Route toprt = null;
    private AnllingRouteChain anltop = null;
    private int nowaddnest = 0;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean first() {
        this.getrtnow = this.toprt;
        return this.getrtnow != null;
    }

    public int getRouteSize() {
        int retval = 0;
        Route nrt = this.toprt;
        while (nrt != null) {
            ++retval;
            nrt = nrt.nextroute;
        }
        return retval;
    }

    public boolean hasNext() {
        return this.getrtnow != null;
    }

    public int next() {
        int retval = this.getrtnow.rtno;
        this.getrtnow = this.getrtnow.nextroute;
        return retval;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("--------<ProcessRoute>------------\n");
        this.first();
        while (this.hasNext()) {
            int rtno = this.next();
            ProcessBlock[] pbs = this.getRouteProBlocks(rtno);
            retval.append("### rtno = " + rtno + " ###\n");
            for (int i = 0; i < pbs.length; ++i) {
                retval.append("++ blockno = " + pbs[i].getBlockno() + " ++\n");
            }
            retval.append("\n");
        }
        return retval.toString();
    }

    public ProcessBlock[] getRouteProBlocks(int getrtno) {
        ArrayList<ProcessBlock> out = new ArrayList<ProcessBlock>();
        Route chk = this.toprt;
        while (chk != null && chk.rtno != getrtno) {
            chk = chk.nextroute;
        }
        if (chk == null) {
            return new ProcessBlock[0];
        }
        int befornest = -1;
        ProcessBlock beforpb = null;
        RouteTick rt = chk.mytop;
        while (rt != null) {
            if (beforpb == null || beforpb.getChildnest() != null) {
                // empty if block
            }
            if (beforpb != null) {
                if (befornest < rt.tick.getNest()) {
                    beforpb.setNextnest(rt.tick);
                } else {
                    beforpb.setNextnest(null);
                }
            }
            befornest = rt.tick.getNest();
            beforpb = rt.tick;
            out.add(rt.tick);
            rt = rt.nextBlock;
        }
        ProcessBlock[] retval = new ProcessBlock[out.size()];
        out.toArray(retval);
        return retval;
    }

    public BasicBlock[] getRouteBsBlocks(int getrtno) {
        ProcessBlock[] pbs = this.getRouteProBlocks(getrtno);
        BasicBlock[] retval = new BasicBlock[pbs.length];
        for (int i = 0; i < pbs.length; ++i) {
            retval[i] = pbs[i].getBasicBlock();
        }
        return retval;
    }

    private Route getLast() {
        Route rt = this.toprt.nextroute;
        Route retval = this.toprt;
        while (rt != null) {
            retval = rt;
            rt = rt.nextroute;
        }
        return retval;
    }

    private void AnlingChainAttach(AnllingRouteChain atarq) {
        if (this.anltop == null) {
            this.anltop = atarq;
            this.anltop.befor = null;
            this.anltop.next = null;
            return;
        }
        this.anltop.befor = atarq;
        atarq.next = this.anltop;
        atarq.befor = null;
        this.anltop = atarq;
    }

    private AnllingRouteChain addRoute(AnllingRouteChain atarq, int offset) {
        Route rt = atarq.route.copyRoute(offset);
        rt.addRoute();
        RouteTick tick = rt.mytop.getLastBlock();
        AnllingRouteChain arq = new AnllingRouteChain(tick, atarq.nest);
        arq.route = rt;
        rt.arc = arq;
        return arq;
    }

    private ArrayList<AnllingRouteChain> addRoute(ArrayList<AnllingRouteChain> arcs, int offset) {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        for (AnllingRouteChain arc : arcs) {
            AnllingRouteChain add = this.addRoute(arc, offset);
            retval.add(add);
        }
        return retval;
    }

    public void startAnl(ProcessBlock pb) {
        if (this.anltop != null) {
            return;
        }
        RouteTick frt = new RouteTick(pb);
        this.anltop = new AnllingRouteChain(frt, pb.getNest());
        this.toprt = new Route(frt);
        this.toprt.cplist.add(this.toprt.rtno);
        this.anltop.route = this.toprt;
        this.toprt.arc = this.anltop;
        this.nowaddnest = pb.getNest();
    }

    public void addBlock(ProcessBlock bt) {
        if (this.anltop == null) {
            this.startAnl(bt);
            return;
        }
        int nest = bt.getNest();
        if (this.nowaddnest < nest) {
            this.nowaddnest = nest;
            this.addBlock(bt, this.getNowAnlBlocks());
        } else if (this.nowaddnest == nest) {
            this.nowaddnest = nest;
            ArrayList<AnllingRouteChain> out = this.getNowAnlBlocks();
            if (bt.isElse()) {
                ArrayList<AnllingRouteChain> out2 = this.addRoute(out, 1);
                this.addBlock(bt, out2);
            } else {
                this.addBlock(bt, out);
            }
        } else {
            ArrayList<AnllingRouteChain> out = this.getNowAnlBlocks();
            if (bt.isElse()) {
                ArrayList<AnllingRouteChain> out2 = this.addRoute(out, this.nowaddnest - nest + 1);
                this.nowaddnest = nest;
                this.addBlock(bt, out2);
            } else {
                this.nowaddnest = nest;
                ArrayList<AnllingRouteChain> out2 = this.getNowAnlEqBlocks(out, nest, false);
                this.addBlock(bt, out2);
            }
        }
    }

    private int subNest(ArrayList<AnllingRouteChain> arcs) {
        int befornest = -1;
        for (AnllingRouteChain arc : arcs) {
            befornest = arc.nest - arc.subnest;
            if (befornest < 0 || befornest == arc.nest - arc.subnest) continue;
            throw new Error();
        }
        return befornest;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessRoute other = (ProcessRoute)obj;
        if (!(this.getrtnow == other.getrtnow || this.getrtnow != null && this.getrtnow.equals(other.getrtnow))) {
            return false;
        }
        if (!(this.getnow == other.getnow || this.getnow != null && this.getnow.equals(other.getnow))) {
            return false;
        }
        if (!(this.toprt == other.toprt || this.toprt != null && this.toprt.equals(other.toprt))) {
            return false;
        }
        if (!(this.anltop == other.anltop || this.anltop != null && this.anltop.equals(other.anltop))) {
            return false;
        }
        return this.nowaddnest == other.nowaddnest;
    }

    private ArrayList<AnllingRouteChain> getNowAnlBlocks() {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        AnllingRouteChain arc = this.anltop;
        while (arc != null) {
            if (retval.contains(arc)) {
                throw new Error();
            }
            retval.add(arc);
            arc = arc.next;
        }
        return retval;
    }

    private ArrayList<AnllingRouteChain> getNowAnlEqBlocks(ArrayList<AnllingRouteChain> arcs, int nest, boolean chknest) {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        for (AnllingRouteChain arc : arcs) {
            Route inrt = arc.route;
            Route srrt = this.toprt;
            while (srrt != null) {
                if (inrt.eqRoute(nest, srrt)) {
                    if (chknest) {
                        if (srrt.arc.nest < nest && !retval.contains(srrt.arc)) {
                            retval.add(srrt.arc);
                        }
                    } else if (!retval.contains(srrt.arc)) {
                        retval.add(srrt.arc);
                    }
                }
                srrt = srrt.nextroute;
            }
        }
        return retval;
    }

    private void addBlock(ProcessBlock pb, ArrayList<AnllingRouteChain> arcs) {
        this.anltop = null;
        for (AnllingRouteChain arc : arcs) {
            RouteTick rtic = arc.anlling.addBlockLink(pb);
            arc.modAnlling(rtic, this.nowaddnest);
            this.AnlingChainAttach(arc);
        }
    }

    private class AnllingRouteChain
    implements Serializable {
        private RouteTick anlling = null;
        private static final long serialVersionUID = 201003050013000005L;
        private AnllingRouteChain next = null;
        private AnllingRouteChain befor = null;
        private int nest = 0;
        private Route route = null;
        private int subnest = 0;

        private AnllingRouteChain(RouteTick my, int waitnest) {
            this.anlling = my;
            this.nest = waitnest;
        }

        private void modAnlling(RouteTick my, int newnest) {
            this.anlling = my;
            this.nest = newnest;
            this.subnest = my.tick.getSubNest();
        }
    }

    private class RouteTick
    implements Serializable {
        private static final long serialVersionUID = 201003050013000016L;
        private ProcessBlock tick;
        private RouteTick beforBlock;
        private RouteTick nextBlock;

        private RouteTick(ProcessBlock pb) {
            this.tick = pb;
        }

        private RouteTick getLastBlock() {
            RouteTick rt = this.nextBlock;
            RouteTick retval = this;
            while (rt != null) {
                retval = rt;
                rt = rt.nextBlock;
            }
            return retval;
        }

        private RouteTick addBlockLink(ProcessBlock pb) {
            this.nextBlock = new RouteTick(pb);
            this.nextBlock.beforBlock = this;
            return this.nextBlock;
        }
    }

    private class Route
    implements Serializable {
        private static final long serialVersionUID = 201003050013000017L;
        private int rtno = 1;
        private RouteTick mytop = null;
        private Route nextroute = null;
        private AnllingRouteChain arc = null;
        private MyUtil.PrimitiveArrayI cplist = new MyUtil.PrimitiveArrayI();

        private Route(RouteTick rt) {
            this.mytop = rt;
        }

        private Route(RouteTick rt, int routeno) {
            this(rt);
            this.rtno = routeno;
        }

        private boolean eqRoute(int chknest, Route cmp) {
            for (int i = 0; i < cmp.cplist.size() && i < this.cplist.size() && i < chknest - 1; ++i) {
                if (this.cplist.getValue(i) == cmp.cplist.getValue(i)) continue;
                return false;
            }
            return true;
        }

        private void addRoute() {
            ((ProcessRoute)ProcessRoute.this).getLast().nextroute = this;
        }

        private Route copyRoute(int offset) {
            RouteTick cprt = new RouteTick(this.mytop.tick);
            int rtnonew = ((ProcessRoute)ProcessRoute.this).getLast().rtno + 1;
            Route retval = new Route(cprt, rtnonew);
            retval.cplist.addAll(this.cplist);
            retval.cplist.add(rtnonew);
            RouteTick rt = this.mytop;
            int count = 0;
            while (rt != null) {
                ++count;
                rt = rt.nextBlock;
            }
            rt = this.mytop.nextBlock;
            int roop = 1;
            while (rt != null && count - roop > offset) {
                cprt = cprt.addBlockLink(rt.tick);
                rt = rt.nextBlock;
                ++roop;
            }
            return retval;
        }
    }
}

