/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.WRwSplitChars;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementBasic
extends Element
implements Serializable {
    private static final long serialVersionUID = 201002060019000001L;

    public static ElementBasic creBasic(ArrayList<CtoErlangTrans> objs) {
        ElementBasic retval;
        ElementBasic now = retval = new ElementBasic();
        int abcidx = 0;
        for (CtoErlangTrans obj : objs) {
            if (now.setEle(obj, abcidx++)) {
                if (abcidx <= 2) continue;
                ElementBasic rep = new ElementBasic();
                now.setEleC(rep);
                now = rep;
                abcidx = 0;
                now.setEle(obj, abcidx++);
                continue;
            }
            throw new Error();
        }
        return retval;
    }

    public static ElementBasic creBasic(CtoErlangTrans a, CtoErlangTrans b) {
        ElementBasic retval = null;
        if (b.getString() == null) {
            return null;
        }
        String strb = b.getString();
        if (a.getString() != null && a.getString().equals("~")) {
            retval = ElementBasic.ctoErlbnot(a);
        } else if (strb.equals("++")) {
            retval = ElementBasic.ctoErlpp(a);
        } else if (strb.equals("--")) {
            retval = ElementBasic.ctoErlmm(a);
        } else if (strb.equals("!")) {
            retval = ElementBasic.ctoErlb(null, " not ", a);
        } else {
            return null;
        }
        return retval;
    }

    public static ElementBasic creBasic(CtoErlangTrans nea, CtoErlangTrans cb, CtoErlangTrans c) {
        ElementBasic retval = null;
        String b = cb.getString();
        if (b == null) {
            return null;
        }
        if (b.equals("=")) {
            retval = ElementBasic.ctoErlb(nea, "=", c);
        } else if (b.equals("+")) {
            retval = ElementBasic.ctoErlb(nea, "+", c);
        } else if (b.equals("-")) {
            retval = ElementBasic.ctoErlb(nea, "-", c);
        } else if (b.equals("*")) {
            retval = ElementBasic.ctoErlb(nea, "*", c);
        } else if (b.equals("%")) {
            retval = ElementBasic.ctoErlb(nea, "rem", c);
        } else if (b.equals("/") && c.getString() != null && c.getString().contains(".")) {
            retval = ElementBasic.ctoErlb(nea, "/", c);
        } else if (b.equals("/")) {
            retval = ElementBasic.ctoErlb(nea, "div", c);
        } else if (b.equals("&")) {
            retval = ElementBasic.ctoErlb(nea, "band", c);
        } else if (b.equals("|")) {
            retval = ElementBasic.ctoErlb(nea, "bor", c);
        } else if (b.equals("^")) {
            retval = ElementBasic.ctoErlb(nea, "bxor", c);
        } else if (b.equals("<<")) {
            retval = ElementBasic.ctoErlb(nea, "bsl", c);
        } else if (b.equals(">>")) {
            retval = ElementBasic.ctoErlb(nea, "bsr", c);
        } else if (b.equals("==")) {
            retval = ElementBasic.ctoErlb(nea, "=:=", c);
        } else if (b.equals("!=")) {
            retval = ElementBasic.ctoErlb(nea, "=/=", c);
        } else if (b.equals("<=")) {
            retval = ElementBasic.ctoErlb(nea, "=<", c);
        } else if (b.equals(">=")) {
            retval = ElementBasic.ctoErlb(nea, ">=", c);
        } else if (b.equals(">")) {
            retval = ElementBasic.ctoErlb(nea, ">", c);
        } else if (b.equals("<")) {
            retval = ElementBasic.ctoErlb(nea, "<", c);
        } else if (b.equals("+=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "+", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("-=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "-", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("*=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "*", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("%=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "%", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("/=") && c.getString() != null && c.getString().contains(".")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "/", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("/=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "div", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("<<=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "bsl", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals(">>=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "bsr", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("&=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "band", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("|=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "bor", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("^=")) {
            ElementBasic chl = ElementBasic.ctoErlb(nea, "bxor", c);
            retval = ElementBasic.ctoErlb(nea, "=", chl);
        } else if (b.equals("&&")) {
            retval = ElementBasic.ctoErlb(nea, "and", c);
        } else if (b.equals("||")) {
            retval = ElementBasic.ctoErlb(nea, "or", c);
        } else {
            return null;
        }
        return retval;
    }

    private static ElementBasic ctoErlbnot(CtoErlangTrans a) {
        ElementBasic retval = ElementBasic.ctoErlb(null, "bnot", a);
        return retval;
    }

    private static ElementBasic ctoErlpp(CtoErlangTrans a) {
        ElementBasic chil = ElementBasic.ctoErlb(a, "+", "1");
        ElementBasic retval = ElementBasic.ctoErlb(a, "=", chil);
        return retval;
    }

    private static ElementBasic ctoErlmm(CtoErlangTrans a) {
        ElementBasic chil = ElementBasic.ctoErlb(a, "-", "1");
        ElementBasic retval = ElementBasic.ctoErlb(a, "=", chil);
        return retval;
    }

    private static ElementBasic ctoErlb(CtoErlangTrans a, String b, CtoErlangTrans c) {
        ElementBasic retval = new ElementBasic();
        if (a.getMemObj() != null) {
            retval.setEleA(a.getMemObj());
        } else if (WRwSplitChars.isKakkoEnd(a.getString())) {
            retval.setEleA("");
        } else {
            retval.setEleA(a.getString());
        }
        retval.setEleB(b);
        if (c.getMemObj() != null) {
            retval.setEleC(c.getMemObj());
        } else {
            retval.setEleC(c.getString());
        }
        return retval;
    }

    public static ElementBasic ctoErlb(CtoErlangTrans a, String b, Element c) {
        ElementBasic retval = new ElementBasic();
        if (a.getMemObj() != null) {
            retval.setEleA(a.getMemObj());
        } else if (WRwSplitChars.isKakkoEnd(a.getString())) {
            retval.setEleA("");
        } else {
            retval.setEleA(a.getString());
        }
        retval.setEleB(b);
        retval.setEleC(c);
        return retval;
    }

    private static ElementBasic ctoErlb(CtoErlangTrans a, String b, String c) {
        ElementBasic retval = new ElementBasic();
        if (a.getMemObj() != null) {
            retval.setEleA(a.getMemObj());
        } else if (WRwSplitChars.isKakkoEnd(a.getString())) {
            retval.setEleA("");
        } else {
            retval.setEleA(a.getString());
        }
        retval.setEleB(b);
        retval.setEleC(c);
        return retval;
    }

    private static String valCToErl(String val) {
        String after = val.substring(1);
        String bef = val.substring(0, 1);
        bef = bef.toUpperCase();
        return bef + after;
    }
}

